/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class H264QvbrSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, H264QvbrSettings> {
    private static final SdkField<Integer> MAX_AVERAGE_BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxAverageBitrate").getter(H264QvbrSettings.getter(H264QvbrSettings::maxAverageBitrate)).setter(H264QvbrSettings.setter(Builder::maxAverageBitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxAverageBitrate").build()}).build();
    private static final SdkField<Integer> QVBR_QUALITY_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("QvbrQualityLevel").getter(H264QvbrSettings.getter(H264QvbrSettings::qvbrQualityLevel)).setter(H264QvbrSettings.setter(Builder::qvbrQualityLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qvbrQualityLevel").build()}).build();
    private static final SdkField<Double> QVBR_QUALITY_LEVEL_FINE_TUNE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("QvbrQualityLevelFineTune").getter(H264QvbrSettings.getter(H264QvbrSettings::qvbrQualityLevelFineTune)).setter(H264QvbrSettings.setter(Builder::qvbrQualityLevelFineTune)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qvbrQualityLevelFineTune").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_AVERAGE_BITRATE_FIELD, QVBR_QUALITY_LEVEL_FIELD, QVBR_QUALITY_LEVEL_FINE_TUNE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer maxAverageBitrate;
    private final Integer qvbrQualityLevel;
    private final Double qvbrQualityLevelFineTune;

    private H264QvbrSettings(BuilderImpl builder) {
        this.maxAverageBitrate = builder.maxAverageBitrate;
        this.qvbrQualityLevel = builder.qvbrQualityLevel;
        this.qvbrQualityLevelFineTune = builder.qvbrQualityLevelFineTune;
    }

    public final Integer maxAverageBitrate() {
        return this.maxAverageBitrate;
    }

    public final Integer qvbrQualityLevel() {
        return this.qvbrQualityLevel;
    }

    public final Double qvbrQualityLevelFineTune() {
        return this.qvbrQualityLevelFineTune;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAverageBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.qvbrQualityLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.qvbrQualityLevelFineTune());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof H264QvbrSettings)) {
            return false;
        }
        H264QvbrSettings other = (H264QvbrSettings)obj;
        return Objects.equals(this.maxAverageBitrate(), other.maxAverageBitrate()) && Objects.equals(this.qvbrQualityLevel(), other.qvbrQualityLevel()) && Objects.equals(this.qvbrQualityLevelFineTune(), other.qvbrQualityLevelFineTune());
    }

    public final String toString() {
        return ToString.builder((String)"H264QvbrSettings").add("MaxAverageBitrate", (Object)this.maxAverageBitrate()).add("QvbrQualityLevel", (Object)this.qvbrQualityLevel()).add("QvbrQualityLevelFineTune", (Object)this.qvbrQualityLevelFineTune()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxAverageBitrate": {
                return Optional.ofNullable(clazz.cast(this.maxAverageBitrate()));
            }
            case "QvbrQualityLevel": {
                return Optional.ofNullable(clazz.cast(this.qvbrQualityLevel()));
            }
            case "QvbrQualityLevelFineTune": {
                return Optional.ofNullable(clazz.cast(this.qvbrQualityLevelFineTune()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<H264QvbrSettings, T> g) {
        return obj -> g.apply((H264QvbrSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maxAverageBitrate;
        private Integer qvbrQualityLevel;
        private Double qvbrQualityLevelFineTune;

        private BuilderImpl() {
        }

        private BuilderImpl(H264QvbrSettings model) {
            this.maxAverageBitrate(model.maxAverageBitrate);
            this.qvbrQualityLevel(model.qvbrQualityLevel);
            this.qvbrQualityLevelFineTune(model.qvbrQualityLevelFineTune);
        }

        public final Integer getMaxAverageBitrate() {
            return this.maxAverageBitrate;
        }

        public final void setMaxAverageBitrate(Integer maxAverageBitrate) {
            this.maxAverageBitrate = maxAverageBitrate;
        }

        @Override
        @Transient
        public final Builder maxAverageBitrate(Integer maxAverageBitrate) {
            this.maxAverageBitrate = maxAverageBitrate;
            return this;
        }

        public final Integer getQvbrQualityLevel() {
            return this.qvbrQualityLevel;
        }

        public final void setQvbrQualityLevel(Integer qvbrQualityLevel) {
            this.qvbrQualityLevel = qvbrQualityLevel;
        }

        @Override
        @Transient
        public final Builder qvbrQualityLevel(Integer qvbrQualityLevel) {
            this.qvbrQualityLevel = qvbrQualityLevel;
            return this;
        }

        public final Double getQvbrQualityLevelFineTune() {
            return this.qvbrQualityLevelFineTune;
        }

        public final void setQvbrQualityLevelFineTune(Double qvbrQualityLevelFineTune) {
            this.qvbrQualityLevelFineTune = qvbrQualityLevelFineTune;
        }

        @Override
        @Transient
        public final Builder qvbrQualityLevelFineTune(Double qvbrQualityLevelFineTune) {
            this.qvbrQualityLevelFineTune = qvbrQualityLevelFineTune;
            return this;
        }

        public H264QvbrSettings build() {
            return new H264QvbrSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, H264QvbrSettings> {
        public Builder maxAverageBitrate(Integer var1);

        public Builder qvbrQualityLevel(Integer var1);

        public Builder qvbrQualityLevelFineTune(Double var1);
    }
}

