/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.CmafAdditionalManifest;
import software.amazon.awssdk.services.mediaconvert.model.CmafClientCache;
import software.amazon.awssdk.services.mediaconvert.model.CmafCodecSpecification;
import software.amazon.awssdk.services.mediaconvert.model.CmafEncryptionSettings;
import software.amazon.awssdk.services.mediaconvert.model.CmafManifestCompression;
import software.amazon.awssdk.services.mediaconvert.model.CmafManifestDurationFormat;
import software.amazon.awssdk.services.mediaconvert.model.CmafMpdProfile;
import software.amazon.awssdk.services.mediaconvert.model.CmafPtsOffsetHandlingForBFrames;
import software.amazon.awssdk.services.mediaconvert.model.CmafSegmentControl;
import software.amazon.awssdk.services.mediaconvert.model.CmafStreamInfResolution;
import software.amazon.awssdk.services.mediaconvert.model.CmafWriteDASHManifest;
import software.amazon.awssdk.services.mediaconvert.model.CmafWriteHLSManifest;
import software.amazon.awssdk.services.mediaconvert.model.CmafWriteSegmentTimelineInRepresentation;
import software.amazon.awssdk.services.mediaconvert.model.DestinationSettings;
import software.amazon.awssdk.services.mediaconvert.model.___listOfCmafAdditionalManifestCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CmafGroupSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CmafGroupSettings> {
    private static final SdkField<List<CmafAdditionalManifest>> ADDITIONAL_MANIFESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalManifests").getter(CmafGroupSettings.getter(CmafGroupSettings::additionalManifests)).setter(CmafGroupSettings.setter(Builder::additionalManifests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalManifests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CmafAdditionalManifest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> BASE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseUrl").getter(CmafGroupSettings.getter(CmafGroupSettings::baseUrl)).setter(CmafGroupSettings.setter(Builder::baseUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseUrl").build()}).build();
    private static final SdkField<String> CLIENT_CACHE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientCache").getter(CmafGroupSettings.getter(CmafGroupSettings::clientCacheAsString)).setter(CmafGroupSettings.setter(Builder::clientCache)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientCache").build()}).build();
    private static final SdkField<String> CODEC_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodecSpecification").getter(CmafGroupSettings.getter(CmafGroupSettings::codecSpecificationAsString)).setter(CmafGroupSettings.setter(Builder::codecSpecification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecSpecification").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Destination").getter(CmafGroupSettings.getter(CmafGroupSettings::destination)).setter(CmafGroupSettings.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<DestinationSettings> DESTINATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationSettings").getter(CmafGroupSettings.getter(CmafGroupSettings::destinationSettings)).setter(CmafGroupSettings.setter(Builder::destinationSettings)).constructor(DestinationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationSettings").build()}).build();
    private static final SdkField<CmafEncryptionSettings> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Encryption").getter(CmafGroupSettings.getter(CmafGroupSettings::encryption)).setter(CmafGroupSettings.setter(Builder::encryption)).constructor(CmafEncryptionSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()}).build();
    private static final SdkField<Integer> FRAGMENT_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FragmentLength").getter(CmafGroupSettings.getter(CmafGroupSettings::fragmentLength)).setter(CmafGroupSettings.setter(Builder::fragmentLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fragmentLength").build()}).build();
    private static final SdkField<String> MANIFEST_COMPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManifestCompression").getter(CmafGroupSettings.getter(CmafGroupSettings::manifestCompressionAsString)).setter(CmafGroupSettings.setter(Builder::manifestCompression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestCompression").build()}).build();
    private static final SdkField<String> MANIFEST_DURATION_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManifestDurationFormat").getter(CmafGroupSettings.getter(CmafGroupSettings::manifestDurationFormatAsString)).setter(CmafGroupSettings.setter(Builder::manifestDurationFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestDurationFormat").build()}).build();
    private static final SdkField<Integer> MIN_BUFFER_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinBufferTime").getter(CmafGroupSettings.getter(CmafGroupSettings::minBufferTime)).setter(CmafGroupSettings.setter(Builder::minBufferTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minBufferTime").build()}).build();
    private static final SdkField<Double> MIN_FINAL_SEGMENT_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MinFinalSegmentLength").getter(CmafGroupSettings.getter(CmafGroupSettings::minFinalSegmentLength)).setter(CmafGroupSettings.setter(Builder::minFinalSegmentLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minFinalSegmentLength").build()}).build();
    private static final SdkField<String> MPD_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MpdProfile").getter(CmafGroupSettings.getter(CmafGroupSettings::mpdProfileAsString)).setter(CmafGroupSettings.setter(Builder::mpdProfile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mpdProfile").build()}).build();
    private static final SdkField<String> PTS_OFFSET_HANDLING_FOR_B_FRAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PtsOffsetHandlingForBFrames").getter(CmafGroupSettings.getter(CmafGroupSettings::ptsOffsetHandlingForBFramesAsString)).setter(CmafGroupSettings.setter(Builder::ptsOffsetHandlingForBFrames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ptsOffsetHandlingForBFrames").build()}).build();
    private static final SdkField<String> SEGMENT_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentControl").getter(CmafGroupSettings.getter(CmafGroupSettings::segmentControlAsString)).setter(CmafGroupSettings.setter(Builder::segmentControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentControl").build()}).build();
    private static final SdkField<Integer> SEGMENT_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SegmentLength").getter(CmafGroupSettings.getter(CmafGroupSettings::segmentLength)).setter(CmafGroupSettings.setter(Builder::segmentLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentLength").build()}).build();
    private static final SdkField<String> STREAM_INF_RESOLUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamInfResolution").getter(CmafGroupSettings.getter(CmafGroupSettings::streamInfResolutionAsString)).setter(CmafGroupSettings.setter(Builder::streamInfResolution)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamInfResolution").build()}).build();
    private static final SdkField<String> WRITE_DASH_MANIFEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WriteDashManifest").getter(CmafGroupSettings.getter(CmafGroupSettings::writeDashManifestAsString)).setter(CmafGroupSettings.setter(Builder::writeDashManifest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("writeDashManifest").build()}).build();
    private static final SdkField<String> WRITE_HLS_MANIFEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WriteHlsManifest").getter(CmafGroupSettings.getter(CmafGroupSettings::writeHlsManifestAsString)).setter(CmafGroupSettings.setter(Builder::writeHlsManifest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("writeHlsManifest").build()}).build();
    private static final SdkField<String> WRITE_SEGMENT_TIMELINE_IN_REPRESENTATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WriteSegmentTimelineInRepresentation").getter(CmafGroupSettings.getter(CmafGroupSettings::writeSegmentTimelineInRepresentationAsString)).setter(CmafGroupSettings.setter(Builder::writeSegmentTimelineInRepresentation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("writeSegmentTimelineInRepresentation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_MANIFESTS_FIELD, BASE_URL_FIELD, CLIENT_CACHE_FIELD, CODEC_SPECIFICATION_FIELD, DESTINATION_FIELD, DESTINATION_SETTINGS_FIELD, ENCRYPTION_FIELD, FRAGMENT_LENGTH_FIELD, MANIFEST_COMPRESSION_FIELD, MANIFEST_DURATION_FORMAT_FIELD, MIN_BUFFER_TIME_FIELD, MIN_FINAL_SEGMENT_LENGTH_FIELD, MPD_PROFILE_FIELD, PTS_OFFSET_HANDLING_FOR_B_FRAMES_FIELD, SEGMENT_CONTROL_FIELD, SEGMENT_LENGTH_FIELD, STREAM_INF_RESOLUTION_FIELD, WRITE_DASH_MANIFEST_FIELD, WRITE_HLS_MANIFEST_FIELD, WRITE_SEGMENT_TIMELINE_IN_REPRESENTATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<CmafAdditionalManifest> additionalManifests;
    private final String baseUrl;
    private final String clientCache;
    private final String codecSpecification;
    private final String destination;
    private final DestinationSettings destinationSettings;
    private final CmafEncryptionSettings encryption;
    private final Integer fragmentLength;
    private final String manifestCompression;
    private final String manifestDurationFormat;
    private final Integer minBufferTime;
    private final Double minFinalSegmentLength;
    private final String mpdProfile;
    private final String ptsOffsetHandlingForBFrames;
    private final String segmentControl;
    private final Integer segmentLength;
    private final String streamInfResolution;
    private final String writeDashManifest;
    private final String writeHlsManifest;
    private final String writeSegmentTimelineInRepresentation;

    private CmafGroupSettings(BuilderImpl builder) {
        this.additionalManifests = builder.additionalManifests;
        this.baseUrl = builder.baseUrl;
        this.clientCache = builder.clientCache;
        this.codecSpecification = builder.codecSpecification;
        this.destination = builder.destination;
        this.destinationSettings = builder.destinationSettings;
        this.encryption = builder.encryption;
        this.fragmentLength = builder.fragmentLength;
        this.manifestCompression = builder.manifestCompression;
        this.manifestDurationFormat = builder.manifestDurationFormat;
        this.minBufferTime = builder.minBufferTime;
        this.minFinalSegmentLength = builder.minFinalSegmentLength;
        this.mpdProfile = builder.mpdProfile;
        this.ptsOffsetHandlingForBFrames = builder.ptsOffsetHandlingForBFrames;
        this.segmentControl = builder.segmentControl;
        this.segmentLength = builder.segmentLength;
        this.streamInfResolution = builder.streamInfResolution;
        this.writeDashManifest = builder.writeDashManifest;
        this.writeHlsManifest = builder.writeHlsManifest;
        this.writeSegmentTimelineInRepresentation = builder.writeSegmentTimelineInRepresentation;
    }

    public final boolean hasAdditionalManifests() {
        return this.additionalManifests != null && !(this.additionalManifests instanceof SdkAutoConstructList);
    }

    public final List<CmafAdditionalManifest> additionalManifests() {
        return this.additionalManifests;
    }

    public final String baseUrl() {
        return this.baseUrl;
    }

    public final CmafClientCache clientCache() {
        return CmafClientCache.fromValue(this.clientCache);
    }

    public final String clientCacheAsString() {
        return this.clientCache;
    }

    public final CmafCodecSpecification codecSpecification() {
        return CmafCodecSpecification.fromValue(this.codecSpecification);
    }

    public final String codecSpecificationAsString() {
        return this.codecSpecification;
    }

    public final String destination() {
        return this.destination;
    }

    public final DestinationSettings destinationSettings() {
        return this.destinationSettings;
    }

    public final CmafEncryptionSettings encryption() {
        return this.encryption;
    }

    public final Integer fragmentLength() {
        return this.fragmentLength;
    }

    public final CmafManifestCompression manifestCompression() {
        return CmafManifestCompression.fromValue(this.manifestCompression);
    }

    public final String manifestCompressionAsString() {
        return this.manifestCompression;
    }

    public final CmafManifestDurationFormat manifestDurationFormat() {
        return CmafManifestDurationFormat.fromValue(this.manifestDurationFormat);
    }

    public final String manifestDurationFormatAsString() {
        return this.manifestDurationFormat;
    }

    public final Integer minBufferTime() {
        return this.minBufferTime;
    }

    public final Double minFinalSegmentLength() {
        return this.minFinalSegmentLength;
    }

    public final CmafMpdProfile mpdProfile() {
        return CmafMpdProfile.fromValue(this.mpdProfile);
    }

    public final String mpdProfileAsString() {
        return this.mpdProfile;
    }

    public final CmafPtsOffsetHandlingForBFrames ptsOffsetHandlingForBFrames() {
        return CmafPtsOffsetHandlingForBFrames.fromValue(this.ptsOffsetHandlingForBFrames);
    }

    public final String ptsOffsetHandlingForBFramesAsString() {
        return this.ptsOffsetHandlingForBFrames;
    }

    public final CmafSegmentControl segmentControl() {
        return CmafSegmentControl.fromValue(this.segmentControl);
    }

    public final String segmentControlAsString() {
        return this.segmentControl;
    }

    public final Integer segmentLength() {
        return this.segmentLength;
    }

    public final CmafStreamInfResolution streamInfResolution() {
        return CmafStreamInfResolution.fromValue(this.streamInfResolution);
    }

    public final String streamInfResolutionAsString() {
        return this.streamInfResolution;
    }

    public final CmafWriteDASHManifest writeDashManifest() {
        return CmafWriteDASHManifest.fromValue(this.writeDashManifest);
    }

    public final String writeDashManifestAsString() {
        return this.writeDashManifest;
    }

    public final CmafWriteHLSManifest writeHlsManifest() {
        return CmafWriteHLSManifest.fromValue(this.writeHlsManifest);
    }

    public final String writeHlsManifestAsString() {
        return this.writeHlsManifest;
    }

    public final CmafWriteSegmentTimelineInRepresentation writeSegmentTimelineInRepresentation() {
        return CmafWriteSegmentTimelineInRepresentation.fromValue(this.writeSegmentTimelineInRepresentation);
    }

    public final String writeSegmentTimelineInRepresentationAsString() {
        return this.writeSegmentTimelineInRepresentation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalManifests() ? this.additionalManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.baseUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientCacheAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecSpecificationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.fragmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestCompressionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestDurationFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minBufferTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.minFinalSegmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.mpdProfileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ptsOffsetHandlingForBFramesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamInfResolutionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeDashManifestAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeHlsManifestAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeSegmentTimelineInRepresentationAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CmafGroupSettings)) {
            return false;
        }
        CmafGroupSettings other = (CmafGroupSettings)obj;
        return this.hasAdditionalManifests() == other.hasAdditionalManifests() && Objects.equals(this.additionalManifests(), other.additionalManifests()) && Objects.equals(this.baseUrl(), other.baseUrl()) && Objects.equals(this.clientCacheAsString(), other.clientCacheAsString()) && Objects.equals(this.codecSpecificationAsString(), other.codecSpecificationAsString()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.destinationSettings(), other.destinationSettings()) && Objects.equals(this.encryption(), other.encryption()) && Objects.equals(this.fragmentLength(), other.fragmentLength()) && Objects.equals(this.manifestCompressionAsString(), other.manifestCompressionAsString()) && Objects.equals(this.manifestDurationFormatAsString(), other.manifestDurationFormatAsString()) && Objects.equals(this.minBufferTime(), other.minBufferTime()) && Objects.equals(this.minFinalSegmentLength(), other.minFinalSegmentLength()) && Objects.equals(this.mpdProfileAsString(), other.mpdProfileAsString()) && Objects.equals(this.ptsOffsetHandlingForBFramesAsString(), other.ptsOffsetHandlingForBFramesAsString()) && Objects.equals(this.segmentControlAsString(), other.segmentControlAsString()) && Objects.equals(this.segmentLength(), other.segmentLength()) && Objects.equals(this.streamInfResolutionAsString(), other.streamInfResolutionAsString()) && Objects.equals(this.writeDashManifestAsString(), other.writeDashManifestAsString()) && Objects.equals(this.writeHlsManifestAsString(), other.writeHlsManifestAsString()) && Objects.equals(this.writeSegmentTimelineInRepresentationAsString(), other.writeSegmentTimelineInRepresentationAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CmafGroupSettings").add("AdditionalManifests", this.hasAdditionalManifests() ? this.additionalManifests() : null).add("BaseUrl", (Object)this.baseUrl()).add("ClientCache", (Object)this.clientCacheAsString()).add("CodecSpecification", (Object)this.codecSpecificationAsString()).add("Destination", (Object)this.destination()).add("DestinationSettings", (Object)this.destinationSettings()).add("Encryption", (Object)this.encryption()).add("FragmentLength", (Object)this.fragmentLength()).add("ManifestCompression", (Object)this.manifestCompressionAsString()).add("ManifestDurationFormat", (Object)this.manifestDurationFormatAsString()).add("MinBufferTime", (Object)this.minBufferTime()).add("MinFinalSegmentLength", (Object)this.minFinalSegmentLength()).add("MpdProfile", (Object)this.mpdProfileAsString()).add("PtsOffsetHandlingForBFrames", (Object)this.ptsOffsetHandlingForBFramesAsString()).add("SegmentControl", (Object)this.segmentControlAsString()).add("SegmentLength", (Object)this.segmentLength()).add("StreamInfResolution", (Object)this.streamInfResolutionAsString()).add("WriteDashManifest", (Object)this.writeDashManifestAsString()).add("WriteHlsManifest", (Object)this.writeHlsManifestAsString()).add("WriteSegmentTimelineInRepresentation", (Object)this.writeSegmentTimelineInRepresentationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdditionalManifests": {
                return Optional.ofNullable(clazz.cast(this.additionalManifests()));
            }
            case "BaseUrl": {
                return Optional.ofNullable(clazz.cast(this.baseUrl()));
            }
            case "ClientCache": {
                return Optional.ofNullable(clazz.cast(this.clientCacheAsString()));
            }
            case "CodecSpecification": {
                return Optional.ofNullable(clazz.cast(this.codecSpecificationAsString()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "DestinationSettings": {
                return Optional.ofNullable(clazz.cast(this.destinationSettings()));
            }
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
            case "FragmentLength": {
                return Optional.ofNullable(clazz.cast(this.fragmentLength()));
            }
            case "ManifestCompression": {
                return Optional.ofNullable(clazz.cast(this.manifestCompressionAsString()));
            }
            case "ManifestDurationFormat": {
                return Optional.ofNullable(clazz.cast(this.manifestDurationFormatAsString()));
            }
            case "MinBufferTime": {
                return Optional.ofNullable(clazz.cast(this.minBufferTime()));
            }
            case "MinFinalSegmentLength": {
                return Optional.ofNullable(clazz.cast(this.minFinalSegmentLength()));
            }
            case "MpdProfile": {
                return Optional.ofNullable(clazz.cast(this.mpdProfileAsString()));
            }
            case "PtsOffsetHandlingForBFrames": {
                return Optional.ofNullable(clazz.cast(this.ptsOffsetHandlingForBFramesAsString()));
            }
            case "SegmentControl": {
                return Optional.ofNullable(clazz.cast(this.segmentControlAsString()));
            }
            case "SegmentLength": {
                return Optional.ofNullable(clazz.cast(this.segmentLength()));
            }
            case "StreamInfResolution": {
                return Optional.ofNullable(clazz.cast(this.streamInfResolutionAsString()));
            }
            case "WriteDashManifest": {
                return Optional.ofNullable(clazz.cast(this.writeDashManifestAsString()));
            }
            case "WriteHlsManifest": {
                return Optional.ofNullable(clazz.cast(this.writeHlsManifestAsString()));
            }
            case "WriteSegmentTimelineInRepresentation": {
                return Optional.ofNullable(clazz.cast(this.writeSegmentTimelineInRepresentationAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CmafGroupSettings, T> g) {
        return obj -> g.apply((CmafGroupSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<CmafAdditionalManifest> additionalManifests = DefaultSdkAutoConstructList.getInstance();
        private String baseUrl;
        private String clientCache;
        private String codecSpecification;
        private String destination;
        private DestinationSettings destinationSettings;
        private CmafEncryptionSettings encryption;
        private Integer fragmentLength;
        private String manifestCompression;
        private String manifestDurationFormat;
        private Integer minBufferTime;
        private Double minFinalSegmentLength;
        private String mpdProfile;
        private String ptsOffsetHandlingForBFrames;
        private String segmentControl;
        private Integer segmentLength;
        private String streamInfResolution;
        private String writeDashManifest;
        private String writeHlsManifest;
        private String writeSegmentTimelineInRepresentation;

        private BuilderImpl() {
        }

        private BuilderImpl(CmafGroupSettings model) {
            this.additionalManifests(model.additionalManifests);
            this.baseUrl(model.baseUrl);
            this.clientCache(model.clientCache);
            this.codecSpecification(model.codecSpecification);
            this.destination(model.destination);
            this.destinationSettings(model.destinationSettings);
            this.encryption(model.encryption);
            this.fragmentLength(model.fragmentLength);
            this.manifestCompression(model.manifestCompression);
            this.manifestDurationFormat(model.manifestDurationFormat);
            this.minBufferTime(model.minBufferTime);
            this.minFinalSegmentLength(model.minFinalSegmentLength);
            this.mpdProfile(model.mpdProfile);
            this.ptsOffsetHandlingForBFrames(model.ptsOffsetHandlingForBFrames);
            this.segmentControl(model.segmentControl);
            this.segmentLength(model.segmentLength);
            this.streamInfResolution(model.streamInfResolution);
            this.writeDashManifest(model.writeDashManifest);
            this.writeHlsManifest(model.writeHlsManifest);
            this.writeSegmentTimelineInRepresentation(model.writeSegmentTimelineInRepresentation);
        }

        public final List<CmafAdditionalManifest.Builder> getAdditionalManifests() {
            List<CmafAdditionalManifest.Builder> result = ___listOfCmafAdditionalManifestCopier.copyToBuilder(this.additionalManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder additionalManifests(Collection<CmafAdditionalManifest> additionalManifests) {
            this.additionalManifests = ___listOfCmafAdditionalManifestCopier.copy(additionalManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalManifests(CmafAdditionalManifest ... additionalManifests) {
            this.additionalManifests(Arrays.asList(additionalManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalManifests(Consumer<CmafAdditionalManifest.Builder> ... additionalManifests) {
            this.additionalManifests(Stream.of(additionalManifests).map(c -> (CmafAdditionalManifest)((CmafAdditionalManifest.Builder)CmafAdditionalManifest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAdditionalManifests(Collection<CmafAdditionalManifest.BuilderImpl> additionalManifests) {
            this.additionalManifests = ___listOfCmafAdditionalManifestCopier.copyFromBuilder(additionalManifests);
        }

        public final String getBaseUrl() {
            return this.baseUrl;
        }

        @Override
        public final Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public final void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public final String getClientCache() {
            return this.clientCache;
        }

        @Override
        public final Builder clientCache(String clientCache) {
            this.clientCache = clientCache;
            return this;
        }

        @Override
        public final Builder clientCache(CmafClientCache clientCache) {
            this.clientCache(clientCache == null ? null : clientCache.toString());
            return this;
        }

        public final void setClientCache(String clientCache) {
            this.clientCache = clientCache;
        }

        public final String getCodecSpecification() {
            return this.codecSpecification;
        }

        @Override
        public final Builder codecSpecification(String codecSpecification) {
            this.codecSpecification = codecSpecification;
            return this;
        }

        @Override
        public final Builder codecSpecification(CmafCodecSpecification codecSpecification) {
            this.codecSpecification(codecSpecification == null ? null : codecSpecification.toString());
            return this;
        }

        public final void setCodecSpecification(String codecSpecification) {
            this.codecSpecification = codecSpecification;
        }

        public final String getDestination() {
            return this.destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        public final DestinationSettings.Builder getDestinationSettings() {
            return this.destinationSettings != null ? this.destinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder destinationSettings(DestinationSettings destinationSettings) {
            this.destinationSettings = destinationSettings;
            return this;
        }

        public final void setDestinationSettings(DestinationSettings.BuilderImpl destinationSettings) {
            this.destinationSettings = destinationSettings != null ? destinationSettings.build() : null;
        }

        public final CmafEncryptionSettings.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(CmafEncryptionSettings encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(CmafEncryptionSettings.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final Integer getFragmentLength() {
            return this.fragmentLength;
        }

        @Override
        public final Builder fragmentLength(Integer fragmentLength) {
            this.fragmentLength = fragmentLength;
            return this;
        }

        public final void setFragmentLength(Integer fragmentLength) {
            this.fragmentLength = fragmentLength;
        }

        public final String getManifestCompression() {
            return this.manifestCompression;
        }

        @Override
        public final Builder manifestCompression(String manifestCompression) {
            this.manifestCompression = manifestCompression;
            return this;
        }

        @Override
        public final Builder manifestCompression(CmafManifestCompression manifestCompression) {
            this.manifestCompression(manifestCompression == null ? null : manifestCompression.toString());
            return this;
        }

        public final void setManifestCompression(String manifestCompression) {
            this.manifestCompression = manifestCompression;
        }

        public final String getManifestDurationFormat() {
            return this.manifestDurationFormat;
        }

        @Override
        public final Builder manifestDurationFormat(String manifestDurationFormat) {
            this.manifestDurationFormat = manifestDurationFormat;
            return this;
        }

        @Override
        public final Builder manifestDurationFormat(CmafManifestDurationFormat manifestDurationFormat) {
            this.manifestDurationFormat(manifestDurationFormat == null ? null : manifestDurationFormat.toString());
            return this;
        }

        public final void setManifestDurationFormat(String manifestDurationFormat) {
            this.manifestDurationFormat = manifestDurationFormat;
        }

        public final Integer getMinBufferTime() {
            return this.minBufferTime;
        }

        @Override
        public final Builder minBufferTime(Integer minBufferTime) {
            this.minBufferTime = minBufferTime;
            return this;
        }

        public final void setMinBufferTime(Integer minBufferTime) {
            this.minBufferTime = minBufferTime;
        }

        public final Double getMinFinalSegmentLength() {
            return this.minFinalSegmentLength;
        }

        @Override
        public final Builder minFinalSegmentLength(Double minFinalSegmentLength) {
            this.minFinalSegmentLength = minFinalSegmentLength;
            return this;
        }

        public final void setMinFinalSegmentLength(Double minFinalSegmentLength) {
            this.minFinalSegmentLength = minFinalSegmentLength;
        }

        public final String getMpdProfile() {
            return this.mpdProfile;
        }

        @Override
        public final Builder mpdProfile(String mpdProfile) {
            this.mpdProfile = mpdProfile;
            return this;
        }

        @Override
        public final Builder mpdProfile(CmafMpdProfile mpdProfile) {
            this.mpdProfile(mpdProfile == null ? null : mpdProfile.toString());
            return this;
        }

        public final void setMpdProfile(String mpdProfile) {
            this.mpdProfile = mpdProfile;
        }

        public final String getPtsOffsetHandlingForBFrames() {
            return this.ptsOffsetHandlingForBFrames;
        }

        @Override
        public final Builder ptsOffsetHandlingForBFrames(String ptsOffsetHandlingForBFrames) {
            this.ptsOffsetHandlingForBFrames = ptsOffsetHandlingForBFrames;
            return this;
        }

        @Override
        public final Builder ptsOffsetHandlingForBFrames(CmafPtsOffsetHandlingForBFrames ptsOffsetHandlingForBFrames) {
            this.ptsOffsetHandlingForBFrames(ptsOffsetHandlingForBFrames == null ? null : ptsOffsetHandlingForBFrames.toString());
            return this;
        }

        public final void setPtsOffsetHandlingForBFrames(String ptsOffsetHandlingForBFrames) {
            this.ptsOffsetHandlingForBFrames = ptsOffsetHandlingForBFrames;
        }

        public final String getSegmentControl() {
            return this.segmentControl;
        }

        @Override
        public final Builder segmentControl(String segmentControl) {
            this.segmentControl = segmentControl;
            return this;
        }

        @Override
        public final Builder segmentControl(CmafSegmentControl segmentControl) {
            this.segmentControl(segmentControl == null ? null : segmentControl.toString());
            return this;
        }

        public final void setSegmentControl(String segmentControl) {
            this.segmentControl = segmentControl;
        }

        public final Integer getSegmentLength() {
            return this.segmentLength;
        }

        @Override
        public final Builder segmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
            return this;
        }

        public final void setSegmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
        }

        public final String getStreamInfResolution() {
            return this.streamInfResolution;
        }

        @Override
        public final Builder streamInfResolution(String streamInfResolution) {
            this.streamInfResolution = streamInfResolution;
            return this;
        }

        @Override
        public final Builder streamInfResolution(CmafStreamInfResolution streamInfResolution) {
            this.streamInfResolution(streamInfResolution == null ? null : streamInfResolution.toString());
            return this;
        }

        public final void setStreamInfResolution(String streamInfResolution) {
            this.streamInfResolution = streamInfResolution;
        }

        public final String getWriteDashManifest() {
            return this.writeDashManifest;
        }

        @Override
        public final Builder writeDashManifest(String writeDashManifest) {
            this.writeDashManifest = writeDashManifest;
            return this;
        }

        @Override
        public final Builder writeDashManifest(CmafWriteDASHManifest writeDashManifest) {
            this.writeDashManifest(writeDashManifest == null ? null : writeDashManifest.toString());
            return this;
        }

        public final void setWriteDashManifest(String writeDashManifest) {
            this.writeDashManifest = writeDashManifest;
        }

        public final String getWriteHlsManifest() {
            return this.writeHlsManifest;
        }

        @Override
        public final Builder writeHlsManifest(String writeHlsManifest) {
            this.writeHlsManifest = writeHlsManifest;
            return this;
        }

        @Override
        public final Builder writeHlsManifest(CmafWriteHLSManifest writeHlsManifest) {
            this.writeHlsManifest(writeHlsManifest == null ? null : writeHlsManifest.toString());
            return this;
        }

        public final void setWriteHlsManifest(String writeHlsManifest) {
            this.writeHlsManifest = writeHlsManifest;
        }

        public final String getWriteSegmentTimelineInRepresentation() {
            return this.writeSegmentTimelineInRepresentation;
        }

        @Override
        public final Builder writeSegmentTimelineInRepresentation(String writeSegmentTimelineInRepresentation) {
            this.writeSegmentTimelineInRepresentation = writeSegmentTimelineInRepresentation;
            return this;
        }

        @Override
        public final Builder writeSegmentTimelineInRepresentation(CmafWriteSegmentTimelineInRepresentation writeSegmentTimelineInRepresentation) {
            this.writeSegmentTimelineInRepresentation(writeSegmentTimelineInRepresentation == null ? null : writeSegmentTimelineInRepresentation.toString());
            return this;
        }

        public final void setWriteSegmentTimelineInRepresentation(String writeSegmentTimelineInRepresentation) {
            this.writeSegmentTimelineInRepresentation = writeSegmentTimelineInRepresentation;
        }

        public CmafGroupSettings build() {
            return new CmafGroupSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CmafGroupSettings> {
        public Builder additionalManifests(Collection<CmafAdditionalManifest> var1);

        public Builder additionalManifests(CmafAdditionalManifest ... var1);

        public Builder additionalManifests(Consumer<CmafAdditionalManifest.Builder> ... var1);

        public Builder baseUrl(String var1);

        public Builder clientCache(String var1);

        public Builder clientCache(CmafClientCache var1);

        public Builder codecSpecification(String var1);

        public Builder codecSpecification(CmafCodecSpecification var1);

        public Builder destination(String var1);

        public Builder destinationSettings(DestinationSettings var1);

        default public Builder destinationSettings(Consumer<DestinationSettings.Builder> destinationSettings) {
            return this.destinationSettings((DestinationSettings)((DestinationSettings.Builder)DestinationSettings.builder().applyMutation(destinationSettings)).build());
        }

        public Builder encryption(CmafEncryptionSettings var1);

        default public Builder encryption(Consumer<CmafEncryptionSettings.Builder> encryption) {
            return this.encryption((CmafEncryptionSettings)((CmafEncryptionSettings.Builder)CmafEncryptionSettings.builder().applyMutation(encryption)).build());
        }

        public Builder fragmentLength(Integer var1);

        public Builder manifestCompression(String var1);

        public Builder manifestCompression(CmafManifestCompression var1);

        public Builder manifestDurationFormat(String var1);

        public Builder manifestDurationFormat(CmafManifestDurationFormat var1);

        public Builder minBufferTime(Integer var1);

        public Builder minFinalSegmentLength(Double var1);

        public Builder mpdProfile(String var1);

        public Builder mpdProfile(CmafMpdProfile var1);

        public Builder ptsOffsetHandlingForBFrames(String var1);

        public Builder ptsOffsetHandlingForBFrames(CmafPtsOffsetHandlingForBFrames var1);

        public Builder segmentControl(String var1);

        public Builder segmentControl(CmafSegmentControl var1);

        public Builder segmentLength(Integer var1);

        public Builder streamInfResolution(String var1);

        public Builder streamInfResolution(CmafStreamInfResolution var1);

        public Builder writeDashManifest(String var1);

        public Builder writeDashManifest(CmafWriteDASHManifest var1);

        public Builder writeHlsManifest(String var1);

        public Builder writeHlsManifest(CmafWriteHLSManifest var1);

        public Builder writeSegmentTimelineInRepresentation(String var1);

        public Builder writeSegmentTimelineInRepresentation(CmafWriteSegmentTimelineInRepresentation var1);
    }
}

