/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.Av1AdaptiveQuantization;
import software.amazon.awssdk.services.mediaconvert.model.Av1FramerateControl;
import software.amazon.awssdk.services.mediaconvert.model.Av1FramerateConversionAlgorithm;
import software.amazon.awssdk.services.mediaconvert.model.Av1QvbrSettings;
import software.amazon.awssdk.services.mediaconvert.model.Av1RateControlMode;
import software.amazon.awssdk.services.mediaconvert.model.Av1SpatialAdaptiveQuantization;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Av1Settings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Av1Settings> {
    private static final SdkField<String> ADAPTIVE_QUANTIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdaptiveQuantization").getter(Av1Settings.getter(Av1Settings::adaptiveQuantizationAsString)).setter(Av1Settings.setter(Builder::adaptiveQuantization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adaptiveQuantization").build()}).build();
    private static final SdkField<String> FRAMERATE_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FramerateControl").getter(Av1Settings.getter(Av1Settings::framerateControlAsString)).setter(Av1Settings.setter(Builder::framerateControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateControl").build()}).build();
    private static final SdkField<String> FRAMERATE_CONVERSION_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FramerateConversionAlgorithm").getter(Av1Settings.getter(Av1Settings::framerateConversionAlgorithmAsString)).setter(Av1Settings.setter(Builder::framerateConversionAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateConversionAlgorithm").build()}).build();
    private static final SdkField<Integer> FRAMERATE_DENOMINATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FramerateDenominator").getter(Av1Settings.getter(Av1Settings::framerateDenominator)).setter(Av1Settings.setter(Builder::framerateDenominator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateDenominator").build()}).build();
    private static final SdkField<Integer> FRAMERATE_NUMERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FramerateNumerator").getter(Av1Settings.getter(Av1Settings::framerateNumerator)).setter(Av1Settings.setter(Builder::framerateNumerator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateNumerator").build()}).build();
    private static final SdkField<Double> GOP_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("GopSize").getter(Av1Settings.getter(Av1Settings::gopSize)).setter(Av1Settings.setter(Builder::gopSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopSize").build()}).build();
    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxBitrate").getter(Av1Settings.getter(Av1Settings::maxBitrate)).setter(Av1Settings.setter(Builder::maxBitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()}).build();
    private static final SdkField<Integer> NUMBER_B_FRAMES_BETWEEN_REFERENCE_FRAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberBFramesBetweenReferenceFrames").getter(Av1Settings.getter(Av1Settings::numberBFramesBetweenReferenceFrames)).setter(Av1Settings.setter(Builder::numberBFramesBetweenReferenceFrames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberBFramesBetweenReferenceFrames").build()}).build();
    private static final SdkField<Av1QvbrSettings> QVBR_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QvbrSettings").getter(Av1Settings.getter(Av1Settings::qvbrSettings)).setter(Av1Settings.setter(Builder::qvbrSettings)).constructor(Av1QvbrSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qvbrSettings").build()}).build();
    private static final SdkField<String> RATE_CONTROL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RateControlMode").getter(Av1Settings.getter(Av1Settings::rateControlModeAsString)).setter(Av1Settings.setter(Builder::rateControlMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateControlMode").build()}).build();
    private static final SdkField<Integer> SLICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Slices").getter(Av1Settings.getter(Av1Settings::slices)).setter(Av1Settings.setter(Builder::slices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slices").build()}).build();
    private static final SdkField<String> SPATIAL_ADAPTIVE_QUANTIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpatialAdaptiveQuantization").getter(Av1Settings.getter(Av1Settings::spatialAdaptiveQuantizationAsString)).setter(Av1Settings.setter(Builder::spatialAdaptiveQuantization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spatialAdaptiveQuantization").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTIVE_QUANTIZATION_FIELD, FRAMERATE_CONTROL_FIELD, FRAMERATE_CONVERSION_ALGORITHM_FIELD, FRAMERATE_DENOMINATOR_FIELD, FRAMERATE_NUMERATOR_FIELD, GOP_SIZE_FIELD, MAX_BITRATE_FIELD, NUMBER_B_FRAMES_BETWEEN_REFERENCE_FRAMES_FIELD, QVBR_SETTINGS_FIELD, RATE_CONTROL_MODE_FIELD, SLICES_FIELD, SPATIAL_ADAPTIVE_QUANTIZATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String adaptiveQuantization;
    private final String framerateControl;
    private final String framerateConversionAlgorithm;
    private final Integer framerateDenominator;
    private final Integer framerateNumerator;
    private final Double gopSize;
    private final Integer maxBitrate;
    private final Integer numberBFramesBetweenReferenceFrames;
    private final Av1QvbrSettings qvbrSettings;
    private final String rateControlMode;
    private final Integer slices;
    private final String spatialAdaptiveQuantization;

    private Av1Settings(BuilderImpl builder) {
        this.adaptiveQuantization = builder.adaptiveQuantization;
        this.framerateControl = builder.framerateControl;
        this.framerateConversionAlgorithm = builder.framerateConversionAlgorithm;
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
        this.gopSize = builder.gopSize;
        this.maxBitrate = builder.maxBitrate;
        this.numberBFramesBetweenReferenceFrames = builder.numberBFramesBetweenReferenceFrames;
        this.qvbrSettings = builder.qvbrSettings;
        this.rateControlMode = builder.rateControlMode;
        this.slices = builder.slices;
        this.spatialAdaptiveQuantization = builder.spatialAdaptiveQuantization;
    }

    public final Av1AdaptiveQuantization adaptiveQuantization() {
        return Av1AdaptiveQuantization.fromValue(this.adaptiveQuantization);
    }

    public final String adaptiveQuantizationAsString() {
        return this.adaptiveQuantization;
    }

    public final Av1FramerateControl framerateControl() {
        return Av1FramerateControl.fromValue(this.framerateControl);
    }

    public final String framerateControlAsString() {
        return this.framerateControl;
    }

    public final Av1FramerateConversionAlgorithm framerateConversionAlgorithm() {
        return Av1FramerateConversionAlgorithm.fromValue(this.framerateConversionAlgorithm);
    }

    public final String framerateConversionAlgorithmAsString() {
        return this.framerateConversionAlgorithm;
    }

    public final Integer framerateDenominator() {
        return this.framerateDenominator;
    }

    public final Integer framerateNumerator() {
        return this.framerateNumerator;
    }

    public final Double gopSize() {
        return this.gopSize;
    }

    public final Integer maxBitrate() {
        return this.maxBitrate;
    }

    public final Integer numberBFramesBetweenReferenceFrames() {
        return this.numberBFramesBetweenReferenceFrames;
    }

    public final Av1QvbrSettings qvbrSettings() {
        return this.qvbrSettings;
    }

    public final Av1RateControlMode rateControlMode() {
        return Av1RateControlMode.fromValue(this.rateControlMode);
    }

    public final String rateControlModeAsString() {
        return this.rateControlMode;
    }

    public final Integer slices() {
        return this.slices;
    }

    public final Av1SpatialAdaptiveQuantization spatialAdaptiveQuantization() {
        return Av1SpatialAdaptiveQuantization.fromValue(this.spatialAdaptiveQuantization);
    }

    public final String spatialAdaptiveQuantizationAsString() {
        return this.spatialAdaptiveQuantization;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateConversionAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberBFramesBetweenReferenceFrames());
        hashCode = 31 * hashCode + Objects.hashCode(this.qvbrSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.rateControlModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.slices());
        hashCode = 31 * hashCode + Objects.hashCode(this.spatialAdaptiveQuantizationAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Av1Settings)) {
            return false;
        }
        Av1Settings other = (Av1Settings)obj;
        return Objects.equals(this.adaptiveQuantizationAsString(), other.adaptiveQuantizationAsString()) && Objects.equals(this.framerateControlAsString(), other.framerateControlAsString()) && Objects.equals(this.framerateConversionAlgorithmAsString(), other.framerateConversionAlgorithmAsString()) && Objects.equals(this.framerateDenominator(), other.framerateDenominator()) && Objects.equals(this.framerateNumerator(), other.framerateNumerator()) && Objects.equals(this.gopSize(), other.gopSize()) && Objects.equals(this.maxBitrate(), other.maxBitrate()) && Objects.equals(this.numberBFramesBetweenReferenceFrames(), other.numberBFramesBetweenReferenceFrames()) && Objects.equals(this.qvbrSettings(), other.qvbrSettings()) && Objects.equals(this.rateControlModeAsString(), other.rateControlModeAsString()) && Objects.equals(this.slices(), other.slices()) && Objects.equals(this.spatialAdaptiveQuantizationAsString(), other.spatialAdaptiveQuantizationAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Av1Settings").add("AdaptiveQuantization", (Object)this.adaptiveQuantizationAsString()).add("FramerateControl", (Object)this.framerateControlAsString()).add("FramerateConversionAlgorithm", (Object)this.framerateConversionAlgorithmAsString()).add("FramerateDenominator", (Object)this.framerateDenominator()).add("FramerateNumerator", (Object)this.framerateNumerator()).add("GopSize", (Object)this.gopSize()).add("MaxBitrate", (Object)this.maxBitrate()).add("NumberBFramesBetweenReferenceFrames", (Object)this.numberBFramesBetweenReferenceFrames()).add("QvbrSettings", (Object)this.qvbrSettings()).add("RateControlMode", (Object)this.rateControlModeAsString()).add("Slices", (Object)this.slices()).add("SpatialAdaptiveQuantization", (Object)this.spatialAdaptiveQuantizationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdaptiveQuantization": {
                return Optional.ofNullable(clazz.cast(this.adaptiveQuantizationAsString()));
            }
            case "FramerateControl": {
                return Optional.ofNullable(clazz.cast(this.framerateControlAsString()));
            }
            case "FramerateConversionAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.framerateConversionAlgorithmAsString()));
            }
            case "FramerateDenominator": {
                return Optional.ofNullable(clazz.cast(this.framerateDenominator()));
            }
            case "FramerateNumerator": {
                return Optional.ofNullable(clazz.cast(this.framerateNumerator()));
            }
            case "GopSize": {
                return Optional.ofNullable(clazz.cast(this.gopSize()));
            }
            case "MaxBitrate": {
                return Optional.ofNullable(clazz.cast(this.maxBitrate()));
            }
            case "NumberBFramesBetweenReferenceFrames": {
                return Optional.ofNullable(clazz.cast(this.numberBFramesBetweenReferenceFrames()));
            }
            case "QvbrSettings": {
                return Optional.ofNullable(clazz.cast(this.qvbrSettings()));
            }
            case "RateControlMode": {
                return Optional.ofNullable(clazz.cast(this.rateControlModeAsString()));
            }
            case "Slices": {
                return Optional.ofNullable(clazz.cast(this.slices()));
            }
            case "SpatialAdaptiveQuantization": {
                return Optional.ofNullable(clazz.cast(this.spatialAdaptiveQuantizationAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Av1Settings, T> g) {
        return obj -> g.apply((Av1Settings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String adaptiveQuantization;
        private String framerateControl;
        private String framerateConversionAlgorithm;
        private Integer framerateDenominator;
        private Integer framerateNumerator;
        private Double gopSize;
        private Integer maxBitrate;
        private Integer numberBFramesBetweenReferenceFrames;
        private Av1QvbrSettings qvbrSettings;
        private String rateControlMode;
        private Integer slices;
        private String spatialAdaptiveQuantization;

        private BuilderImpl() {
        }

        private BuilderImpl(Av1Settings model) {
            this.adaptiveQuantization(model.adaptiveQuantization);
            this.framerateControl(model.framerateControl);
            this.framerateConversionAlgorithm(model.framerateConversionAlgorithm);
            this.framerateDenominator(model.framerateDenominator);
            this.framerateNumerator(model.framerateNumerator);
            this.gopSize(model.gopSize);
            this.maxBitrate(model.maxBitrate);
            this.numberBFramesBetweenReferenceFrames(model.numberBFramesBetweenReferenceFrames);
            this.qvbrSettings(model.qvbrSettings);
            this.rateControlMode(model.rateControlMode);
            this.slices(model.slices);
            this.spatialAdaptiveQuantization(model.spatialAdaptiveQuantization);
        }

        public final String getAdaptiveQuantization() {
            return this.adaptiveQuantization;
        }

        @Override
        public final Builder adaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
            return this;
        }

        @Override
        public final Builder adaptiveQuantization(Av1AdaptiveQuantization adaptiveQuantization) {
            this.adaptiveQuantization(adaptiveQuantization == null ? null : adaptiveQuantization.toString());
            return this;
        }

        public final void setAdaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
        }

        public final String getFramerateControl() {
            return this.framerateControl;
        }

        @Override
        public final Builder framerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
            return this;
        }

        @Override
        public final Builder framerateControl(Av1FramerateControl framerateControl) {
            this.framerateControl(framerateControl == null ? null : framerateControl.toString());
            return this;
        }

        public final void setFramerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
        }

        public final String getFramerateConversionAlgorithm() {
            return this.framerateConversionAlgorithm;
        }

        @Override
        public final Builder framerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
            return this;
        }

        @Override
        public final Builder framerateConversionAlgorithm(Av1FramerateConversionAlgorithm framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm(framerateConversionAlgorithm == null ? null : framerateConversionAlgorithm.toString());
            return this;
        }

        public final void setFramerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
        }

        public final Integer getFramerateDenominator() {
            return this.framerateDenominator;
        }

        @Override
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        public final Integer getFramerateNumerator() {
            return this.framerateNumerator;
        }

        @Override
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        public final Double getGopSize() {
            return this.gopSize;
        }

        @Override
        public final Builder gopSize(Double gopSize) {
            this.gopSize = gopSize;
            return this;
        }

        public final void setGopSize(Double gopSize) {
            this.gopSize = gopSize;
        }

        public final Integer getMaxBitrate() {
            return this.maxBitrate;
        }

        @Override
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        public final Integer getNumberBFramesBetweenReferenceFrames() {
            return this.numberBFramesBetweenReferenceFrames;
        }

        @Override
        public final Builder numberBFramesBetweenReferenceFrames(Integer numberBFramesBetweenReferenceFrames) {
            this.numberBFramesBetweenReferenceFrames = numberBFramesBetweenReferenceFrames;
            return this;
        }

        public final void setNumberBFramesBetweenReferenceFrames(Integer numberBFramesBetweenReferenceFrames) {
            this.numberBFramesBetweenReferenceFrames = numberBFramesBetweenReferenceFrames;
        }

        public final Av1QvbrSettings.Builder getQvbrSettings() {
            return this.qvbrSettings != null ? this.qvbrSettings.toBuilder() : null;
        }

        @Override
        public final Builder qvbrSettings(Av1QvbrSettings qvbrSettings) {
            this.qvbrSettings = qvbrSettings;
            return this;
        }

        public final void setQvbrSettings(Av1QvbrSettings.BuilderImpl qvbrSettings) {
            this.qvbrSettings = qvbrSettings != null ? qvbrSettings.build() : null;
        }

        public final String getRateControlMode() {
            return this.rateControlMode;
        }

        @Override
        public final Builder rateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
            return this;
        }

        @Override
        public final Builder rateControlMode(Av1RateControlMode rateControlMode) {
            this.rateControlMode(rateControlMode == null ? null : rateControlMode.toString());
            return this;
        }

        public final void setRateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
        }

        public final Integer getSlices() {
            return this.slices;
        }

        @Override
        public final Builder slices(Integer slices) {
            this.slices = slices;
            return this;
        }

        public final void setSlices(Integer slices) {
            this.slices = slices;
        }

        public final String getSpatialAdaptiveQuantization() {
            return this.spatialAdaptiveQuantization;
        }

        @Override
        public final Builder spatialAdaptiveQuantization(String spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization = spatialAdaptiveQuantization;
            return this;
        }

        @Override
        public final Builder spatialAdaptiveQuantization(Av1SpatialAdaptiveQuantization spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization(spatialAdaptiveQuantization == null ? null : spatialAdaptiveQuantization.toString());
            return this;
        }

        public final void setSpatialAdaptiveQuantization(String spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization = spatialAdaptiveQuantization;
        }

        public Av1Settings build() {
            return new Av1Settings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Av1Settings> {
        public Builder adaptiveQuantization(String var1);

        public Builder adaptiveQuantization(Av1AdaptiveQuantization var1);

        public Builder framerateControl(String var1);

        public Builder framerateControl(Av1FramerateControl var1);

        public Builder framerateConversionAlgorithm(String var1);

        public Builder framerateConversionAlgorithm(Av1FramerateConversionAlgorithm var1);

        public Builder framerateDenominator(Integer var1);

        public Builder framerateNumerator(Integer var1);

        public Builder gopSize(Double var1);

        public Builder maxBitrate(Integer var1);

        public Builder numberBFramesBetweenReferenceFrames(Integer var1);

        public Builder qvbrSettings(Av1QvbrSettings var1);

        default public Builder qvbrSettings(Consumer<Av1QvbrSettings.Builder> qvbrSettings) {
            return this.qvbrSettings((Av1QvbrSettings)((Av1QvbrSettings.Builder)Av1QvbrSettings.builder().applyMutation(qvbrSettings)).build());
        }

        public Builder rateControlMode(String var1);

        public Builder rateControlMode(Av1RateControlMode var1);

        public Builder slices(Integer var1);

        public Builder spatialAdaptiveQuantization(String var1);

        public Builder spatialAdaptiveQuantization(Av1SpatialAdaptiveQuantization var1);
    }
}

