/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum BillingTagsSource {
    QUEUE("QUEUE"),
    PRESET("PRESET"),
    JOB_TEMPLATE("JOB_TEMPLATE"),
    JOB("JOB"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private BillingTagsSource(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BillingTagsSource fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(BillingTagsSource.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BillingTagsSource> knownValues() {
        return Stream.of(BillingTagsSource.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

