/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.AvcIntraClass;
import software.amazon.awssdk.services.mediaconvert.model.AvcIntraFramerateControl;
import software.amazon.awssdk.services.mediaconvert.model.AvcIntraFramerateConversionAlgorithm;
import software.amazon.awssdk.services.mediaconvert.model.AvcIntraInterlaceMode;
import software.amazon.awssdk.services.mediaconvert.model.AvcIntraSlowPal;
import software.amazon.awssdk.services.mediaconvert.model.AvcIntraTelecine;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AvcIntraSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AvcIntraSettings> {
    private static final SdkField<String> AVC_INTRA_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvcIntraClass").getter(AvcIntraSettings.getter(AvcIntraSettings::avcIntraClassAsString)).setter(AvcIntraSettings.setter(Builder::avcIntraClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("avcIntraClass").build()}).build();
    private static final SdkField<String> FRAMERATE_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FramerateControl").getter(AvcIntraSettings.getter(AvcIntraSettings::framerateControlAsString)).setter(AvcIntraSettings.setter(Builder::framerateControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateControl").build()}).build();
    private static final SdkField<String> FRAMERATE_CONVERSION_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FramerateConversionAlgorithm").getter(AvcIntraSettings.getter(AvcIntraSettings::framerateConversionAlgorithmAsString)).setter(AvcIntraSettings.setter(Builder::framerateConversionAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateConversionAlgorithm").build()}).build();
    private static final SdkField<Integer> FRAMERATE_DENOMINATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FramerateDenominator").getter(AvcIntraSettings.getter(AvcIntraSettings::framerateDenominator)).setter(AvcIntraSettings.setter(Builder::framerateDenominator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateDenominator").build()}).build();
    private static final SdkField<Integer> FRAMERATE_NUMERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FramerateNumerator").getter(AvcIntraSettings.getter(AvcIntraSettings::framerateNumerator)).setter(AvcIntraSettings.setter(Builder::framerateNumerator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateNumerator").build()}).build();
    private static final SdkField<String> INTERLACE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InterlaceMode").getter(AvcIntraSettings.getter(AvcIntraSettings::interlaceModeAsString)).setter(AvcIntraSettings.setter(Builder::interlaceMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interlaceMode").build()}).build();
    private static final SdkField<String> SLOW_PAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SlowPal").getter(AvcIntraSettings.getter(AvcIntraSettings::slowPalAsString)).setter(AvcIntraSettings.setter(Builder::slowPal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slowPal").build()}).build();
    private static final SdkField<String> TELECINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Telecine").getter(AvcIntraSettings.getter(AvcIntraSettings::telecineAsString)).setter(AvcIntraSettings.setter(Builder::telecine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("telecine").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVC_INTRA_CLASS_FIELD, FRAMERATE_CONTROL_FIELD, FRAMERATE_CONVERSION_ALGORITHM_FIELD, FRAMERATE_DENOMINATOR_FIELD, FRAMERATE_NUMERATOR_FIELD, INTERLACE_MODE_FIELD, SLOW_PAL_FIELD, TELECINE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String avcIntraClass;
    private final String framerateControl;
    private final String framerateConversionAlgorithm;
    private final Integer framerateDenominator;
    private final Integer framerateNumerator;
    private final String interlaceMode;
    private final String slowPal;
    private final String telecine;

    private AvcIntraSettings(BuilderImpl builder) {
        this.avcIntraClass = builder.avcIntraClass;
        this.framerateControl = builder.framerateControl;
        this.framerateConversionAlgorithm = builder.framerateConversionAlgorithm;
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
        this.interlaceMode = builder.interlaceMode;
        this.slowPal = builder.slowPal;
        this.telecine = builder.telecine;
    }

    public final AvcIntraClass avcIntraClass() {
        return AvcIntraClass.fromValue(this.avcIntraClass);
    }

    public final String avcIntraClassAsString() {
        return this.avcIntraClass;
    }

    public final AvcIntraFramerateControl framerateControl() {
        return AvcIntraFramerateControl.fromValue(this.framerateControl);
    }

    public final String framerateControlAsString() {
        return this.framerateControl;
    }

    public final AvcIntraFramerateConversionAlgorithm framerateConversionAlgorithm() {
        return AvcIntraFramerateConversionAlgorithm.fromValue(this.framerateConversionAlgorithm);
    }

    public final String framerateConversionAlgorithmAsString() {
        return this.framerateConversionAlgorithm;
    }

    public final Integer framerateDenominator() {
        return this.framerateDenominator;
    }

    public final Integer framerateNumerator() {
        return this.framerateNumerator;
    }

    public final AvcIntraInterlaceMode interlaceMode() {
        return AvcIntraInterlaceMode.fromValue(this.interlaceMode);
    }

    public final String interlaceModeAsString() {
        return this.interlaceMode;
    }

    public final AvcIntraSlowPal slowPal() {
        return AvcIntraSlowPal.fromValue(this.slowPal);
    }

    public final String slowPalAsString() {
        return this.slowPal;
    }

    public final AvcIntraTelecine telecine() {
        return AvcIntraTelecine.fromValue(this.telecine);
    }

    public final String telecineAsString() {
        return this.telecine;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.avcIntraClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateConversionAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(this.interlaceModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.slowPalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.telecineAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvcIntraSettings)) {
            return false;
        }
        AvcIntraSettings other = (AvcIntraSettings)obj;
        return Objects.equals(this.avcIntraClassAsString(), other.avcIntraClassAsString()) && Objects.equals(this.framerateControlAsString(), other.framerateControlAsString()) && Objects.equals(this.framerateConversionAlgorithmAsString(), other.framerateConversionAlgorithmAsString()) && Objects.equals(this.framerateDenominator(), other.framerateDenominator()) && Objects.equals(this.framerateNumerator(), other.framerateNumerator()) && Objects.equals(this.interlaceModeAsString(), other.interlaceModeAsString()) && Objects.equals(this.slowPalAsString(), other.slowPalAsString()) && Objects.equals(this.telecineAsString(), other.telecineAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AvcIntraSettings").add("AvcIntraClass", (Object)this.avcIntraClassAsString()).add("FramerateControl", (Object)this.framerateControlAsString()).add("FramerateConversionAlgorithm", (Object)this.framerateConversionAlgorithmAsString()).add("FramerateDenominator", (Object)this.framerateDenominator()).add("FramerateNumerator", (Object)this.framerateNumerator()).add("InterlaceMode", (Object)this.interlaceModeAsString()).add("SlowPal", (Object)this.slowPalAsString()).add("Telecine", (Object)this.telecineAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvcIntraClass": {
                return Optional.ofNullable(clazz.cast(this.avcIntraClassAsString()));
            }
            case "FramerateControl": {
                return Optional.ofNullable(clazz.cast(this.framerateControlAsString()));
            }
            case "FramerateConversionAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.framerateConversionAlgorithmAsString()));
            }
            case "FramerateDenominator": {
                return Optional.ofNullable(clazz.cast(this.framerateDenominator()));
            }
            case "FramerateNumerator": {
                return Optional.ofNullable(clazz.cast(this.framerateNumerator()));
            }
            case "InterlaceMode": {
                return Optional.ofNullable(clazz.cast(this.interlaceModeAsString()));
            }
            case "SlowPal": {
                return Optional.ofNullable(clazz.cast(this.slowPalAsString()));
            }
            case "Telecine": {
                return Optional.ofNullable(clazz.cast(this.telecineAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AvcIntraSettings, T> g) {
        return obj -> g.apply((AvcIntraSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String avcIntraClass;
        private String framerateControl;
        private String framerateConversionAlgorithm;
        private Integer framerateDenominator;
        private Integer framerateNumerator;
        private String interlaceMode;
        private String slowPal;
        private String telecine;

        private BuilderImpl() {
        }

        private BuilderImpl(AvcIntraSettings model) {
            this.avcIntraClass(model.avcIntraClass);
            this.framerateControl(model.framerateControl);
            this.framerateConversionAlgorithm(model.framerateConversionAlgorithm);
            this.framerateDenominator(model.framerateDenominator);
            this.framerateNumerator(model.framerateNumerator);
            this.interlaceMode(model.interlaceMode);
            this.slowPal(model.slowPal);
            this.telecine(model.telecine);
        }

        public final String getAvcIntraClass() {
            return this.avcIntraClass;
        }

        @Override
        public final Builder avcIntraClass(String avcIntraClass) {
            this.avcIntraClass = avcIntraClass;
            return this;
        }

        @Override
        public final Builder avcIntraClass(AvcIntraClass avcIntraClass) {
            this.avcIntraClass(avcIntraClass == null ? null : avcIntraClass.toString());
            return this;
        }

        public final void setAvcIntraClass(String avcIntraClass) {
            this.avcIntraClass = avcIntraClass;
        }

        public final String getFramerateControl() {
            return this.framerateControl;
        }

        @Override
        public final Builder framerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
            return this;
        }

        @Override
        public final Builder framerateControl(AvcIntraFramerateControl framerateControl) {
            this.framerateControl(framerateControl == null ? null : framerateControl.toString());
            return this;
        }

        public final void setFramerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
        }

        public final String getFramerateConversionAlgorithm() {
            return this.framerateConversionAlgorithm;
        }

        @Override
        public final Builder framerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
            return this;
        }

        @Override
        public final Builder framerateConversionAlgorithm(AvcIntraFramerateConversionAlgorithm framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm(framerateConversionAlgorithm == null ? null : framerateConversionAlgorithm.toString());
            return this;
        }

        public final void setFramerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
        }

        public final Integer getFramerateDenominator() {
            return this.framerateDenominator;
        }

        @Override
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        public final Integer getFramerateNumerator() {
            return this.framerateNumerator;
        }

        @Override
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        public final String getInterlaceMode() {
            return this.interlaceMode;
        }

        @Override
        public final Builder interlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
            return this;
        }

        @Override
        public final Builder interlaceMode(AvcIntraInterlaceMode interlaceMode) {
            this.interlaceMode(interlaceMode == null ? null : interlaceMode.toString());
            return this;
        }

        public final void setInterlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
        }

        public final String getSlowPal() {
            return this.slowPal;
        }

        @Override
        public final Builder slowPal(String slowPal) {
            this.slowPal = slowPal;
            return this;
        }

        @Override
        public final Builder slowPal(AvcIntraSlowPal slowPal) {
            this.slowPal(slowPal == null ? null : slowPal.toString());
            return this;
        }

        public final void setSlowPal(String slowPal) {
            this.slowPal = slowPal;
        }

        public final String getTelecine() {
            return this.telecine;
        }

        @Override
        public final Builder telecine(String telecine) {
            this.telecine = telecine;
            return this;
        }

        @Override
        public final Builder telecine(AvcIntraTelecine telecine) {
            this.telecine(telecine == null ? null : telecine.toString());
            return this;
        }

        public final void setTelecine(String telecine) {
            this.telecine = telecine;
        }

        public AvcIntraSettings build() {
            return new AvcIntraSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AvcIntraSettings> {
        public Builder avcIntraClass(String var1);

        public Builder avcIntraClass(AvcIntraClass var1);

        public Builder framerateControl(String var1);

        public Builder framerateControl(AvcIntraFramerateControl var1);

        public Builder framerateConversionAlgorithm(String var1);

        public Builder framerateConversionAlgorithm(AvcIntraFramerateConversionAlgorithm var1);

        public Builder framerateDenominator(Integer var1);

        public Builder framerateNumerator(Integer var1);

        public Builder interlaceMode(String var1);

        public Builder interlaceMode(AvcIntraInterlaceMode var1);

        public Builder slowPal(String var1);

        public Builder slowPal(AvcIntraSlowPal var1);

        public Builder telecine(String var1);

        public Builder telecine(AvcIntraTelecine var1);
    }
}

