/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.Vp8FramerateControl;
import software.amazon.awssdk.services.mediaconvert.model.Vp8FramerateConversionAlgorithm;
import software.amazon.awssdk.services.mediaconvert.model.Vp8ParControl;
import software.amazon.awssdk.services.mediaconvert.model.Vp8QualityTuningLevel;
import software.amazon.awssdk.services.mediaconvert.model.Vp8RateControlMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Vp8Settings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Vp8Settings> {
    private static final SdkField<Integer> BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Bitrate").getter(Vp8Settings.getter(Vp8Settings::bitrate)).setter(Vp8Settings.setter(Builder::bitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()}).build();
    private static final SdkField<String> FRAMERATE_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FramerateControl").getter(Vp8Settings.getter(Vp8Settings::framerateControlAsString)).setter(Vp8Settings.setter(Builder::framerateControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateControl").build()}).build();
    private static final SdkField<String> FRAMERATE_CONVERSION_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FramerateConversionAlgorithm").getter(Vp8Settings.getter(Vp8Settings::framerateConversionAlgorithmAsString)).setter(Vp8Settings.setter(Builder::framerateConversionAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateConversionAlgorithm").build()}).build();
    private static final SdkField<Integer> FRAMERATE_DENOMINATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FramerateDenominator").getter(Vp8Settings.getter(Vp8Settings::framerateDenominator)).setter(Vp8Settings.setter(Builder::framerateDenominator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateDenominator").build()}).build();
    private static final SdkField<Integer> FRAMERATE_NUMERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FramerateNumerator").getter(Vp8Settings.getter(Vp8Settings::framerateNumerator)).setter(Vp8Settings.setter(Builder::framerateNumerator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateNumerator").build()}).build();
    private static final SdkField<Double> GOP_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("GopSize").getter(Vp8Settings.getter(Vp8Settings::gopSize)).setter(Vp8Settings.setter(Builder::gopSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopSize").build()}).build();
    private static final SdkField<Integer> HRD_BUFFER_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HrdBufferSize").getter(Vp8Settings.getter(Vp8Settings::hrdBufferSize)).setter(Vp8Settings.setter(Builder::hrdBufferSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hrdBufferSize").build()}).build();
    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxBitrate").getter(Vp8Settings.getter(Vp8Settings::maxBitrate)).setter(Vp8Settings.setter(Builder::maxBitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()}).build();
    private static final SdkField<String> PAR_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParControl").getter(Vp8Settings.getter(Vp8Settings::parControlAsString)).setter(Vp8Settings.setter(Builder::parControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parControl").build()}).build();
    private static final SdkField<Integer> PAR_DENOMINATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ParDenominator").getter(Vp8Settings.getter(Vp8Settings::parDenominator)).setter(Vp8Settings.setter(Builder::parDenominator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parDenominator").build()}).build();
    private static final SdkField<Integer> PAR_NUMERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ParNumerator").getter(Vp8Settings.getter(Vp8Settings::parNumerator)).setter(Vp8Settings.setter(Builder::parNumerator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parNumerator").build()}).build();
    private static final SdkField<String> QUALITY_TUNING_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QualityTuningLevel").getter(Vp8Settings.getter(Vp8Settings::qualityTuningLevelAsString)).setter(Vp8Settings.setter(Builder::qualityTuningLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qualityTuningLevel").build()}).build();
    private static final SdkField<String> RATE_CONTROL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RateControlMode").getter(Vp8Settings.getter(Vp8Settings::rateControlModeAsString)).setter(Vp8Settings.setter(Builder::rateControlMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateControlMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BITRATE_FIELD, FRAMERATE_CONTROL_FIELD, FRAMERATE_CONVERSION_ALGORITHM_FIELD, FRAMERATE_DENOMINATOR_FIELD, FRAMERATE_NUMERATOR_FIELD, GOP_SIZE_FIELD, HRD_BUFFER_SIZE_FIELD, MAX_BITRATE_FIELD, PAR_CONTROL_FIELD, PAR_DENOMINATOR_FIELD, PAR_NUMERATOR_FIELD, QUALITY_TUNING_LEVEL_FIELD, RATE_CONTROL_MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer bitrate;
    private final String framerateControl;
    private final String framerateConversionAlgorithm;
    private final Integer framerateDenominator;
    private final Integer framerateNumerator;
    private final Double gopSize;
    private final Integer hrdBufferSize;
    private final Integer maxBitrate;
    private final String parControl;
    private final Integer parDenominator;
    private final Integer parNumerator;
    private final String qualityTuningLevel;
    private final String rateControlMode;

    private Vp8Settings(BuilderImpl builder) {
        this.bitrate = builder.bitrate;
        this.framerateControl = builder.framerateControl;
        this.framerateConversionAlgorithm = builder.framerateConversionAlgorithm;
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
        this.gopSize = builder.gopSize;
        this.hrdBufferSize = builder.hrdBufferSize;
        this.maxBitrate = builder.maxBitrate;
        this.parControl = builder.parControl;
        this.parDenominator = builder.parDenominator;
        this.parNumerator = builder.parNumerator;
        this.qualityTuningLevel = builder.qualityTuningLevel;
        this.rateControlMode = builder.rateControlMode;
    }

    public Integer bitrate() {
        return this.bitrate;
    }

    public Vp8FramerateControl framerateControl() {
        return Vp8FramerateControl.fromValue(this.framerateControl);
    }

    public String framerateControlAsString() {
        return this.framerateControl;
    }

    public Vp8FramerateConversionAlgorithm framerateConversionAlgorithm() {
        return Vp8FramerateConversionAlgorithm.fromValue(this.framerateConversionAlgorithm);
    }

    public String framerateConversionAlgorithmAsString() {
        return this.framerateConversionAlgorithm;
    }

    public Integer framerateDenominator() {
        return this.framerateDenominator;
    }

    public Integer framerateNumerator() {
        return this.framerateNumerator;
    }

    public Double gopSize() {
        return this.gopSize;
    }

    public Integer hrdBufferSize() {
        return this.hrdBufferSize;
    }

    public Integer maxBitrate() {
        return this.maxBitrate;
    }

    public Vp8ParControl parControl() {
        return Vp8ParControl.fromValue(this.parControl);
    }

    public String parControlAsString() {
        return this.parControl;
    }

    public Integer parDenominator() {
        return this.parDenominator;
    }

    public Integer parNumerator() {
        return this.parNumerator;
    }

    public Vp8QualityTuningLevel qualityTuningLevel() {
        return Vp8QualityTuningLevel.fromValue(this.qualityTuningLevel);
    }

    public String qualityTuningLevelAsString() {
        return this.qualityTuningLevel;
    }

    public Vp8RateControlMode rateControlMode() {
        return Vp8RateControlMode.fromValue(this.rateControlMode);
    }

    public String rateControlModeAsString() {
        return this.rateControlMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateConversionAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.hrdBufferSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.parControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(this.parNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualityTuningLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rateControlModeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Vp8Settings)) {
            return false;
        }
        Vp8Settings other = (Vp8Settings)obj;
        return Objects.equals(this.bitrate(), other.bitrate()) && Objects.equals(this.framerateControlAsString(), other.framerateControlAsString()) && Objects.equals(this.framerateConversionAlgorithmAsString(), other.framerateConversionAlgorithmAsString()) && Objects.equals(this.framerateDenominator(), other.framerateDenominator()) && Objects.equals(this.framerateNumerator(), other.framerateNumerator()) && Objects.equals(this.gopSize(), other.gopSize()) && Objects.equals(this.hrdBufferSize(), other.hrdBufferSize()) && Objects.equals(this.maxBitrate(), other.maxBitrate()) && Objects.equals(this.parControlAsString(), other.parControlAsString()) && Objects.equals(this.parDenominator(), other.parDenominator()) && Objects.equals(this.parNumerator(), other.parNumerator()) && Objects.equals(this.qualityTuningLevelAsString(), other.qualityTuningLevelAsString()) && Objects.equals(this.rateControlModeAsString(), other.rateControlModeAsString());
    }

    public String toString() {
        return ToString.builder((String)"Vp8Settings").add("Bitrate", (Object)this.bitrate()).add("FramerateControl", (Object)this.framerateControlAsString()).add("FramerateConversionAlgorithm", (Object)this.framerateConversionAlgorithmAsString()).add("FramerateDenominator", (Object)this.framerateDenominator()).add("FramerateNumerator", (Object)this.framerateNumerator()).add("GopSize", (Object)this.gopSize()).add("HrdBufferSize", (Object)this.hrdBufferSize()).add("MaxBitrate", (Object)this.maxBitrate()).add("ParControl", (Object)this.parControlAsString()).add("ParDenominator", (Object)this.parDenominator()).add("ParNumerator", (Object)this.parNumerator()).add("QualityTuningLevel", (Object)this.qualityTuningLevelAsString()).add("RateControlMode", (Object)this.rateControlModeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bitrate": {
                return Optional.ofNullable(clazz.cast(this.bitrate()));
            }
            case "FramerateControl": {
                return Optional.ofNullable(clazz.cast(this.framerateControlAsString()));
            }
            case "FramerateConversionAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.framerateConversionAlgorithmAsString()));
            }
            case "FramerateDenominator": {
                return Optional.ofNullable(clazz.cast(this.framerateDenominator()));
            }
            case "FramerateNumerator": {
                return Optional.ofNullable(clazz.cast(this.framerateNumerator()));
            }
            case "GopSize": {
                return Optional.ofNullable(clazz.cast(this.gopSize()));
            }
            case "HrdBufferSize": {
                return Optional.ofNullable(clazz.cast(this.hrdBufferSize()));
            }
            case "MaxBitrate": {
                return Optional.ofNullable(clazz.cast(this.maxBitrate()));
            }
            case "ParControl": {
                return Optional.ofNullable(clazz.cast(this.parControlAsString()));
            }
            case "ParDenominator": {
                return Optional.ofNullable(clazz.cast(this.parDenominator()));
            }
            case "ParNumerator": {
                return Optional.ofNullable(clazz.cast(this.parNumerator()));
            }
            case "QualityTuningLevel": {
                return Optional.ofNullable(clazz.cast(this.qualityTuningLevelAsString()));
            }
            case "RateControlMode": {
                return Optional.ofNullable(clazz.cast(this.rateControlModeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Vp8Settings, T> g) {
        return obj -> g.apply((Vp8Settings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer bitrate;
        private String framerateControl;
        private String framerateConversionAlgorithm;
        private Integer framerateDenominator;
        private Integer framerateNumerator;
        private Double gopSize;
        private Integer hrdBufferSize;
        private Integer maxBitrate;
        private String parControl;
        private Integer parDenominator;
        private Integer parNumerator;
        private String qualityTuningLevel;
        private String rateControlMode;

        private BuilderImpl() {
        }

        private BuilderImpl(Vp8Settings model) {
            this.bitrate(model.bitrate);
            this.framerateControl(model.framerateControl);
            this.framerateConversionAlgorithm(model.framerateConversionAlgorithm);
            this.framerateDenominator(model.framerateDenominator);
            this.framerateNumerator(model.framerateNumerator);
            this.gopSize(model.gopSize);
            this.hrdBufferSize(model.hrdBufferSize);
            this.maxBitrate(model.maxBitrate);
            this.parControl(model.parControl);
            this.parDenominator(model.parDenominator);
            this.parNumerator(model.parNumerator);
            this.qualityTuningLevel(model.qualityTuningLevel);
            this.rateControlMode(model.rateControlMode);
        }

        public final Integer getBitrate() {
            return this.bitrate;
        }

        @Override
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        public final String getFramerateControl() {
            return this.framerateControl;
        }

        @Override
        public final Builder framerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
            return this;
        }

        @Override
        public final Builder framerateControl(Vp8FramerateControl framerateControl) {
            this.framerateControl(framerateControl == null ? null : framerateControl.toString());
            return this;
        }

        public final void setFramerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
        }

        public final String getFramerateConversionAlgorithm() {
            return this.framerateConversionAlgorithm;
        }

        @Override
        public final Builder framerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
            return this;
        }

        @Override
        public final Builder framerateConversionAlgorithm(Vp8FramerateConversionAlgorithm framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm(framerateConversionAlgorithm == null ? null : framerateConversionAlgorithm.toString());
            return this;
        }

        public final void setFramerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
        }

        public final Integer getFramerateDenominator() {
            return this.framerateDenominator;
        }

        @Override
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        public final Integer getFramerateNumerator() {
            return this.framerateNumerator;
        }

        @Override
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        public final Double getGopSize() {
            return this.gopSize;
        }

        @Override
        public final Builder gopSize(Double gopSize) {
            this.gopSize = gopSize;
            return this;
        }

        public final void setGopSize(Double gopSize) {
            this.gopSize = gopSize;
        }

        public final Integer getHrdBufferSize() {
            return this.hrdBufferSize;
        }

        @Override
        public final Builder hrdBufferSize(Integer hrdBufferSize) {
            this.hrdBufferSize = hrdBufferSize;
            return this;
        }

        public final void setHrdBufferSize(Integer hrdBufferSize) {
            this.hrdBufferSize = hrdBufferSize;
        }

        public final Integer getMaxBitrate() {
            return this.maxBitrate;
        }

        @Override
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        public final String getParControl() {
            return this.parControl;
        }

        @Override
        public final Builder parControl(String parControl) {
            this.parControl = parControl;
            return this;
        }

        @Override
        public final Builder parControl(Vp8ParControl parControl) {
            this.parControl(parControl == null ? null : parControl.toString());
            return this;
        }

        public final void setParControl(String parControl) {
            this.parControl = parControl;
        }

        public final Integer getParDenominator() {
            return this.parDenominator;
        }

        @Override
        public final Builder parDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
            return this;
        }

        public final void setParDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
        }

        public final Integer getParNumerator() {
            return this.parNumerator;
        }

        @Override
        public final Builder parNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
            return this;
        }

        public final void setParNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
        }

        public final String getQualityTuningLevel() {
            return this.qualityTuningLevel;
        }

        @Override
        public final Builder qualityTuningLevel(String qualityTuningLevel) {
            this.qualityTuningLevel = qualityTuningLevel;
            return this;
        }

        @Override
        public final Builder qualityTuningLevel(Vp8QualityTuningLevel qualityTuningLevel) {
            this.qualityTuningLevel(qualityTuningLevel == null ? null : qualityTuningLevel.toString());
            return this;
        }

        public final void setQualityTuningLevel(String qualityTuningLevel) {
            this.qualityTuningLevel = qualityTuningLevel;
        }

        public final String getRateControlMode() {
            return this.rateControlMode;
        }

        @Override
        public final Builder rateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
            return this;
        }

        @Override
        public final Builder rateControlMode(Vp8RateControlMode rateControlMode) {
            this.rateControlMode(rateControlMode == null ? null : rateControlMode.toString());
            return this;
        }

        public final void setRateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
        }

        public Vp8Settings build() {
            return new Vp8Settings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Vp8Settings> {
        public Builder bitrate(Integer var1);

        public Builder framerateControl(String var1);

        public Builder framerateControl(Vp8FramerateControl var1);

        public Builder framerateConversionAlgorithm(String var1);

        public Builder framerateConversionAlgorithm(Vp8FramerateConversionAlgorithm var1);

        public Builder framerateDenominator(Integer var1);

        public Builder framerateNumerator(Integer var1);

        public Builder gopSize(Double var1);

        public Builder hrdBufferSize(Integer var1);

        public Builder maxBitrate(Integer var1);

        public Builder parControl(String var1);

        public Builder parControl(Vp8ParControl var1);

        public Builder parDenominator(Integer var1);

        public Builder parNumerator(Integer var1);

        public Builder qualityTuningLevel(String var1);

        public Builder qualityTuningLevel(Vp8QualityTuningLevel var1);

        public Builder rateControlMode(String var1);

        public Builder rateControlMode(Vp8RateControlMode var1);
    }
}

