/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.AlphaBehavior;
import software.amazon.awssdk.services.mediaconvert.model.ColorSpace;
import software.amazon.awssdk.services.mediaconvert.model.ColorSpaceUsage;
import software.amazon.awssdk.services.mediaconvert.model.Hdr10Metadata;
import software.amazon.awssdk.services.mediaconvert.model.InputRotate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VideoSelector
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VideoSelector> {
    private static final SdkField<String> ALPHA_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlphaBehavior").getter(VideoSelector.getter(VideoSelector::alphaBehaviorAsString)).setter(VideoSelector.setter(Builder::alphaBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alphaBehavior").build()}).build();
    private static final SdkField<String> COLOR_SPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColorSpace").getter(VideoSelector.getter(VideoSelector::colorSpaceAsString)).setter(VideoSelector.setter(Builder::colorSpace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorSpace").build()}).build();
    private static final SdkField<String> COLOR_SPACE_USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColorSpaceUsage").getter(VideoSelector.getter(VideoSelector::colorSpaceUsageAsString)).setter(VideoSelector.setter(Builder::colorSpaceUsage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorSpaceUsage").build()}).build();
    private static final SdkField<Hdr10Metadata> HDR10_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Hdr10Metadata").getter(VideoSelector.getter(VideoSelector::hdr10Metadata)).setter(VideoSelector.setter(Builder::hdr10Metadata)).constructor(Hdr10Metadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hdr10Metadata").build()}).build();
    private static final SdkField<Integer> PID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Pid").getter(VideoSelector.getter(VideoSelector::pid)).setter(VideoSelector.setter(Builder::pid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pid").build()}).build();
    private static final SdkField<Integer> PROGRAM_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ProgramNumber").getter(VideoSelector.getter(VideoSelector::programNumber)).setter(VideoSelector.setter(Builder::programNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programNumber").build()}).build();
    private static final SdkField<String> ROTATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Rotate").getter(VideoSelector.getter(VideoSelector::rotateAsString)).setter(VideoSelector.setter(Builder::rotate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rotate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALPHA_BEHAVIOR_FIELD, COLOR_SPACE_FIELD, COLOR_SPACE_USAGE_FIELD, HDR10_METADATA_FIELD, PID_FIELD, PROGRAM_NUMBER_FIELD, ROTATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String alphaBehavior;
    private final String colorSpace;
    private final String colorSpaceUsage;
    private final Hdr10Metadata hdr10Metadata;
    private final Integer pid;
    private final Integer programNumber;
    private final String rotate;

    private VideoSelector(BuilderImpl builder) {
        this.alphaBehavior = builder.alphaBehavior;
        this.colorSpace = builder.colorSpace;
        this.colorSpaceUsage = builder.colorSpaceUsage;
        this.hdr10Metadata = builder.hdr10Metadata;
        this.pid = builder.pid;
        this.programNumber = builder.programNumber;
        this.rotate = builder.rotate;
    }

    public AlphaBehavior alphaBehavior() {
        return AlphaBehavior.fromValue(this.alphaBehavior);
    }

    public String alphaBehaviorAsString() {
        return this.alphaBehavior;
    }

    public ColorSpace colorSpace() {
        return ColorSpace.fromValue(this.colorSpace);
    }

    public String colorSpaceAsString() {
        return this.colorSpace;
    }

    public ColorSpaceUsage colorSpaceUsage() {
        return ColorSpaceUsage.fromValue(this.colorSpaceUsage);
    }

    public String colorSpaceUsageAsString() {
        return this.colorSpaceUsage;
    }

    public Hdr10Metadata hdr10Metadata() {
        return this.hdr10Metadata;
    }

    public Integer pid() {
        return this.pid;
    }

    public Integer programNumber() {
        return this.programNumber;
    }

    public InputRotate rotate() {
        return InputRotate.fromValue(this.rotate);
    }

    public String rotateAsString() {
        return this.rotate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alphaBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.colorSpaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.colorSpaceUsageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hdr10Metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.pid());
        hashCode = 31 * hashCode + Objects.hashCode(this.programNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.rotateAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoSelector)) {
            return false;
        }
        VideoSelector other = (VideoSelector)obj;
        return Objects.equals(this.alphaBehaviorAsString(), other.alphaBehaviorAsString()) && Objects.equals(this.colorSpaceAsString(), other.colorSpaceAsString()) && Objects.equals(this.colorSpaceUsageAsString(), other.colorSpaceUsageAsString()) && Objects.equals(this.hdr10Metadata(), other.hdr10Metadata()) && Objects.equals(this.pid(), other.pid()) && Objects.equals(this.programNumber(), other.programNumber()) && Objects.equals(this.rotateAsString(), other.rotateAsString());
    }

    public String toString() {
        return ToString.builder((String)"VideoSelector").add("AlphaBehavior", (Object)this.alphaBehaviorAsString()).add("ColorSpace", (Object)this.colorSpaceAsString()).add("ColorSpaceUsage", (Object)this.colorSpaceUsageAsString()).add("Hdr10Metadata", (Object)this.hdr10Metadata()).add("Pid", (Object)this.pid()).add("ProgramNumber", (Object)this.programNumber()).add("Rotate", (Object)this.rotateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlphaBehavior": {
                return Optional.ofNullable(clazz.cast(this.alphaBehaviorAsString()));
            }
            case "ColorSpace": {
                return Optional.ofNullable(clazz.cast(this.colorSpaceAsString()));
            }
            case "ColorSpaceUsage": {
                return Optional.ofNullable(clazz.cast(this.colorSpaceUsageAsString()));
            }
            case "Hdr10Metadata": {
                return Optional.ofNullable(clazz.cast(this.hdr10Metadata()));
            }
            case "Pid": {
                return Optional.ofNullable(clazz.cast(this.pid()));
            }
            case "ProgramNumber": {
                return Optional.ofNullable(clazz.cast(this.programNumber()));
            }
            case "Rotate": {
                return Optional.ofNullable(clazz.cast(this.rotateAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VideoSelector, T> g) {
        return obj -> g.apply((VideoSelector)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String alphaBehavior;
        private String colorSpace;
        private String colorSpaceUsage;
        private Hdr10Metadata hdr10Metadata;
        private Integer pid;
        private Integer programNumber;
        private String rotate;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoSelector model) {
            this.alphaBehavior(model.alphaBehavior);
            this.colorSpace(model.colorSpace);
            this.colorSpaceUsage(model.colorSpaceUsage);
            this.hdr10Metadata(model.hdr10Metadata);
            this.pid(model.pid);
            this.programNumber(model.programNumber);
            this.rotate(model.rotate);
        }

        public final String getAlphaBehavior() {
            return this.alphaBehavior;
        }

        @Override
        public final Builder alphaBehavior(String alphaBehavior) {
            this.alphaBehavior = alphaBehavior;
            return this;
        }

        @Override
        public final Builder alphaBehavior(AlphaBehavior alphaBehavior) {
            this.alphaBehavior(alphaBehavior == null ? null : alphaBehavior.toString());
            return this;
        }

        public final void setAlphaBehavior(String alphaBehavior) {
            this.alphaBehavior = alphaBehavior;
        }

        public final String getColorSpace() {
            return this.colorSpace;
        }

        @Override
        public final Builder colorSpace(String colorSpace) {
            this.colorSpace = colorSpace;
            return this;
        }

        @Override
        public final Builder colorSpace(ColorSpace colorSpace) {
            this.colorSpace(colorSpace == null ? null : colorSpace.toString());
            return this;
        }

        public final void setColorSpace(String colorSpace) {
            this.colorSpace = colorSpace;
        }

        public final String getColorSpaceUsage() {
            return this.colorSpaceUsage;
        }

        @Override
        public final Builder colorSpaceUsage(String colorSpaceUsage) {
            this.colorSpaceUsage = colorSpaceUsage;
            return this;
        }

        @Override
        public final Builder colorSpaceUsage(ColorSpaceUsage colorSpaceUsage) {
            this.colorSpaceUsage(colorSpaceUsage == null ? null : colorSpaceUsage.toString());
            return this;
        }

        public final void setColorSpaceUsage(String colorSpaceUsage) {
            this.colorSpaceUsage = colorSpaceUsage;
        }

        public final Hdr10Metadata.Builder getHdr10Metadata() {
            return this.hdr10Metadata != null ? this.hdr10Metadata.toBuilder() : null;
        }

        @Override
        public final Builder hdr10Metadata(Hdr10Metadata hdr10Metadata) {
            this.hdr10Metadata = hdr10Metadata;
            return this;
        }

        public final void setHdr10Metadata(Hdr10Metadata.BuilderImpl hdr10Metadata) {
            this.hdr10Metadata = hdr10Metadata != null ? hdr10Metadata.build() : null;
        }

        public final Integer getPid() {
            return this.pid;
        }

        @Override
        public final Builder pid(Integer pid) {
            this.pid = pid;
            return this;
        }

        public final void setPid(Integer pid) {
            this.pid = pid;
        }

        public final Integer getProgramNumber() {
            return this.programNumber;
        }

        @Override
        public final Builder programNumber(Integer programNumber) {
            this.programNumber = programNumber;
            return this;
        }

        public final void setProgramNumber(Integer programNumber) {
            this.programNumber = programNumber;
        }

        public final String getRotate() {
            return this.rotate;
        }

        @Override
        public final Builder rotate(String rotate) {
            this.rotate = rotate;
            return this;
        }

        @Override
        public final Builder rotate(InputRotate rotate) {
            this.rotate(rotate == null ? null : rotate.toString());
            return this;
        }

        public final void setRotate(String rotate) {
            this.rotate = rotate;
        }

        public VideoSelector build() {
            return new VideoSelector(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VideoSelector> {
        public Builder alphaBehavior(String var1);

        public Builder alphaBehavior(AlphaBehavior var1);

        public Builder colorSpace(String var1);

        public Builder colorSpace(ColorSpace var1);

        public Builder colorSpaceUsage(String var1);

        public Builder colorSpaceUsage(ColorSpaceUsage var1);

        public Builder hdr10Metadata(Hdr10Metadata var1);

        default public Builder hdr10Metadata(Consumer<Hdr10Metadata.Builder> hdr10Metadata) {
            return this.hdr10Metadata((Hdr10Metadata)((Hdr10Metadata.Builder)Hdr10Metadata.builder().applyMutation(hdr10Metadata)).build());
        }

        public Builder pid(Integer var1);

        public Builder programNumber(Integer var1);

        public Builder rotate(String var1);

        public Builder rotate(InputRotate var1);
    }
}

