/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.LanguageCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HlsCaptionLanguageMapping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HlsCaptionLanguageMapping> {
    private static final SdkField<Integer> CAPTION_CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(HlsCaptionLanguageMapping.getter(HlsCaptionLanguageMapping::captionChannel)).setter(HlsCaptionLanguageMapping.setter(Builder::captionChannel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionChannel").build()}).build();
    private static final SdkField<String> CUSTOM_LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsCaptionLanguageMapping.getter(HlsCaptionLanguageMapping::customLanguageCode)).setter(HlsCaptionLanguageMapping.setter(Builder::customLanguageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customLanguageCode").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsCaptionLanguageMapping.getter(HlsCaptionLanguageMapping::languageCodeAsString)).setter(HlsCaptionLanguageMapping.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageCode").build()}).build();
    private static final SdkField<String> LANGUAGE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsCaptionLanguageMapping.getter(HlsCaptionLanguageMapping::languageDescription)).setter(HlsCaptionLanguageMapping.setter(Builder::languageDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPTION_CHANNEL_FIELD, CUSTOM_LANGUAGE_CODE_FIELD, LANGUAGE_CODE_FIELD, LANGUAGE_DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer captionChannel;
    private final String customLanguageCode;
    private final String languageCode;
    private final String languageDescription;

    private HlsCaptionLanguageMapping(BuilderImpl builder) {
        this.captionChannel = builder.captionChannel;
        this.customLanguageCode = builder.customLanguageCode;
        this.languageCode = builder.languageCode;
        this.languageDescription = builder.languageDescription;
    }

    public Integer captionChannel() {
        return this.captionChannel;
    }

    public String customLanguageCode() {
        return this.customLanguageCode;
    }

    public LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public String languageCodeAsString() {
        return this.languageCode;
    }

    public String languageDescription() {
        return this.languageDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.captionChannel());
        hashCode = 31 * hashCode + Objects.hashCode(this.customLanguageCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageDescription());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsCaptionLanguageMapping)) {
            return false;
        }
        HlsCaptionLanguageMapping other = (HlsCaptionLanguageMapping)obj;
        return Objects.equals(this.captionChannel(), other.captionChannel()) && Objects.equals(this.customLanguageCode(), other.customLanguageCode()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.languageDescription(), other.languageDescription());
    }

    public String toString() {
        return ToString.builder((String)"HlsCaptionLanguageMapping").add("CaptionChannel", (Object)this.captionChannel()).add("CustomLanguageCode", (Object)this.customLanguageCode()).add("LanguageCode", (Object)this.languageCodeAsString()).add("LanguageDescription", (Object)this.languageDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CaptionChannel": {
                return Optional.ofNullable(clazz.cast(this.captionChannel()));
            }
            case "CustomLanguageCode": {
                return Optional.ofNullable(clazz.cast(this.customLanguageCode()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "LanguageDescription": {
                return Optional.ofNullable(clazz.cast(this.languageDescription()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsCaptionLanguageMapping, T> g) {
        return obj -> g.apply((HlsCaptionLanguageMapping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer captionChannel;
        private String customLanguageCode;
        private String languageCode;
        private String languageDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsCaptionLanguageMapping model) {
            this.captionChannel(model.captionChannel);
            this.customLanguageCode(model.customLanguageCode);
            this.languageCode(model.languageCode);
            this.languageDescription(model.languageDescription);
        }

        public final Integer getCaptionChannel() {
            return this.captionChannel;
        }

        @Override
        public final Builder captionChannel(Integer captionChannel) {
            this.captionChannel = captionChannel;
            return this;
        }

        public final void setCaptionChannel(Integer captionChannel) {
            this.captionChannel = captionChannel;
        }

        public final String getCustomLanguageCode() {
            return this.customLanguageCode;
        }

        @Override
        public final Builder customLanguageCode(String customLanguageCode) {
            this.customLanguageCode = customLanguageCode;
            return this;
        }

        public final void setCustomLanguageCode(String customLanguageCode) {
            this.customLanguageCode = customLanguageCode;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final String getLanguageDescription() {
            return this.languageDescription;
        }

        @Override
        public final Builder languageDescription(String languageDescription) {
            this.languageDescription = languageDescription;
            return this;
        }

        public final void setLanguageDescription(String languageDescription) {
            this.languageDescription = languageDescription;
        }

        public HlsCaptionLanguageMapping build() {
            return new HlsCaptionLanguageMapping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HlsCaptionLanguageMapping> {
        public Builder captionChannel(Integer var1);

        public Builder customLanguageCode(String var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder languageDescription(String var1);
    }
}

