/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum VideoCodec {
    FRAME_CAPTURE("FRAME_CAPTURE"),
    AV1("AV1"),
    H_264("H_264"),
    H_265("H_265"),
    MPEG2("MPEG2"),
    PRORES("PRORES"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private VideoCodec(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VideoCodec fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(VideoCodec.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VideoCodec> knownValues() {
        return Stream.of(VideoCodec.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

