/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediaconvert.model.AccelerationSettings;
import software.amazon.awssdk.services.mediaconvert.model.HopDestination;
import software.amazon.awssdk.services.mediaconvert.model.JobTemplateSettings;
import software.amazon.awssdk.services.mediaconvert.model.MediaConvertRequest;
import software.amazon.awssdk.services.mediaconvert.model.StatusUpdateInterval;
import software.amazon.awssdk.services.mediaconvert.model.___listOfHopDestinationCopier;
import software.amazon.awssdk.services.mediaconvert.model.___mapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateJobTemplateRequest
extends MediaConvertRequest
implements ToCopyableBuilder<Builder, CreateJobTemplateRequest> {
    private static final SdkField<AccelerationSettings> ACCELERATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateJobTemplateRequest.getter(CreateJobTemplateRequest::accelerationSettings)).setter(CreateJobTemplateRequest.setter(Builder::accelerationSettings)).constructor(AccelerationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accelerationSettings").build()}).build();
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateJobTemplateRequest.getter(CreateJobTemplateRequest::category)).setter(CreateJobTemplateRequest.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateJobTemplateRequest.getter(CreateJobTemplateRequest::description)).setter(CreateJobTemplateRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<HopDestination>> HOP_DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateJobTemplateRequest.getter(CreateJobTemplateRequest::hopDestinations)).setter(CreateJobTemplateRequest.setter(Builder::hopDestinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hopDestinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HopDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateJobTemplateRequest.getter(CreateJobTemplateRequest::name)).setter(CreateJobTemplateRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateJobTemplateRequest.getter(CreateJobTemplateRequest::priority)).setter(CreateJobTemplateRequest.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()}).build();
    private static final SdkField<String> QUEUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateJobTemplateRequest.getter(CreateJobTemplateRequest::queue)).setter(CreateJobTemplateRequest.setter(Builder::queue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queue").build()}).build();
    private static final SdkField<JobTemplateSettings> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateJobTemplateRequest.getter(CreateJobTemplateRequest::settings)).setter(CreateJobTemplateRequest.setter(Builder::settings)).constructor(JobTemplateSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build()}).build();
    private static final SdkField<String> STATUS_UPDATE_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateJobTemplateRequest.getter(CreateJobTemplateRequest::statusUpdateIntervalAsString)).setter(CreateJobTemplateRequest.setter(Builder::statusUpdateInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusUpdateInterval").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(CreateJobTemplateRequest.getter(CreateJobTemplateRequest::tags)).setter(CreateJobTemplateRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATION_SETTINGS_FIELD, CATEGORY_FIELD, DESCRIPTION_FIELD, HOP_DESTINATIONS_FIELD, NAME_FIELD, PRIORITY_FIELD, QUEUE_FIELD, SETTINGS_FIELD, STATUS_UPDATE_INTERVAL_FIELD, TAGS_FIELD));
    private final AccelerationSettings accelerationSettings;
    private final String category;
    private final String description;
    private final List<HopDestination> hopDestinations;
    private final String name;
    private final Integer priority;
    private final String queue;
    private final JobTemplateSettings settings;
    private final String statusUpdateInterval;
    private final Map<String, String> tags;

    private CreateJobTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.accelerationSettings = builder.accelerationSettings;
        this.category = builder.category;
        this.description = builder.description;
        this.hopDestinations = builder.hopDestinations;
        this.name = builder.name;
        this.priority = builder.priority;
        this.queue = builder.queue;
        this.settings = builder.settings;
        this.statusUpdateInterval = builder.statusUpdateInterval;
        this.tags = builder.tags;
    }

    public AccelerationSettings accelerationSettings() {
        return this.accelerationSettings;
    }

    public String category() {
        return this.category;
    }

    public String description() {
        return this.description;
    }

    public boolean hasHopDestinations() {
        return this.hopDestinations != null && !(this.hopDestinations instanceof SdkAutoConstructList);
    }

    public List<HopDestination> hopDestinations() {
        return this.hopDestinations;
    }

    public String name() {
        return this.name;
    }

    public Integer priority() {
        return this.priority;
    }

    public String queue() {
        return this.queue;
    }

    public JobTemplateSettings settings() {
        return this.settings;
    }

    public StatusUpdateInterval statusUpdateInterval() {
        return StatusUpdateInterval.fromValue(this.statusUpdateInterval);
    }

    public String statusUpdateIntervalAsString() {
        return this.statusUpdateInterval;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accelerationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.category());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hopDestinations());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.queue());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusUpdateIntervalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobTemplateRequest)) {
            return false;
        }
        CreateJobTemplateRequest other = (CreateJobTemplateRequest)((Object)obj);
        return Objects.equals(this.accelerationSettings(), other.accelerationSettings()) && Objects.equals(this.category(), other.category()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.hopDestinations(), other.hopDestinations()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.queue(), other.queue()) && Objects.equals(this.settings(), other.settings()) && Objects.equals(this.statusUpdateIntervalAsString(), other.statusUpdateIntervalAsString()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateJobTemplateRequest").add("AccelerationSettings", (Object)this.accelerationSettings()).add("Category", (Object)this.category()).add("Description", (Object)this.description()).add("HopDestinations", this.hopDestinations()).add("Name", (Object)this.name()).add("Priority", (Object)this.priority()).add("Queue", (Object)this.queue()).add("Settings", (Object)this.settings()).add("StatusUpdateInterval", (Object)this.statusUpdateIntervalAsString()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccelerationSettings": {
                return Optional.ofNullable(clazz.cast(this.accelerationSettings()));
            }
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.category()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "HopDestinations": {
                return Optional.ofNullable(clazz.cast(this.hopDestinations()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "Queue": {
                return Optional.ofNullable(clazz.cast(this.queue()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
            case "StatusUpdateInterval": {
                return Optional.ofNullable(clazz.cast(this.statusUpdateIntervalAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateJobTemplateRequest, T> g) {
        return obj -> g.apply((CreateJobTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConvertRequest.BuilderImpl
    implements Builder {
        private AccelerationSettings accelerationSettings;
        private String category;
        private String description;
        private List<HopDestination> hopDestinations = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private Integer priority;
        private String queue;
        private JobTemplateSettings settings;
        private String statusUpdateInterval;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobTemplateRequest model) {
            super(model);
            this.accelerationSettings(model.accelerationSettings);
            this.category(model.category);
            this.description(model.description);
            this.hopDestinations(model.hopDestinations);
            this.name(model.name);
            this.priority(model.priority);
            this.queue(model.queue);
            this.settings(model.settings);
            this.statusUpdateInterval(model.statusUpdateInterval);
            this.tags(model.tags);
        }

        public final AccelerationSettings.Builder getAccelerationSettings() {
            return this.accelerationSettings != null ? this.accelerationSettings.toBuilder() : null;
        }

        @Override
        public final Builder accelerationSettings(AccelerationSettings accelerationSettings) {
            this.accelerationSettings = accelerationSettings;
            return this;
        }

        public final void setAccelerationSettings(AccelerationSettings.BuilderImpl accelerationSettings) {
            this.accelerationSettings = accelerationSettings != null ? accelerationSettings.build() : null;
        }

        public final String getCategory() {
            return this.category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<HopDestination.Builder> getHopDestinations() {
            return this.hopDestinations != null ? (Collection)this.hopDestinations.stream().map(HopDestination::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder hopDestinations(Collection<HopDestination> hopDestinations) {
            this.hopDestinations = ___listOfHopDestinationCopier.copy(hopDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hopDestinations(HopDestination ... hopDestinations) {
            this.hopDestinations(Arrays.asList(hopDestinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hopDestinations(Consumer<HopDestination.Builder> ... hopDestinations) {
            this.hopDestinations(Stream.of(hopDestinations).map(c -> (HopDestination)((HopDestination.Builder)HopDestination.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHopDestinations(Collection<HopDestination.BuilderImpl> hopDestinations) {
            this.hopDestinations = ___listOfHopDestinationCopier.copyFromBuilder(hopDestinations);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final String getQueue() {
            return this.queue;
        }

        @Override
        public final Builder queue(String queue) {
            this.queue = queue;
            return this;
        }

        public final void setQueue(String queue) {
            this.queue = queue;
        }

        public final JobTemplateSettings.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        @Override
        public final Builder settings(JobTemplateSettings settings) {
            this.settings = settings;
            return this;
        }

        public final void setSettings(JobTemplateSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        public final String getStatusUpdateInterval() {
            return this.statusUpdateInterval;
        }

        @Override
        public final Builder statusUpdateInterval(String statusUpdateInterval) {
            this.statusUpdateInterval = statusUpdateInterval;
            return this;
        }

        @Override
        public final Builder statusUpdateInterval(StatusUpdateInterval statusUpdateInterval) {
            this.statusUpdateInterval(statusUpdateInterval == null ? null : statusUpdateInterval.toString());
            return this;
        }

        public final void setStatusUpdateInterval(String statusUpdateInterval) {
            this.statusUpdateInterval = statusUpdateInterval;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateJobTemplateRequest build() {
            return new CreateJobTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaConvertRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateJobTemplateRequest> {
        public Builder accelerationSettings(AccelerationSettings var1);

        default public Builder accelerationSettings(Consumer<AccelerationSettings.Builder> accelerationSettings) {
            return this.accelerationSettings((AccelerationSettings)((AccelerationSettings.Builder)AccelerationSettings.builder().applyMutation(accelerationSettings)).build());
        }

        public Builder category(String var1);

        public Builder description(String var1);

        public Builder hopDestinations(Collection<HopDestination> var1);

        public Builder hopDestinations(HopDestination ... var1);

        public Builder hopDestinations(Consumer<HopDestination.Builder> ... var1);

        public Builder name(String var1);

        public Builder priority(Integer var1);

        public Builder queue(String var1);

        public Builder settings(JobTemplateSettings var1);

        default public Builder settings(Consumer<JobTemplateSettings.Builder> settings) {
            return this.settings((JobTemplateSettings)((JobTemplateSettings.Builder)JobTemplateSettings.builder().applyMutation(settings)).build());
        }

        public Builder statusUpdateInterval(String var1);

        public Builder statusUpdateInterval(StatusUpdateInterval var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

