/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.JobTemplateSettings;
import software.amazon.awssdk.services.mediaconvert.model.MediaConvertRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateJobTemplateRequest
extends MediaConvertRequest
implements ToCopyableBuilder<Builder, UpdateJobTemplateRequest> {
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateJobTemplateRequest.getter(UpdateJobTemplateRequest::category)).setter(UpdateJobTemplateRequest.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateJobTemplateRequest.getter(UpdateJobTemplateRequest::description)).setter(UpdateJobTemplateRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateJobTemplateRequest.getter(UpdateJobTemplateRequest::name)).setter(UpdateJobTemplateRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<String> QUEUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateJobTemplateRequest.getter(UpdateJobTemplateRequest::queue)).setter(UpdateJobTemplateRequest.setter(Builder::queue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queue").build()}).build();
    private static final SdkField<JobTemplateSettings> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateJobTemplateRequest.getter(UpdateJobTemplateRequest::settings)).setter(UpdateJobTemplateRequest.setter(Builder::settings)).constructor(JobTemplateSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FIELD, DESCRIPTION_FIELD, NAME_FIELD, QUEUE_FIELD, SETTINGS_FIELD));
    private final String category;
    private final String description;
    private final String name;
    private final String queue;
    private final JobTemplateSettings settings;

    private UpdateJobTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.category = builder.category;
        this.description = builder.description;
        this.name = builder.name;
        this.queue = builder.queue;
        this.settings = builder.settings;
    }

    public String category() {
        return this.category;
    }

    public String description() {
        return this.description;
    }

    public String name() {
        return this.name;
    }

    public String queue() {
        return this.queue;
    }

    public JobTemplateSettings settings() {
        return this.settings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.category());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.queue());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateJobTemplateRequest)) {
            return false;
        }
        UpdateJobTemplateRequest other = (UpdateJobTemplateRequest)((Object)obj);
        return Objects.equals(this.category(), other.category()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.queue(), other.queue()) && Objects.equals(this.settings(), other.settings());
    }

    public String toString() {
        return ToString.builder((String)"UpdateJobTemplateRequest").add("Category", (Object)this.category()).add("Description", (Object)this.description()).add("Name", (Object)this.name()).add("Queue", (Object)this.queue()).add("Settings", (Object)this.settings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.category()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Queue": {
                return Optional.ofNullable(clazz.cast(this.queue()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateJobTemplateRequest, T> g) {
        return obj -> g.apply((UpdateJobTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConvertRequest.BuilderImpl
    implements Builder {
        private String category;
        private String description;
        private String name;
        private String queue;
        private JobTemplateSettings settings;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateJobTemplateRequest model) {
            super(model);
            this.category(model.category);
            this.description(model.description);
            this.name(model.name);
            this.queue(model.queue);
            this.settings(model.settings);
        }

        public final String getCategory() {
            return this.category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getQueue() {
            return this.queue;
        }

        @Override
        public final Builder queue(String queue) {
            this.queue = queue;
            return this;
        }

        public final void setQueue(String queue) {
            this.queue = queue;
        }

        public final JobTemplateSettings.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        @Override
        public final Builder settings(JobTemplateSettings settings) {
            this.settings = settings;
            return this;
        }

        public final void setSettings(JobTemplateSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateJobTemplateRequest build() {
            return new UpdateJobTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaConvertRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateJobTemplateRequest> {
        public Builder category(String var1);

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder queue(String var1);

        public Builder settings(JobTemplateSettings var1);

        default public Builder settings(Consumer<JobTemplateSettings.Builder> settings) {
            return this.settings((JobTemplateSettings)((JobTemplateSettings.Builder)JobTemplateSettings.builder().applyMutation(settings)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

