/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.TimecodeBurnin;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TimecodeBurninMarshaller {
    private static final MarshallingInfo<Integer> FONTSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fontSize").isBinary(false).build();
    private static final MarshallingInfo<String> POSITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("position").isBinary(false).build();
    private static final MarshallingInfo<String> PREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("prefix").isBinary(false).build();
    private static final TimecodeBurninMarshaller INSTANCE = new TimecodeBurninMarshaller();

    private TimecodeBurninMarshaller() {
    }

    public static TimecodeBurninMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TimecodeBurnin timecodeBurnin, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)timecodeBurnin, (String)"timecodeBurnin");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)timecodeBurnin.fontSize(), FONTSIZE_BINDING);
            protocolMarshaller.marshall((Object)timecodeBurnin.positionString(), POSITION_BINDING);
            protocolMarshaller.marshall((Object)timecodeBurnin.prefix(), PREFIX_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

