/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mediaconvert.model.HlsEncryptionSettings;
import software.amazon.awssdk.services.mediaconvert.transform.SpekeKeyProviderUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.StaticKeyProviderUnmarshaller;

public class HlsEncryptionSettingsUnmarshaller
implements Unmarshaller<HlsEncryptionSettings, JsonUnmarshallerContext> {
    private static final HlsEncryptionSettingsUnmarshaller INSTANCE = new HlsEncryptionSettingsUnmarshaller();

    public HlsEncryptionSettings unmarshall(JsonUnmarshallerContext context) throws Exception {
        HlsEncryptionSettings.Builder hlsEncryptionSettingsBuilder = HlsEncryptionSettings.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("constantInitializationVector", targetDepth)) {
                    context.nextToken();
                    hlsEncryptionSettingsBuilder.constantInitializationVector((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("encryptionMethod", targetDepth)) {
                    context.nextToken();
                    hlsEncryptionSettingsBuilder.encryptionMethod((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("initializationVectorInManifest", targetDepth)) {
                    context.nextToken();
                    hlsEncryptionSettingsBuilder.initializationVectorInManifest((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("spekeKeyProvider", targetDepth)) {
                    context.nextToken();
                    hlsEncryptionSettingsBuilder.spekeKeyProvider(SpekeKeyProviderUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("staticKeyProvider", targetDepth)) {
                    context.nextToken();
                    hlsEncryptionSettingsBuilder.staticKeyProvider(StaticKeyProviderUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("type", targetDepth)) {
                    context.nextToken();
                    hlsEncryptionSettingsBuilder.type((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (HlsEncryptionSettings)hlsEncryptionSettingsBuilder.build();
    }

    public static HlsEncryptionSettingsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

