/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.AudioSelector;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AudioSelectorMarshaller {
    private static final MarshallingInfo<String> DEFAULTSELECTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("defaultSelection").isBinary(false).build();
    private static final MarshallingInfo<String> EXTERNALAUDIOFILEINPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("externalAudioFileInput").isBinary(false).build();
    private static final MarshallingInfo<String> LANGUAGECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("languageCode").isBinary(false).build();
    private static final MarshallingInfo<Integer> OFFSET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("offset").isBinary(false).build();
    private static final MarshallingInfo<List> PIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pids").isBinary(false).build();
    private static final MarshallingInfo<Integer> PROGRAMSELECTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("programSelection").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> REMIXSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("remixSettings").isBinary(false).build();
    private static final MarshallingInfo<String> SELECTORTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("selectorType").isBinary(false).build();
    private static final MarshallingInfo<List> TRACKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tracks").isBinary(false).build();
    private static final AudioSelectorMarshaller INSTANCE = new AudioSelectorMarshaller();

    private AudioSelectorMarshaller() {
    }

    public static AudioSelectorMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AudioSelector audioSelector, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)audioSelector, (String)"audioSelector");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)audioSelector.defaultSelectionString(), DEFAULTSELECTION_BINDING);
            protocolMarshaller.marshall((Object)audioSelector.externalAudioFileInput(), EXTERNALAUDIOFILEINPUT_BINDING);
            protocolMarshaller.marshall((Object)audioSelector.languageCodeString(), LANGUAGECODE_BINDING);
            protocolMarshaller.marshall((Object)audioSelector.offset(), OFFSET_BINDING);
            protocolMarshaller.marshall(audioSelector.pids(), PIDS_BINDING);
            protocolMarshaller.marshall((Object)audioSelector.programSelection(), PROGRAMSELECTION_BINDING);
            protocolMarshaller.marshall((Object)audioSelector.remixSettings(), REMIXSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)audioSelector.selectorTypeString(), SELECTORTYPE_BINDING);
            protocolMarshaller.marshall(audioSelector.tracks(), TRACKS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

