/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mediaconvert.model.AudioCodecSettings;
import software.amazon.awssdk.services.mediaconvert.transform.AacSettingsUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.Ac3SettingsUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.AiffSettingsUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.Eac3SettingsUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.Mp2SettingsUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.WavSettingsUnmarshaller;

public class AudioCodecSettingsUnmarshaller
implements Unmarshaller<AudioCodecSettings, JsonUnmarshallerContext> {
    private static final AudioCodecSettingsUnmarshaller INSTANCE = new AudioCodecSettingsUnmarshaller();

    public AudioCodecSettings unmarshall(JsonUnmarshallerContext context) throws Exception {
        AudioCodecSettings.Builder audioCodecSettingsBuilder = AudioCodecSettings.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("aacSettings", targetDepth)) {
                    context.nextToken();
                    audioCodecSettingsBuilder.aacSettings(AacSettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ac3Settings", targetDepth)) {
                    context.nextToken();
                    audioCodecSettingsBuilder.ac3Settings(Ac3SettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("aiffSettings", targetDepth)) {
                    context.nextToken();
                    audioCodecSettingsBuilder.aiffSettings(AiffSettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("codec", targetDepth)) {
                    context.nextToken();
                    audioCodecSettingsBuilder.codec((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("eac3Settings", targetDepth)) {
                    context.nextToken();
                    audioCodecSettingsBuilder.eac3Settings(Eac3SettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("mp2Settings", targetDepth)) {
                    context.nextToken();
                    audioCodecSettingsBuilder.mp2Settings(Mp2SettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("wavSettings", targetDepth)) {
                    context.nextToken();
                    audioCodecSettingsBuilder.wavSettings(WavSettingsUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (AudioCodecSettings)audioCodecSettingsBuilder.build();
    }

    public static AudioCodecSettingsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

