/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.AfdSignaling;
import software.amazon.awssdk.services.mediaconvert.model.AntiAlias;
import software.amazon.awssdk.services.mediaconvert.model.ColorMetadata;
import software.amazon.awssdk.services.mediaconvert.model.DropFrameTimecode;
import software.amazon.awssdk.services.mediaconvert.model.Rectangle;
import software.amazon.awssdk.services.mediaconvert.model.RespondToAfd;
import software.amazon.awssdk.services.mediaconvert.model.ScalingBehavior;
import software.amazon.awssdk.services.mediaconvert.model.VideoCodecSettings;
import software.amazon.awssdk.services.mediaconvert.model.VideoPreprocessor;
import software.amazon.awssdk.services.mediaconvert.model.VideoTimecodeInsertion;
import software.amazon.awssdk.services.mediaconvert.transform.VideoDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VideoDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, VideoDescription> {
    private final String afdSignaling;
    private final String antiAlias;
    private final VideoCodecSettings codecSettings;
    private final String colorMetadata;
    private final Rectangle crop;
    private final String dropFrameTimecode;
    private final Integer fixedAfd;
    private final Integer height;
    private final Rectangle position;
    private final String respondToAfd;
    private final String scalingBehavior;
    private final Integer sharpness;
    private final String timecodeInsertion;
    private final VideoPreprocessor videoPreprocessors;
    private final Integer width;

    private VideoDescription(BuilderImpl builder) {
        this.afdSignaling = builder.afdSignaling;
        this.antiAlias = builder.antiAlias;
        this.codecSettings = builder.codecSettings;
        this.colorMetadata = builder.colorMetadata;
        this.crop = builder.crop;
        this.dropFrameTimecode = builder.dropFrameTimecode;
        this.fixedAfd = builder.fixedAfd;
        this.height = builder.height;
        this.position = builder.position;
        this.respondToAfd = builder.respondToAfd;
        this.scalingBehavior = builder.scalingBehavior;
        this.sharpness = builder.sharpness;
        this.timecodeInsertion = builder.timecodeInsertion;
        this.videoPreprocessors = builder.videoPreprocessors;
        this.width = builder.width;
    }

    public AfdSignaling afdSignaling() {
        return AfdSignaling.fromValue(this.afdSignaling);
    }

    public String afdSignalingString() {
        return this.afdSignaling;
    }

    public AntiAlias antiAlias() {
        return AntiAlias.fromValue(this.antiAlias);
    }

    public String antiAliasString() {
        return this.antiAlias;
    }

    public VideoCodecSettings codecSettings() {
        return this.codecSettings;
    }

    public ColorMetadata colorMetadata() {
        return ColorMetadata.fromValue(this.colorMetadata);
    }

    public String colorMetadataString() {
        return this.colorMetadata;
    }

    public Rectangle crop() {
        return this.crop;
    }

    public DropFrameTimecode dropFrameTimecode() {
        return DropFrameTimecode.fromValue(this.dropFrameTimecode);
    }

    public String dropFrameTimecodeString() {
        return this.dropFrameTimecode;
    }

    public Integer fixedAfd() {
        return this.fixedAfd;
    }

    public Integer height() {
        return this.height;
    }

    public Rectangle position() {
        return this.position;
    }

    public RespondToAfd respondToAfd() {
        return RespondToAfd.fromValue(this.respondToAfd);
    }

    public String respondToAfdString() {
        return this.respondToAfd;
    }

    public ScalingBehavior scalingBehavior() {
        return ScalingBehavior.fromValue(this.scalingBehavior);
    }

    public String scalingBehaviorString() {
        return this.scalingBehavior;
    }

    public Integer sharpness() {
        return this.sharpness;
    }

    public VideoTimecodeInsertion timecodeInsertion() {
        return VideoTimecodeInsertion.fromValue(this.timecodeInsertion);
    }

    public String timecodeInsertionString() {
        return this.timecodeInsertion;
    }

    public VideoPreprocessor videoPreprocessors() {
        return this.videoPreprocessors;
    }

    public Integer width() {
        return this.width;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.afdSignalingString());
        hashCode = 31 * hashCode + Objects.hashCode(this.antiAliasString());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.colorMetadataString());
        hashCode = 31 * hashCode + Objects.hashCode(this.crop());
        hashCode = 31 * hashCode + Objects.hashCode(this.dropFrameTimecodeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedAfd());
        hashCode = 31 * hashCode + Objects.hashCode(this.height());
        hashCode = 31 * hashCode + Objects.hashCode(this.position());
        hashCode = 31 * hashCode + Objects.hashCode(this.respondToAfdString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingBehaviorString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sharpness());
        hashCode = 31 * hashCode + Objects.hashCode(this.timecodeInsertionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoPreprocessors());
        hashCode = 31 * hashCode + Objects.hashCode(this.width());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoDescription)) {
            return false;
        }
        VideoDescription other = (VideoDescription)obj;
        return Objects.equals(this.afdSignalingString(), other.afdSignalingString()) && Objects.equals(this.antiAliasString(), other.antiAliasString()) && Objects.equals(this.codecSettings(), other.codecSettings()) && Objects.equals(this.colorMetadataString(), other.colorMetadataString()) && Objects.equals(this.crop(), other.crop()) && Objects.equals(this.dropFrameTimecodeString(), other.dropFrameTimecodeString()) && Objects.equals(this.fixedAfd(), other.fixedAfd()) && Objects.equals(this.height(), other.height()) && Objects.equals(this.position(), other.position()) && Objects.equals(this.respondToAfdString(), other.respondToAfdString()) && Objects.equals(this.scalingBehaviorString(), other.scalingBehaviorString()) && Objects.equals(this.sharpness(), other.sharpness()) && Objects.equals(this.timecodeInsertionString(), other.timecodeInsertionString()) && Objects.equals(this.videoPreprocessors(), other.videoPreprocessors()) && Objects.equals(this.width(), other.width());
    }

    public String toString() {
        return ToString.builder((String)"VideoDescription").add("AfdSignaling", (Object)this.afdSignalingString()).add("AntiAlias", (Object)this.antiAliasString()).add("CodecSettings", (Object)this.codecSettings()).add("ColorMetadata", (Object)this.colorMetadataString()).add("Crop", (Object)this.crop()).add("DropFrameTimecode", (Object)this.dropFrameTimecodeString()).add("FixedAfd", (Object)this.fixedAfd()).add("Height", (Object)this.height()).add("Position", (Object)this.position()).add("RespondToAfd", (Object)this.respondToAfdString()).add("ScalingBehavior", (Object)this.scalingBehaviorString()).add("Sharpness", (Object)this.sharpness()).add("TimecodeInsertion", (Object)this.timecodeInsertionString()).add("VideoPreprocessors", (Object)this.videoPreprocessors()).add("Width", (Object)this.width()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AfdSignaling": {
                return Optional.of(clazz.cast(this.afdSignalingString()));
            }
            case "AntiAlias": {
                return Optional.of(clazz.cast(this.antiAliasString()));
            }
            case "CodecSettings": {
                return Optional.of(clazz.cast(this.codecSettings()));
            }
            case "ColorMetadata": {
                return Optional.of(clazz.cast(this.colorMetadataString()));
            }
            case "Crop": {
                return Optional.of(clazz.cast(this.crop()));
            }
            case "DropFrameTimecode": {
                return Optional.of(clazz.cast(this.dropFrameTimecodeString()));
            }
            case "FixedAfd": {
                return Optional.of(clazz.cast(this.fixedAfd()));
            }
            case "Height": {
                return Optional.of(clazz.cast(this.height()));
            }
            case "Position": {
                return Optional.of(clazz.cast(this.position()));
            }
            case "RespondToAfd": {
                return Optional.of(clazz.cast(this.respondToAfdString()));
            }
            case "ScalingBehavior": {
                return Optional.of(clazz.cast(this.scalingBehaviorString()));
            }
            case "Sharpness": {
                return Optional.of(clazz.cast(this.sharpness()));
            }
            case "TimecodeInsertion": {
                return Optional.of(clazz.cast(this.timecodeInsertionString()));
            }
            case "VideoPreprocessors": {
                return Optional.of(clazz.cast(this.videoPreprocessors()));
            }
            case "Width": {
                return Optional.of(clazz.cast(this.width()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VideoDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String afdSignaling;
        private String antiAlias;
        private VideoCodecSettings codecSettings;
        private String colorMetadata;
        private Rectangle crop;
        private String dropFrameTimecode;
        private Integer fixedAfd;
        private Integer height;
        private Rectangle position;
        private String respondToAfd;
        private String scalingBehavior;
        private Integer sharpness;
        private String timecodeInsertion;
        private VideoPreprocessor videoPreprocessors;
        private Integer width;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoDescription model) {
            this.afdSignaling(model.afdSignaling);
            this.antiAlias(model.antiAlias);
            this.codecSettings(model.codecSettings);
            this.colorMetadata(model.colorMetadata);
            this.crop(model.crop);
            this.dropFrameTimecode(model.dropFrameTimecode);
            this.fixedAfd(model.fixedAfd);
            this.height(model.height);
            this.position(model.position);
            this.respondToAfd(model.respondToAfd);
            this.scalingBehavior(model.scalingBehavior);
            this.sharpness(model.sharpness);
            this.timecodeInsertion(model.timecodeInsertion);
            this.videoPreprocessors(model.videoPreprocessors);
            this.width(model.width);
        }

        public final String getAfdSignaling() {
            return this.afdSignaling;
        }

        @Override
        public final Builder afdSignaling(String afdSignaling) {
            this.afdSignaling = afdSignaling;
            return this;
        }

        @Override
        public final Builder afdSignaling(AfdSignaling afdSignaling) {
            this.afdSignaling(afdSignaling.toString());
            return this;
        }

        public final void setAfdSignaling(String afdSignaling) {
            this.afdSignaling = afdSignaling;
        }

        public final String getAntiAlias() {
            return this.antiAlias;
        }

        @Override
        public final Builder antiAlias(String antiAlias) {
            this.antiAlias = antiAlias;
            return this;
        }

        @Override
        public final Builder antiAlias(AntiAlias antiAlias) {
            this.antiAlias(antiAlias.toString());
            return this;
        }

        public final void setAntiAlias(String antiAlias) {
            this.antiAlias = antiAlias;
        }

        public final VideoCodecSettings.Builder getCodecSettings() {
            return this.codecSettings != null ? this.codecSettings.toBuilder() : null;
        }

        @Override
        public final Builder codecSettings(VideoCodecSettings codecSettings) {
            this.codecSettings = codecSettings;
            return this;
        }

        public final void setCodecSettings(VideoCodecSettings.BuilderImpl codecSettings) {
            this.codecSettings = codecSettings != null ? codecSettings.build() : null;
        }

        public final String getColorMetadata() {
            return this.colorMetadata;
        }

        @Override
        public final Builder colorMetadata(String colorMetadata) {
            this.colorMetadata = colorMetadata;
            return this;
        }

        @Override
        public final Builder colorMetadata(ColorMetadata colorMetadata) {
            this.colorMetadata(colorMetadata.toString());
            return this;
        }

        public final void setColorMetadata(String colorMetadata) {
            this.colorMetadata = colorMetadata;
        }

        public final Rectangle.Builder getCrop() {
            return this.crop != null ? this.crop.toBuilder() : null;
        }

        @Override
        public final Builder crop(Rectangle crop) {
            this.crop = crop;
            return this;
        }

        public final void setCrop(Rectangle.BuilderImpl crop) {
            this.crop = crop != null ? crop.build() : null;
        }

        public final String getDropFrameTimecode() {
            return this.dropFrameTimecode;
        }

        @Override
        public final Builder dropFrameTimecode(String dropFrameTimecode) {
            this.dropFrameTimecode = dropFrameTimecode;
            return this;
        }

        @Override
        public final Builder dropFrameTimecode(DropFrameTimecode dropFrameTimecode) {
            this.dropFrameTimecode(dropFrameTimecode.toString());
            return this;
        }

        public final void setDropFrameTimecode(String dropFrameTimecode) {
            this.dropFrameTimecode = dropFrameTimecode;
        }

        public final Integer getFixedAfd() {
            return this.fixedAfd;
        }

        @Override
        public final Builder fixedAfd(Integer fixedAfd) {
            this.fixedAfd = fixedAfd;
            return this;
        }

        public final void setFixedAfd(Integer fixedAfd) {
            this.fixedAfd = fixedAfd;
        }

        public final Integer getHeight() {
            return this.height;
        }

        @Override
        public final Builder height(Integer height) {
            this.height = height;
            return this;
        }

        public final void setHeight(Integer height) {
            this.height = height;
        }

        public final Rectangle.Builder getPosition() {
            return this.position != null ? this.position.toBuilder() : null;
        }

        @Override
        public final Builder position(Rectangle position) {
            this.position = position;
            return this;
        }

        public final void setPosition(Rectangle.BuilderImpl position) {
            this.position = position != null ? position.build() : null;
        }

        public final String getRespondToAfd() {
            return this.respondToAfd;
        }

        @Override
        public final Builder respondToAfd(String respondToAfd) {
            this.respondToAfd = respondToAfd;
            return this;
        }

        @Override
        public final Builder respondToAfd(RespondToAfd respondToAfd) {
            this.respondToAfd(respondToAfd.toString());
            return this;
        }

        public final void setRespondToAfd(String respondToAfd) {
            this.respondToAfd = respondToAfd;
        }

        public final String getScalingBehavior() {
            return this.scalingBehavior;
        }

        @Override
        public final Builder scalingBehavior(String scalingBehavior) {
            this.scalingBehavior = scalingBehavior;
            return this;
        }

        @Override
        public final Builder scalingBehavior(ScalingBehavior scalingBehavior) {
            this.scalingBehavior(scalingBehavior.toString());
            return this;
        }

        public final void setScalingBehavior(String scalingBehavior) {
            this.scalingBehavior = scalingBehavior;
        }

        public final Integer getSharpness() {
            return this.sharpness;
        }

        @Override
        public final Builder sharpness(Integer sharpness) {
            this.sharpness = sharpness;
            return this;
        }

        public final void setSharpness(Integer sharpness) {
            this.sharpness = sharpness;
        }

        public final String getTimecodeInsertion() {
            return this.timecodeInsertion;
        }

        @Override
        public final Builder timecodeInsertion(String timecodeInsertion) {
            this.timecodeInsertion = timecodeInsertion;
            return this;
        }

        @Override
        public final Builder timecodeInsertion(VideoTimecodeInsertion timecodeInsertion) {
            this.timecodeInsertion(timecodeInsertion.toString());
            return this;
        }

        public final void setTimecodeInsertion(String timecodeInsertion) {
            this.timecodeInsertion = timecodeInsertion;
        }

        public final VideoPreprocessor.Builder getVideoPreprocessors() {
            return this.videoPreprocessors != null ? this.videoPreprocessors.toBuilder() : null;
        }

        @Override
        public final Builder videoPreprocessors(VideoPreprocessor videoPreprocessors) {
            this.videoPreprocessors = videoPreprocessors;
            return this;
        }

        public final void setVideoPreprocessors(VideoPreprocessor.BuilderImpl videoPreprocessors) {
            this.videoPreprocessors = videoPreprocessors != null ? videoPreprocessors.build() : null;
        }

        public final Integer getWidth() {
            return this.width;
        }

        @Override
        public final Builder width(Integer width) {
            this.width = width;
            return this;
        }

        public final void setWidth(Integer width) {
            this.width = width;
        }

        public VideoDescription build() {
            return new VideoDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VideoDescription> {
        public Builder afdSignaling(String var1);

        public Builder afdSignaling(AfdSignaling var1);

        public Builder antiAlias(String var1);

        public Builder antiAlias(AntiAlias var1);

        public Builder codecSettings(VideoCodecSettings var1);

        default public Builder codecSettings(Consumer<VideoCodecSettings.Builder> codecSettings) {
            return this.codecSettings((VideoCodecSettings)((VideoCodecSettings.Builder)VideoCodecSettings.builder().apply(codecSettings)).build());
        }

        public Builder colorMetadata(String var1);

        public Builder colorMetadata(ColorMetadata var1);

        public Builder crop(Rectangle var1);

        default public Builder crop(Consumer<Rectangle.Builder> crop) {
            return this.crop((Rectangle)((Rectangle.Builder)Rectangle.builder().apply(crop)).build());
        }

        public Builder dropFrameTimecode(String var1);

        public Builder dropFrameTimecode(DropFrameTimecode var1);

        public Builder fixedAfd(Integer var1);

        public Builder height(Integer var1);

        public Builder position(Rectangle var1);

        default public Builder position(Consumer<Rectangle.Builder> position) {
            return this.position((Rectangle)((Rectangle.Builder)Rectangle.builder().apply(position)).build());
        }

        public Builder respondToAfd(String var1);

        public Builder respondToAfd(RespondToAfd var1);

        public Builder scalingBehavior(String var1);

        public Builder scalingBehavior(ScalingBehavior var1);

        public Builder sharpness(Integer var1);

        public Builder timecodeInsertion(String var1);

        public Builder timecodeInsertion(VideoTimecodeInsertion var1);

        public Builder videoPreprocessors(VideoPreprocessor var1);

        default public Builder videoPreprocessors(Consumer<VideoPreprocessor.Builder> videoPreprocessors) {
            return this.videoPreprocessors((VideoPreprocessor)((VideoPreprocessor.Builder)VideoPreprocessor.builder().apply(videoPreprocessors)).build());
        }

        public Builder width(Integer var1);
    }
}

