/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.transform.Id3InsertionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Id3Insertion
implements StructuredPojo,
ToCopyableBuilder<Builder, Id3Insertion> {
    private final String id3;
    private final String timecode;

    private Id3Insertion(BuilderImpl builder) {
        this.id3 = builder.id3;
        this.timecode = builder.timecode;
    }

    public String id3() {
        return this.id3;
    }

    public String timecode() {
        return this.timecode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id3());
        hashCode = 31 * hashCode + Objects.hashCode(this.timecode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Id3Insertion)) {
            return false;
        }
        Id3Insertion other = (Id3Insertion)obj;
        return Objects.equals(this.id3(), other.id3()) && Objects.equals(this.timecode(), other.timecode());
    }

    public String toString() {
        return ToString.builder((String)"Id3Insertion").add("Id3", (Object)this.id3()).add("Timecode", (Object)this.timecode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id3": {
                return Optional.of(clazz.cast(this.id3()));
            }
            case "Timecode": {
                return Optional.of(clazz.cast(this.timecode()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        Id3InsertionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id3;
        private String timecode;

        private BuilderImpl() {
        }

        private BuilderImpl(Id3Insertion model) {
            this.id3(model.id3);
            this.timecode(model.timecode);
        }

        public final String getId3() {
            return this.id3;
        }

        @Override
        public final Builder id3(String id3) {
            this.id3 = id3;
            return this;
        }

        public final void setId3(String id3) {
            this.id3 = id3;
        }

        public final String getTimecode() {
            return this.timecode;
        }

        @Override
        public final Builder timecode(String timecode) {
            this.timecode = timecode;
            return this;
        }

        public final void setTimecode(String timecode) {
            this.timecode = timecode;
        }

        public Id3Insertion build() {
            return new Id3Insertion(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Id3Insertion> {
        public Builder id3(String var1);

        public Builder timecode(String var1);
    }
}

