/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.Eac3AttenuationControl;
import software.amazon.awssdk.services.mediaconvert.model.Eac3BitstreamMode;
import software.amazon.awssdk.services.mediaconvert.model.Eac3CodingMode;
import software.amazon.awssdk.services.mediaconvert.model.Eac3DcFilter;
import software.amazon.awssdk.services.mediaconvert.model.Eac3DynamicRangeCompressionLine;
import software.amazon.awssdk.services.mediaconvert.model.Eac3DynamicRangeCompressionRf;
import software.amazon.awssdk.services.mediaconvert.model.Eac3LfeControl;
import software.amazon.awssdk.services.mediaconvert.model.Eac3LfeFilter;
import software.amazon.awssdk.services.mediaconvert.model.Eac3MetadataControl;
import software.amazon.awssdk.services.mediaconvert.model.Eac3PassthroughControl;
import software.amazon.awssdk.services.mediaconvert.model.Eac3PhaseControl;
import software.amazon.awssdk.services.mediaconvert.model.Eac3StereoDownmix;
import software.amazon.awssdk.services.mediaconvert.model.Eac3SurroundExMode;
import software.amazon.awssdk.services.mediaconvert.model.Eac3SurroundMode;
import software.amazon.awssdk.services.mediaconvert.transform.Eac3SettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Eac3Settings
implements StructuredPojo,
ToCopyableBuilder<Builder, Eac3Settings> {
    private final String attenuationControl;
    private final Integer bitrate;
    private final String bitstreamMode;
    private final String codingMode;
    private final String dcFilter;
    private final Integer dialnorm;
    private final String dynamicRangeCompressionLine;
    private final String dynamicRangeCompressionRf;
    private final String lfeControl;
    private final String lfeFilter;
    private final Double loRoCenterMixLevel;
    private final Double loRoSurroundMixLevel;
    private final Double ltRtCenterMixLevel;
    private final Double ltRtSurroundMixLevel;
    private final String metadataControl;
    private final String passthroughControl;
    private final String phaseControl;
    private final Integer sampleRate;
    private final String stereoDownmix;
    private final String surroundExMode;
    private final String surroundMode;

    private Eac3Settings(BuilderImpl builder) {
        this.attenuationControl = builder.attenuationControl;
        this.bitrate = builder.bitrate;
        this.bitstreamMode = builder.bitstreamMode;
        this.codingMode = builder.codingMode;
        this.dcFilter = builder.dcFilter;
        this.dialnorm = builder.dialnorm;
        this.dynamicRangeCompressionLine = builder.dynamicRangeCompressionLine;
        this.dynamicRangeCompressionRf = builder.dynamicRangeCompressionRf;
        this.lfeControl = builder.lfeControl;
        this.lfeFilter = builder.lfeFilter;
        this.loRoCenterMixLevel = builder.loRoCenterMixLevel;
        this.loRoSurroundMixLevel = builder.loRoSurroundMixLevel;
        this.ltRtCenterMixLevel = builder.ltRtCenterMixLevel;
        this.ltRtSurroundMixLevel = builder.ltRtSurroundMixLevel;
        this.metadataControl = builder.metadataControl;
        this.passthroughControl = builder.passthroughControl;
        this.phaseControl = builder.phaseControl;
        this.sampleRate = builder.sampleRate;
        this.stereoDownmix = builder.stereoDownmix;
        this.surroundExMode = builder.surroundExMode;
        this.surroundMode = builder.surroundMode;
    }

    public Eac3AttenuationControl attenuationControl() {
        return Eac3AttenuationControl.fromValue(this.attenuationControl);
    }

    public String attenuationControlString() {
        return this.attenuationControl;
    }

    public Integer bitrate() {
        return this.bitrate;
    }

    public Eac3BitstreamMode bitstreamMode() {
        return Eac3BitstreamMode.fromValue(this.bitstreamMode);
    }

    public String bitstreamModeString() {
        return this.bitstreamMode;
    }

    public Eac3CodingMode codingMode() {
        return Eac3CodingMode.fromValue(this.codingMode);
    }

    public String codingModeString() {
        return this.codingMode;
    }

    public Eac3DcFilter dcFilter() {
        return Eac3DcFilter.fromValue(this.dcFilter);
    }

    public String dcFilterString() {
        return this.dcFilter;
    }

    public Integer dialnorm() {
        return this.dialnorm;
    }

    public Eac3DynamicRangeCompressionLine dynamicRangeCompressionLine() {
        return Eac3DynamicRangeCompressionLine.fromValue(this.dynamicRangeCompressionLine);
    }

    public String dynamicRangeCompressionLineString() {
        return this.dynamicRangeCompressionLine;
    }

    public Eac3DynamicRangeCompressionRf dynamicRangeCompressionRf() {
        return Eac3DynamicRangeCompressionRf.fromValue(this.dynamicRangeCompressionRf);
    }

    public String dynamicRangeCompressionRfString() {
        return this.dynamicRangeCompressionRf;
    }

    public Eac3LfeControl lfeControl() {
        return Eac3LfeControl.fromValue(this.lfeControl);
    }

    public String lfeControlString() {
        return this.lfeControl;
    }

    public Eac3LfeFilter lfeFilter() {
        return Eac3LfeFilter.fromValue(this.lfeFilter);
    }

    public String lfeFilterString() {
        return this.lfeFilter;
    }

    public Double loRoCenterMixLevel() {
        return this.loRoCenterMixLevel;
    }

    public Double loRoSurroundMixLevel() {
        return this.loRoSurroundMixLevel;
    }

    public Double ltRtCenterMixLevel() {
        return this.ltRtCenterMixLevel;
    }

    public Double ltRtSurroundMixLevel() {
        return this.ltRtSurroundMixLevel;
    }

    public Eac3MetadataControl metadataControl() {
        return Eac3MetadataControl.fromValue(this.metadataControl);
    }

    public String metadataControlString() {
        return this.metadataControl;
    }

    public Eac3PassthroughControl passthroughControl() {
        return Eac3PassthroughControl.fromValue(this.passthroughControl);
    }

    public String passthroughControlString() {
        return this.passthroughControl;
    }

    public Eac3PhaseControl phaseControl() {
        return Eac3PhaseControl.fromValue(this.phaseControl);
    }

    public String phaseControlString() {
        return this.phaseControl;
    }

    public Integer sampleRate() {
        return this.sampleRate;
    }

    public Eac3StereoDownmix stereoDownmix() {
        return Eac3StereoDownmix.fromValue(this.stereoDownmix);
    }

    public String stereoDownmixString() {
        return this.stereoDownmix;
    }

    public Eac3SurroundExMode surroundExMode() {
        return Eac3SurroundExMode.fromValue(this.surroundExMode);
    }

    public String surroundExModeString() {
        return this.surroundExMode;
    }

    public Eac3SurroundMode surroundMode() {
        return Eac3SurroundMode.fromValue(this.surroundMode);
    }

    public String surroundModeString() {
        return this.surroundMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attenuationControlString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.bitstreamModeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.codingModeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dcFilterString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dialnorm());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamicRangeCompressionLineString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamicRangeCompressionRfString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lfeControlString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lfeFilterString());
        hashCode = 31 * hashCode + Objects.hashCode(this.loRoCenterMixLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.loRoSurroundMixLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.ltRtCenterMixLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.ltRtSurroundMixLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataControlString());
        hashCode = 31 * hashCode + Objects.hashCode(this.passthroughControlString());
        hashCode = 31 * hashCode + Objects.hashCode(this.phaseControlString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.stereoDownmixString());
        hashCode = 31 * hashCode + Objects.hashCode(this.surroundExModeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.surroundModeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Eac3Settings)) {
            return false;
        }
        Eac3Settings other = (Eac3Settings)obj;
        return Objects.equals(this.attenuationControlString(), other.attenuationControlString()) && Objects.equals(this.bitrate(), other.bitrate()) && Objects.equals(this.bitstreamModeString(), other.bitstreamModeString()) && Objects.equals(this.codingModeString(), other.codingModeString()) && Objects.equals(this.dcFilterString(), other.dcFilterString()) && Objects.equals(this.dialnorm(), other.dialnorm()) && Objects.equals(this.dynamicRangeCompressionLineString(), other.dynamicRangeCompressionLineString()) && Objects.equals(this.dynamicRangeCompressionRfString(), other.dynamicRangeCompressionRfString()) && Objects.equals(this.lfeControlString(), other.lfeControlString()) && Objects.equals(this.lfeFilterString(), other.lfeFilterString()) && Objects.equals(this.loRoCenterMixLevel(), other.loRoCenterMixLevel()) && Objects.equals(this.loRoSurroundMixLevel(), other.loRoSurroundMixLevel()) && Objects.equals(this.ltRtCenterMixLevel(), other.ltRtCenterMixLevel()) && Objects.equals(this.ltRtSurroundMixLevel(), other.ltRtSurroundMixLevel()) && Objects.equals(this.metadataControlString(), other.metadataControlString()) && Objects.equals(this.passthroughControlString(), other.passthroughControlString()) && Objects.equals(this.phaseControlString(), other.phaseControlString()) && Objects.equals(this.sampleRate(), other.sampleRate()) && Objects.equals(this.stereoDownmixString(), other.stereoDownmixString()) && Objects.equals(this.surroundExModeString(), other.surroundExModeString()) && Objects.equals(this.surroundModeString(), other.surroundModeString());
    }

    public String toString() {
        return ToString.builder((String)"Eac3Settings").add("AttenuationControl", (Object)this.attenuationControlString()).add("Bitrate", (Object)this.bitrate()).add("BitstreamMode", (Object)this.bitstreamModeString()).add("CodingMode", (Object)this.codingModeString()).add("DcFilter", (Object)this.dcFilterString()).add("Dialnorm", (Object)this.dialnorm()).add("DynamicRangeCompressionLine", (Object)this.dynamicRangeCompressionLineString()).add("DynamicRangeCompressionRf", (Object)this.dynamicRangeCompressionRfString()).add("LfeControl", (Object)this.lfeControlString()).add("LfeFilter", (Object)this.lfeFilterString()).add("LoRoCenterMixLevel", (Object)this.loRoCenterMixLevel()).add("LoRoSurroundMixLevel", (Object)this.loRoSurroundMixLevel()).add("LtRtCenterMixLevel", (Object)this.ltRtCenterMixLevel()).add("LtRtSurroundMixLevel", (Object)this.ltRtSurroundMixLevel()).add("MetadataControl", (Object)this.metadataControlString()).add("PassthroughControl", (Object)this.passthroughControlString()).add("PhaseControl", (Object)this.phaseControlString()).add("SampleRate", (Object)this.sampleRate()).add("StereoDownmix", (Object)this.stereoDownmixString()).add("SurroundExMode", (Object)this.surroundExModeString()).add("SurroundMode", (Object)this.surroundModeString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttenuationControl": {
                return Optional.of(clazz.cast(this.attenuationControlString()));
            }
            case "Bitrate": {
                return Optional.of(clazz.cast(this.bitrate()));
            }
            case "BitstreamMode": {
                return Optional.of(clazz.cast(this.bitstreamModeString()));
            }
            case "CodingMode": {
                return Optional.of(clazz.cast(this.codingModeString()));
            }
            case "DcFilter": {
                return Optional.of(clazz.cast(this.dcFilterString()));
            }
            case "Dialnorm": {
                return Optional.of(clazz.cast(this.dialnorm()));
            }
            case "DynamicRangeCompressionLine": {
                return Optional.of(clazz.cast(this.dynamicRangeCompressionLineString()));
            }
            case "DynamicRangeCompressionRf": {
                return Optional.of(clazz.cast(this.dynamicRangeCompressionRfString()));
            }
            case "LfeControl": {
                return Optional.of(clazz.cast(this.lfeControlString()));
            }
            case "LfeFilter": {
                return Optional.of(clazz.cast(this.lfeFilterString()));
            }
            case "LoRoCenterMixLevel": {
                return Optional.of(clazz.cast(this.loRoCenterMixLevel()));
            }
            case "LoRoSurroundMixLevel": {
                return Optional.of(clazz.cast(this.loRoSurroundMixLevel()));
            }
            case "LtRtCenterMixLevel": {
                return Optional.of(clazz.cast(this.ltRtCenterMixLevel()));
            }
            case "LtRtSurroundMixLevel": {
                return Optional.of(clazz.cast(this.ltRtSurroundMixLevel()));
            }
            case "MetadataControl": {
                return Optional.of(clazz.cast(this.metadataControlString()));
            }
            case "PassthroughControl": {
                return Optional.of(clazz.cast(this.passthroughControlString()));
            }
            case "PhaseControl": {
                return Optional.of(clazz.cast(this.phaseControlString()));
            }
            case "SampleRate": {
                return Optional.of(clazz.cast(this.sampleRate()));
            }
            case "StereoDownmix": {
                return Optional.of(clazz.cast(this.stereoDownmixString()));
            }
            case "SurroundExMode": {
                return Optional.of(clazz.cast(this.surroundExModeString()));
            }
            case "SurroundMode": {
                return Optional.of(clazz.cast(this.surroundModeString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        Eac3SettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String attenuationControl;
        private Integer bitrate;
        private String bitstreamMode;
        private String codingMode;
        private String dcFilter;
        private Integer dialnorm;
        private String dynamicRangeCompressionLine;
        private String dynamicRangeCompressionRf;
        private String lfeControl;
        private String lfeFilter;
        private Double loRoCenterMixLevel;
        private Double loRoSurroundMixLevel;
        private Double ltRtCenterMixLevel;
        private Double ltRtSurroundMixLevel;
        private String metadataControl;
        private String passthroughControl;
        private String phaseControl;
        private Integer sampleRate;
        private String stereoDownmix;
        private String surroundExMode;
        private String surroundMode;

        private BuilderImpl() {
        }

        private BuilderImpl(Eac3Settings model) {
            this.attenuationControl(model.attenuationControl);
            this.bitrate(model.bitrate);
            this.bitstreamMode(model.bitstreamMode);
            this.codingMode(model.codingMode);
            this.dcFilter(model.dcFilter);
            this.dialnorm(model.dialnorm);
            this.dynamicRangeCompressionLine(model.dynamicRangeCompressionLine);
            this.dynamicRangeCompressionRf(model.dynamicRangeCompressionRf);
            this.lfeControl(model.lfeControl);
            this.lfeFilter(model.lfeFilter);
            this.loRoCenterMixLevel(model.loRoCenterMixLevel);
            this.loRoSurroundMixLevel(model.loRoSurroundMixLevel);
            this.ltRtCenterMixLevel(model.ltRtCenterMixLevel);
            this.ltRtSurroundMixLevel(model.ltRtSurroundMixLevel);
            this.metadataControl(model.metadataControl);
            this.passthroughControl(model.passthroughControl);
            this.phaseControl(model.phaseControl);
            this.sampleRate(model.sampleRate);
            this.stereoDownmix(model.stereoDownmix);
            this.surroundExMode(model.surroundExMode);
            this.surroundMode(model.surroundMode);
        }

        public final String getAttenuationControl() {
            return this.attenuationControl;
        }

        @Override
        public final Builder attenuationControl(String attenuationControl) {
            this.attenuationControl = attenuationControl;
            return this;
        }

        @Override
        public final Builder attenuationControl(Eac3AttenuationControl attenuationControl) {
            this.attenuationControl(attenuationControl.toString());
            return this;
        }

        public final void setAttenuationControl(String attenuationControl) {
            this.attenuationControl = attenuationControl;
        }

        public final Integer getBitrate() {
            return this.bitrate;
        }

        @Override
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        public final String getBitstreamMode() {
            return this.bitstreamMode;
        }

        @Override
        public final Builder bitstreamMode(String bitstreamMode) {
            this.bitstreamMode = bitstreamMode;
            return this;
        }

        @Override
        public final Builder bitstreamMode(Eac3BitstreamMode bitstreamMode) {
            this.bitstreamMode(bitstreamMode.toString());
            return this;
        }

        public final void setBitstreamMode(String bitstreamMode) {
            this.bitstreamMode = bitstreamMode;
        }

        public final String getCodingMode() {
            return this.codingMode;
        }

        @Override
        public final Builder codingMode(String codingMode) {
            this.codingMode = codingMode;
            return this;
        }

        @Override
        public final Builder codingMode(Eac3CodingMode codingMode) {
            this.codingMode(codingMode.toString());
            return this;
        }

        public final void setCodingMode(String codingMode) {
            this.codingMode = codingMode;
        }

        public final String getDcFilter() {
            return this.dcFilter;
        }

        @Override
        public final Builder dcFilter(String dcFilter) {
            this.dcFilter = dcFilter;
            return this;
        }

        @Override
        public final Builder dcFilter(Eac3DcFilter dcFilter) {
            this.dcFilter(dcFilter.toString());
            return this;
        }

        public final void setDcFilter(String dcFilter) {
            this.dcFilter = dcFilter;
        }

        public final Integer getDialnorm() {
            return this.dialnorm;
        }

        @Override
        public final Builder dialnorm(Integer dialnorm) {
            this.dialnorm = dialnorm;
            return this;
        }

        public final void setDialnorm(Integer dialnorm) {
            this.dialnorm = dialnorm;
        }

        public final String getDynamicRangeCompressionLine() {
            return this.dynamicRangeCompressionLine;
        }

        @Override
        public final Builder dynamicRangeCompressionLine(String dynamicRangeCompressionLine) {
            this.dynamicRangeCompressionLine = dynamicRangeCompressionLine;
            return this;
        }

        @Override
        public final Builder dynamicRangeCompressionLine(Eac3DynamicRangeCompressionLine dynamicRangeCompressionLine) {
            this.dynamicRangeCompressionLine(dynamicRangeCompressionLine.toString());
            return this;
        }

        public final void setDynamicRangeCompressionLine(String dynamicRangeCompressionLine) {
            this.dynamicRangeCompressionLine = dynamicRangeCompressionLine;
        }

        public final String getDynamicRangeCompressionRf() {
            return this.dynamicRangeCompressionRf;
        }

        @Override
        public final Builder dynamicRangeCompressionRf(String dynamicRangeCompressionRf) {
            this.dynamicRangeCompressionRf = dynamicRangeCompressionRf;
            return this;
        }

        @Override
        public final Builder dynamicRangeCompressionRf(Eac3DynamicRangeCompressionRf dynamicRangeCompressionRf) {
            this.dynamicRangeCompressionRf(dynamicRangeCompressionRf.toString());
            return this;
        }

        public final void setDynamicRangeCompressionRf(String dynamicRangeCompressionRf) {
            this.dynamicRangeCompressionRf = dynamicRangeCompressionRf;
        }

        public final String getLfeControl() {
            return this.lfeControl;
        }

        @Override
        public final Builder lfeControl(String lfeControl) {
            this.lfeControl = lfeControl;
            return this;
        }

        @Override
        public final Builder lfeControl(Eac3LfeControl lfeControl) {
            this.lfeControl(lfeControl.toString());
            return this;
        }

        public final void setLfeControl(String lfeControl) {
            this.lfeControl = lfeControl;
        }

        public final String getLfeFilter() {
            return this.lfeFilter;
        }

        @Override
        public final Builder lfeFilter(String lfeFilter) {
            this.lfeFilter = lfeFilter;
            return this;
        }

        @Override
        public final Builder lfeFilter(Eac3LfeFilter lfeFilter) {
            this.lfeFilter(lfeFilter.toString());
            return this;
        }

        public final void setLfeFilter(String lfeFilter) {
            this.lfeFilter = lfeFilter;
        }

        public final Double getLoRoCenterMixLevel() {
            return this.loRoCenterMixLevel;
        }

        @Override
        public final Builder loRoCenterMixLevel(Double loRoCenterMixLevel) {
            this.loRoCenterMixLevel = loRoCenterMixLevel;
            return this;
        }

        public final void setLoRoCenterMixLevel(Double loRoCenterMixLevel) {
            this.loRoCenterMixLevel = loRoCenterMixLevel;
        }

        public final Double getLoRoSurroundMixLevel() {
            return this.loRoSurroundMixLevel;
        }

        @Override
        public final Builder loRoSurroundMixLevel(Double loRoSurroundMixLevel) {
            this.loRoSurroundMixLevel = loRoSurroundMixLevel;
            return this;
        }

        public final void setLoRoSurroundMixLevel(Double loRoSurroundMixLevel) {
            this.loRoSurroundMixLevel = loRoSurroundMixLevel;
        }

        public final Double getLtRtCenterMixLevel() {
            return this.ltRtCenterMixLevel;
        }

        @Override
        public final Builder ltRtCenterMixLevel(Double ltRtCenterMixLevel) {
            this.ltRtCenterMixLevel = ltRtCenterMixLevel;
            return this;
        }

        public final void setLtRtCenterMixLevel(Double ltRtCenterMixLevel) {
            this.ltRtCenterMixLevel = ltRtCenterMixLevel;
        }

        public final Double getLtRtSurroundMixLevel() {
            return this.ltRtSurroundMixLevel;
        }

        @Override
        public final Builder ltRtSurroundMixLevel(Double ltRtSurroundMixLevel) {
            this.ltRtSurroundMixLevel = ltRtSurroundMixLevel;
            return this;
        }

        public final void setLtRtSurroundMixLevel(Double ltRtSurroundMixLevel) {
            this.ltRtSurroundMixLevel = ltRtSurroundMixLevel;
        }

        public final String getMetadataControl() {
            return this.metadataControl;
        }

        @Override
        public final Builder metadataControl(String metadataControl) {
            this.metadataControl = metadataControl;
            return this;
        }

        @Override
        public final Builder metadataControl(Eac3MetadataControl metadataControl) {
            this.metadataControl(metadataControl.toString());
            return this;
        }

        public final void setMetadataControl(String metadataControl) {
            this.metadataControl = metadataControl;
        }

        public final String getPassthroughControl() {
            return this.passthroughControl;
        }

        @Override
        public final Builder passthroughControl(String passthroughControl) {
            this.passthroughControl = passthroughControl;
            return this;
        }

        @Override
        public final Builder passthroughControl(Eac3PassthroughControl passthroughControl) {
            this.passthroughControl(passthroughControl.toString());
            return this;
        }

        public final void setPassthroughControl(String passthroughControl) {
            this.passthroughControl = passthroughControl;
        }

        public final String getPhaseControl() {
            return this.phaseControl;
        }

        @Override
        public final Builder phaseControl(String phaseControl) {
            this.phaseControl = phaseControl;
            return this;
        }

        @Override
        public final Builder phaseControl(Eac3PhaseControl phaseControl) {
            this.phaseControl(phaseControl.toString());
            return this;
        }

        public final void setPhaseControl(String phaseControl) {
            this.phaseControl = phaseControl;
        }

        public final Integer getSampleRate() {
            return this.sampleRate;
        }

        @Override
        public final Builder sampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final void setSampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
        }

        public final String getStereoDownmix() {
            return this.stereoDownmix;
        }

        @Override
        public final Builder stereoDownmix(String stereoDownmix) {
            this.stereoDownmix = stereoDownmix;
            return this;
        }

        @Override
        public final Builder stereoDownmix(Eac3StereoDownmix stereoDownmix) {
            this.stereoDownmix(stereoDownmix.toString());
            return this;
        }

        public final void setStereoDownmix(String stereoDownmix) {
            this.stereoDownmix = stereoDownmix;
        }

        public final String getSurroundExMode() {
            return this.surroundExMode;
        }

        @Override
        public final Builder surroundExMode(String surroundExMode) {
            this.surroundExMode = surroundExMode;
            return this;
        }

        @Override
        public final Builder surroundExMode(Eac3SurroundExMode surroundExMode) {
            this.surroundExMode(surroundExMode.toString());
            return this;
        }

        public final void setSurroundExMode(String surroundExMode) {
            this.surroundExMode = surroundExMode;
        }

        public final String getSurroundMode() {
            return this.surroundMode;
        }

        @Override
        public final Builder surroundMode(String surroundMode) {
            this.surroundMode = surroundMode;
            return this;
        }

        @Override
        public final Builder surroundMode(Eac3SurroundMode surroundMode) {
            this.surroundMode(surroundMode.toString());
            return this;
        }

        public final void setSurroundMode(String surroundMode) {
            this.surroundMode = surroundMode;
        }

        public Eac3Settings build() {
            return new Eac3Settings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Eac3Settings> {
        public Builder attenuationControl(String var1);

        public Builder attenuationControl(Eac3AttenuationControl var1);

        public Builder bitrate(Integer var1);

        public Builder bitstreamMode(String var1);

        public Builder bitstreamMode(Eac3BitstreamMode var1);

        public Builder codingMode(String var1);

        public Builder codingMode(Eac3CodingMode var1);

        public Builder dcFilter(String var1);

        public Builder dcFilter(Eac3DcFilter var1);

        public Builder dialnorm(Integer var1);

        public Builder dynamicRangeCompressionLine(String var1);

        public Builder dynamicRangeCompressionLine(Eac3DynamicRangeCompressionLine var1);

        public Builder dynamicRangeCompressionRf(String var1);

        public Builder dynamicRangeCompressionRf(Eac3DynamicRangeCompressionRf var1);

        public Builder lfeControl(String var1);

        public Builder lfeControl(Eac3LfeControl var1);

        public Builder lfeFilter(String var1);

        public Builder lfeFilter(Eac3LfeFilter var1);

        public Builder loRoCenterMixLevel(Double var1);

        public Builder loRoSurroundMixLevel(Double var1);

        public Builder ltRtCenterMixLevel(Double var1);

        public Builder ltRtSurroundMixLevel(Double var1);

        public Builder metadataControl(String var1);

        public Builder metadataControl(Eac3MetadataControl var1);

        public Builder passthroughControl(String var1);

        public Builder passthroughControl(Eac3PassthroughControl var1);

        public Builder phaseControl(String var1);

        public Builder phaseControl(Eac3PhaseControl var1);

        public Builder sampleRate(Integer var1);

        public Builder stereoDownmix(String var1);

        public Builder stereoDownmix(Eac3StereoDownmix var1);

        public Builder surroundExMode(String var1);

        public Builder surroundExMode(Eac3SurroundExMode var1);

        public Builder surroundMode(String var1);

        public Builder surroundMode(Eac3SurroundMode var1);
    }
}

