/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.mediaconvert.model.JobSettings;
import software.amazon.awssdk.services.mediaconvert.model.MapOf__stringCopier;
import software.amazon.awssdk.services.mediaconvert.model.MediaConvertRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateJobRequest
extends MediaConvertRequest
implements ToCopyableBuilder<Builder, CreateJobRequest> {
    private final String clientRequestToken;
    private final String jobTemplate;
    private final String queue;
    private final String role;
    private final JobSettings settings;
    private final Map<String, String> userMetadata;

    private CreateJobRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.jobTemplate = builder.jobTemplate;
        this.queue = builder.queue;
        this.role = builder.role;
        this.settings = builder.settings;
        this.userMetadata = builder.userMetadata;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public String jobTemplate() {
        return this.jobTemplate;
    }

    public String queue() {
        return this.queue;
    }

    public String role() {
        return this.role;
    }

    public JobSettings settings() {
        return this.settings;
    }

    public Map<String, String> userMetadata() {
        return this.userMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.queue());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.userMetadata());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobRequest)) {
            return false;
        }
        CreateJobRequest other = (CreateJobRequest)((Object)obj);
        return Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.jobTemplate(), other.jobTemplate()) && Objects.equals(this.queue(), other.queue()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.settings(), other.settings()) && Objects.equals(this.userMetadata(), other.userMetadata());
    }

    public String toString() {
        return ToString.builder((String)"CreateJobRequest").add("ClientRequestToken", (Object)this.clientRequestToken()).add("JobTemplate", (Object)this.jobTemplate()).add("Queue", (Object)this.queue()).add("Role", (Object)this.role()).add("Settings", (Object)this.settings()).add("UserMetadata", this.userMetadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientRequestToken": {
                return Optional.of(clazz.cast(this.clientRequestToken()));
            }
            case "JobTemplate": {
                return Optional.of(clazz.cast(this.jobTemplate()));
            }
            case "Queue": {
                return Optional.of(clazz.cast(this.queue()));
            }
            case "Role": {
                return Optional.of(clazz.cast(this.role()));
            }
            case "Settings": {
                return Optional.of(clazz.cast(this.settings()));
            }
            case "UserMetadata": {
                return Optional.of(clazz.cast(this.userMetadata()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MediaConvertRequest.BuilderImpl
    implements Builder {
        private String clientRequestToken;
        private String jobTemplate;
        private String queue;
        private String role;
        private JobSettings settings;
        private Map<String, String> userMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobRequest model) {
            this.clientRequestToken(model.clientRequestToken);
            this.jobTemplate(model.jobTemplate);
            this.queue(model.queue);
            this.role(model.role);
            this.settings(model.settings);
            this.userMetadata(model.userMetadata);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final String getJobTemplate() {
            return this.jobTemplate;
        }

        @Override
        public final Builder jobTemplate(String jobTemplate) {
            this.jobTemplate = jobTemplate;
            return this;
        }

        public final void setJobTemplate(String jobTemplate) {
            this.jobTemplate = jobTemplate;
        }

        public final String getQueue() {
            return this.queue;
        }

        @Override
        public final Builder queue(String queue) {
            this.queue = queue;
            return this;
        }

        public final void setQueue(String queue) {
            this.queue = queue;
        }

        public final String getRole() {
            return this.role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final JobSettings.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        @Override
        public final Builder settings(JobSettings settings) {
            this.settings = settings;
            return this;
        }

        public final void setSettings(JobSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        public final Map<String, String> getUserMetadata() {
            return this.userMetadata;
        }

        @Override
        public final Builder userMetadata(Map<String, String> userMetadata) {
            this.userMetadata = MapOf__stringCopier.copy(userMetadata);
            return this;
        }

        public final void setUserMetadata(Map<String, String> userMetadata) {
            this.userMetadata = MapOf__stringCopier.copy(userMetadata);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateJobRequest build() {
            return new CreateJobRequest(this);
        }
    }

    public static interface Builder
    extends MediaConvertRequest.Builder,
    CopyableBuilder<Builder, CreateJobRequest> {
        public Builder clientRequestToken(String var1);

        public Builder jobTemplate(String var1);

        public Builder queue(String var1);

        public Builder role(String var1);

        public Builder settings(JobSettings var1);

        default public Builder settings(Consumer<JobSettings.Builder> settings) {
            return this.settings((JobSettings)((JobSettings.Builder)JobSettings.builder().apply(settings)).build());
        }

        public Builder userMetadata(Map<String, String> var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

