/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.VideoSelector;

@SdkInternalApi
public class VideoSelectorMarshaller {
    private static final MarshallingInfo<String> COLORSPACE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("colorSpace").build();
    private static final MarshallingInfo<String> COLORSPACEUSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("colorSpaceUsage").build();
    private static final MarshallingInfo<StructuredPojo> HDR10METADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hdr10Metadata").build();
    private static final MarshallingInfo<Integer> PID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pid").build();
    private static final MarshallingInfo<Integer> PROGRAMNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("programNumber").build();
    private static final VideoSelectorMarshaller INSTANCE = new VideoSelectorMarshaller();

    public static VideoSelectorMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(VideoSelector videoSelector, ProtocolMarshaller protocolMarshaller) {
        if (videoSelector == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)videoSelector.colorSpaceString(), COLORSPACE_BINDING);
            protocolMarshaller.marshall((Object)videoSelector.colorSpaceUsageString(), COLORSPACEUSAGE_BINDING);
            protocolMarshaller.marshall((Object)videoSelector.hdr10Metadata(), HDR10METADATA_BINDING);
            protocolMarshaller.marshall((Object)videoSelector.pid(), PID_BINDING);
            protocolMarshaller.marshall((Object)videoSelector.programNumber(), PROGRAMNUMBER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

