/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.VideoCodecSettings;

@SdkInternalApi
public class VideoCodecSettingsMarshaller {
    private static final MarshallingInfo<String> CODEC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codec").build();
    private static final MarshallingInfo<StructuredPojo> FRAMECAPTURESETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("frameCaptureSettings").build();
    private static final MarshallingInfo<StructuredPojo> H264SETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("h264Settings").build();
    private static final MarshallingInfo<StructuredPojo> H265SETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("h265Settings").build();
    private static final MarshallingInfo<StructuredPojo> MPEG2SETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mpeg2Settings").build();
    private static final MarshallingInfo<StructuredPojo> PRORESSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("proresSettings").build();
    private static final VideoCodecSettingsMarshaller INSTANCE = new VideoCodecSettingsMarshaller();

    public static VideoCodecSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(VideoCodecSettings videoCodecSettings, ProtocolMarshaller protocolMarshaller) {
        if (videoCodecSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)videoCodecSettings.codecString(), CODEC_BINDING);
            protocolMarshaller.marshall((Object)videoCodecSettings.frameCaptureSettings(), FRAMECAPTURESETTINGS_BINDING);
            protocolMarshaller.marshall((Object)videoCodecSettings.h264Settings(), H264SETTINGS_BINDING);
            protocolMarshaller.marshall((Object)videoCodecSettings.h265Settings(), H265SETTINGS_BINDING);
            protocolMarshaller.marshall((Object)videoCodecSettings.mpeg2Settings(), MPEG2SETTINGS_BINDING);
            protocolMarshaller.marshall((Object)videoCodecSettings.proresSettings(), PRORESSETTINGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

