/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.StaticKeyProvider;

@SdkInternalApi
public class StaticKeyProviderMarshaller {
    private static final MarshallingInfo<String> KEYFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("keyFormat").build();
    private static final MarshallingInfo<String> KEYFORMATVERSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("keyFormatVersions").build();
    private static final MarshallingInfo<String> STATICKEYVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("staticKeyValue").build();
    private static final MarshallingInfo<String> URL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("url").build();
    private static final StaticKeyProviderMarshaller INSTANCE = new StaticKeyProviderMarshaller();

    public static StaticKeyProviderMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StaticKeyProvider staticKeyProvider, ProtocolMarshaller protocolMarshaller) {
        if (staticKeyProvider == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)staticKeyProvider.keyFormat(), KEYFORMAT_BINDING);
            protocolMarshaller.marshall((Object)staticKeyProvider.keyFormatVersions(), KEYFORMATVERSIONS_BINDING);
            protocolMarshaller.marshall((Object)staticKeyProvider.staticKeyValue(), STATICKEYVALUE_BINDING);
            protocolMarshaller.marshall((Object)staticKeyProvider.url(), URL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

