/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mediaconvert.model.Job;
import software.amazon.awssdk.services.mediaconvert.transform.JobSettingsUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.OutputGroupDetailUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.TimingUnmarshaller;

public class JobUnmarshaller
implements Unmarshaller<Job, JsonUnmarshallerContext> {
    private static final JobUnmarshaller INSTANCE = new JobUnmarshaller();

    public Job unmarshall(JsonUnmarshallerContext context) throws Exception {
        Job.Builder jobBuilder = Job.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    jobBuilder.arn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("createdAt", targetDepth)) {
                    context.nextToken();
                    jobBuilder.createdAt((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("errorCode", targetDepth)) {
                    context.nextToken();
                    jobBuilder.errorCode((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("errorMessage", targetDepth)) {
                    context.nextToken();
                    jobBuilder.errorMessage((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("id", targetDepth)) {
                    context.nextToken();
                    jobBuilder.id((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("jobTemplate", targetDepth)) {
                    context.nextToken();
                    jobBuilder.jobTemplate((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("outputGroupDetails", targetDepth)) {
                    context.nextToken();
                    jobBuilder.outputGroupDetails(new ListUnmarshaller((Unmarshaller)OutputGroupDetailUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("queue", targetDepth)) {
                    context.nextToken();
                    jobBuilder.queue((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("role", targetDepth)) {
                    context.nextToken();
                    jobBuilder.role((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("settings", targetDepth)) {
                    context.nextToken();
                    jobBuilder.settings(JobSettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("status", targetDepth)) {
                    context.nextToken();
                    jobBuilder.status((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("timing", targetDepth)) {
                    context.nextToken();
                    jobBuilder.timing(TimingUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("userMetadata", targetDepth)) {
                    context.nextToken();
                    jobBuilder.userMetadata(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Job)jobBuilder.build();
    }

    public static JobUnmarshaller getInstance() {
        return INSTANCE;
    }
}

