/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.JobSettings;

@SdkInternalApi
public class JobSettingsMarshaller {
    private static final MarshallingInfo<Integer> ADAVAILOFFSET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("adAvailOffset").build();
    private static final MarshallingInfo<StructuredPojo> AVAILBLANKING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("availBlanking").build();
    private static final MarshallingInfo<List> INPUTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputs").build();
    private static final MarshallingInfo<StructuredPojo> NIELSENCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nielsenConfiguration").build();
    private static final MarshallingInfo<List> OUTPUTGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("outputGroups").build();
    private static final MarshallingInfo<StructuredPojo> TIMECODECONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timecodeConfig").build();
    private static final MarshallingInfo<StructuredPojo> TIMEDMETADATAINSERTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timedMetadataInsertion").build();
    private static final JobSettingsMarshaller INSTANCE = new JobSettingsMarshaller();

    public static JobSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(JobSettings jobSettings, ProtocolMarshaller protocolMarshaller) {
        if (jobSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)jobSettings.adAvailOffset(), ADAVAILOFFSET_BINDING);
            protocolMarshaller.marshall((Object)jobSettings.availBlanking(), AVAILBLANKING_BINDING);
            protocolMarshaller.marshall(jobSettings.inputs(), INPUTS_BINDING);
            protocolMarshaller.marshall((Object)jobSettings.nielsenConfiguration(), NIELSENCONFIGURATION_BINDING);
            protocolMarshaller.marshall(jobSettings.outputGroups(), OUTPUTGROUPS_BINDING);
            protocolMarshaller.marshall((Object)jobSettings.timecodeConfig(), TIMECODECONFIG_BINDING);
            protocolMarshaller.marshall((Object)jobSettings.timedMetadataInsertion(), TIMEDMETADATAINSERTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

