/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.InputClipping;

@SdkInternalApi
public class InputClippingMarshaller {
    private static final MarshallingInfo<String> ENDTIMECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endTimecode").build();
    private static final MarshallingInfo<String> STARTTIMECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTimecode").build();
    private static final InputClippingMarshaller INSTANCE = new InputClippingMarshaller();

    public static InputClippingMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InputClipping inputClipping, ProtocolMarshaller protocolMarshaller) {
        if (inputClipping == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)inputClipping.endTimecode(), ENDTIMECODE_BINDING);
            protocolMarshaller.marshall((Object)inputClipping.startTimecode(), STARTTIMECODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

