/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.Id3Insertion;

@SdkInternalApi
public class Id3InsertionMarshaller {
    private static final MarshallingInfo<String> ID3_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id3").build();
    private static final MarshallingInfo<String> TIMECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timecode").build();
    private static final Id3InsertionMarshaller INSTANCE = new Id3InsertionMarshaller();

    public static Id3InsertionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Id3Insertion id3Insertion, ProtocolMarshaller protocolMarshaller) {
        if (id3Insertion == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)id3Insertion.id3(), ID3_BINDING);
            protocolMarshaller.marshall((Object)id3Insertion.timecode(), TIMECODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

