/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.HlsGroupSettings;

@SdkInternalApi
public class HlsGroupSettingsMarshaller {
    private static final MarshallingInfo<List> ADMARKERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("adMarkers").build();
    private static final MarshallingInfo<String> BASEURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("baseUrl").build();
    private static final MarshallingInfo<List> CAPTIONLANGUAGEMAPPINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("captionLanguageMappings").build();
    private static final MarshallingInfo<String> CAPTIONLANGUAGESETTING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("captionLanguageSetting").build();
    private static final MarshallingInfo<String> CLIENTCACHE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clientCache").build();
    private static final MarshallingInfo<String> CODECSPECIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codecSpecification").build();
    private static final MarshallingInfo<String> DESTINATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destination").build();
    private static final MarshallingInfo<String> DIRECTORYSTRUCTURE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("directoryStructure").build();
    private static final MarshallingInfo<StructuredPojo> ENCRYPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("encryption").build();
    private static final MarshallingInfo<String> MANIFESTCOMPRESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("manifestCompression").build();
    private static final MarshallingInfo<String> MANIFESTDURATIONFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("manifestDurationFormat").build();
    private static final MarshallingInfo<Integer> MINSEGMENTLENGTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minSegmentLength").build();
    private static final MarshallingInfo<String> OUTPUTSELECTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("outputSelection").build();
    private static final MarshallingInfo<String> PROGRAMDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("programDateTime").build();
    private static final MarshallingInfo<Integer> PROGRAMDATETIMEPERIOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("programDateTimePeriod").build();
    private static final MarshallingInfo<String> SEGMENTCONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("segmentControl").build();
    private static final MarshallingInfo<Integer> SEGMENTLENGTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("segmentLength").build();
    private static final MarshallingInfo<Integer> SEGMENTSPERSUBDIRECTORY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("segmentsPerSubdirectory").build();
    private static final MarshallingInfo<String> STREAMINFRESOLUTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("streamInfResolution").build();
    private static final MarshallingInfo<String> TIMEDMETADATAID3FRAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timedMetadataId3Frame").build();
    private static final MarshallingInfo<Integer> TIMEDMETADATAID3PERIOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timedMetadataId3Period").build();
    private static final MarshallingInfo<Integer> TIMESTAMPDELTAMILLISECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timestampDeltaMilliseconds").build();
    private static final HlsGroupSettingsMarshaller INSTANCE = new HlsGroupSettingsMarshaller();

    public static HlsGroupSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(HlsGroupSettings hlsGroupSettings, ProtocolMarshaller protocolMarshaller) {
        if (hlsGroupSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(hlsGroupSettings.adMarkersStrings(), ADMARKERS_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.baseUrl(), BASEURL_BINDING);
            protocolMarshaller.marshall(hlsGroupSettings.captionLanguageMappings(), CAPTIONLANGUAGEMAPPINGS_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.captionLanguageSettingString(), CAPTIONLANGUAGESETTING_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.clientCacheString(), CLIENTCACHE_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.codecSpecificationString(), CODECSPECIFICATION_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.destination(), DESTINATION_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.directoryStructureString(), DIRECTORYSTRUCTURE_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.encryption(), ENCRYPTION_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.manifestCompressionString(), MANIFESTCOMPRESSION_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.manifestDurationFormatString(), MANIFESTDURATIONFORMAT_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.minSegmentLength(), MINSEGMENTLENGTH_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.outputSelectionString(), OUTPUTSELECTION_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.programDateTimeString(), PROGRAMDATETIME_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.programDateTimePeriod(), PROGRAMDATETIMEPERIOD_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.segmentControlString(), SEGMENTCONTROL_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.segmentLength(), SEGMENTLENGTH_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.segmentsPerSubdirectory(), SEGMENTSPERSUBDIRECTORY_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.streamInfResolutionString(), STREAMINFRESOLUTION_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.timedMetadataId3FrameString(), TIMEDMETADATAID3FRAME_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.timedMetadataId3Period(), TIMEDMETADATAID3PERIOD_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.timestampDeltaMilliseconds(), TIMESTAMPDELTAMILLISECONDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

