/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.IdempotentUtils;
import software.amazon.awssdk.services.mediaconvert.model.CreateJobRequest;

@SdkInternalApi
public class CreateJobRequestModelMarshaller {
    private static final MarshallingInfo<String> CLIENTREQUESTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clientRequestToken").defaultValueSupplier(IdempotentUtils.getGenerator()).build();
    private static final MarshallingInfo<String> JOBTEMPLATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobTemplate").build();
    private static final MarshallingInfo<String> QUEUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("queue").build();
    private static final MarshallingInfo<String> ROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("role").build();
    private static final MarshallingInfo<StructuredPojo> SETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("settings").build();
    private static final MarshallingInfo<Map> USERMETADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("userMetadata").build();
    private static final CreateJobRequestModelMarshaller INSTANCE = new CreateJobRequestModelMarshaller();

    public static CreateJobRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateJobRequest createJobRequest, ProtocolMarshaller protocolMarshaller) {
        if (createJobRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)createJobRequest.clientRequestToken(), CLIENTREQUESTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)createJobRequest.jobTemplate(), JOBTEMPLATE_BINDING);
            protocolMarshaller.marshall((Object)createJobRequest.queue(), QUEUE_BINDING);
            protocolMarshaller.marshall((Object)createJobRequest.role(), ROLE_BINDING);
            protocolMarshaller.marshall((Object)createJobRequest.settings(), SETTINGS_BINDING);
            protocolMarshaller.marshall(createJobRequest.userMetadata(), USERMETADATA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

