/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.transform.WavSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class WavSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, WavSettings> {
    private final Integer bitDepth;
    private final Integer channels;
    private final Integer sampleRate;

    private WavSettings(BuilderImpl builder) {
        this.bitDepth = builder.bitDepth;
        this.channels = builder.channels;
        this.sampleRate = builder.sampleRate;
    }

    public Integer bitDepth() {
        return this.bitDepth;
    }

    public Integer channels() {
        return this.channels;
    }

    public Integer sampleRate() {
        return this.sampleRate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bitDepth());
        hashCode = 31 * hashCode + Objects.hashCode(this.channels());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleRate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WavSettings)) {
            return false;
        }
        WavSettings other = (WavSettings)obj;
        return Objects.equals(this.bitDepth(), other.bitDepth()) && Objects.equals(this.channels(), other.channels()) && Objects.equals(this.sampleRate(), other.sampleRate());
    }

    public String toString() {
        return ToString.builder((String)"WavSettings").add("BitDepth", (Object)this.bitDepth()).add("Channels", (Object)this.channels()).add("SampleRate", (Object)this.sampleRate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BitDepth": {
                return Optional.of(clazz.cast(this.bitDepth()));
            }
            case "Channels": {
                return Optional.of(clazz.cast(this.channels()));
            }
            case "SampleRate": {
                return Optional.of(clazz.cast(this.sampleRate()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WavSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer bitDepth;
        private Integer channels;
        private Integer sampleRate;

        private BuilderImpl() {
        }

        private BuilderImpl(WavSettings model) {
            this.bitDepth(model.bitDepth);
            this.channels(model.channels);
            this.sampleRate(model.sampleRate);
        }

        public final Integer getBitDepth() {
            return this.bitDepth;
        }

        @Override
        public final Builder bitDepth(Integer bitDepth) {
            this.bitDepth = bitDepth;
            return this;
        }

        public final void setBitDepth(Integer bitDepth) {
            this.bitDepth = bitDepth;
        }

        public final Integer getChannels() {
            return this.channels;
        }

        @Override
        public final Builder channels(Integer channels) {
            this.channels = channels;
            return this;
        }

        public final void setChannels(Integer channels) {
            this.channels = channels;
        }

        public final Integer getSampleRate() {
            return this.sampleRate;
        }

        @Override
        public final Builder sampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final void setSampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
        }

        public WavSettings build() {
            return new WavSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, WavSettings> {
        public Builder bitDepth(Integer var1);

        public Builder channels(Integer var1);

        public Builder sampleRate(Integer var1);
    }
}

