/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.transform.StaticKeyProviderMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StaticKeyProvider
implements StructuredPojo,
ToCopyableBuilder<Builder, StaticKeyProvider> {
    private final String keyFormat;
    private final String keyFormatVersions;
    private final String staticKeyValue;
    private final String url;

    private StaticKeyProvider(BuilderImpl builder) {
        this.keyFormat = builder.keyFormat;
        this.keyFormatVersions = builder.keyFormatVersions;
        this.staticKeyValue = builder.staticKeyValue;
        this.url = builder.url;
    }

    public String keyFormat() {
        return this.keyFormat;
    }

    public String keyFormatVersions() {
        return this.keyFormatVersions;
    }

    public String staticKeyValue() {
        return this.staticKeyValue;
    }

    public String url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyFormat());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyFormatVersions());
        hashCode = 31 * hashCode + Objects.hashCode(this.staticKeyValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StaticKeyProvider)) {
            return false;
        }
        StaticKeyProvider other = (StaticKeyProvider)obj;
        return Objects.equals(this.keyFormat(), other.keyFormat()) && Objects.equals(this.keyFormatVersions(), other.keyFormatVersions()) && Objects.equals(this.staticKeyValue(), other.staticKeyValue()) && Objects.equals(this.url(), other.url());
    }

    public String toString() {
        return ToString.builder((String)"StaticKeyProvider").add("KeyFormat", (Object)this.keyFormat()).add("KeyFormatVersions", (Object)this.keyFormatVersions()).add("StaticKeyValue", (Object)this.staticKeyValue()).add("Url", (Object)this.url()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyFormat": {
                return Optional.of(clazz.cast(this.keyFormat()));
            }
            case "KeyFormatVersions": {
                return Optional.of(clazz.cast(this.keyFormatVersions()));
            }
            case "StaticKeyValue": {
                return Optional.of(clazz.cast(this.staticKeyValue()));
            }
            case "Url": {
                return Optional.of(clazz.cast(this.url()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StaticKeyProviderMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String keyFormat;
        private String keyFormatVersions;
        private String staticKeyValue;
        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(StaticKeyProvider model) {
            this.keyFormat(model.keyFormat);
            this.keyFormatVersions(model.keyFormatVersions);
            this.staticKeyValue(model.staticKeyValue);
            this.url(model.url);
        }

        public final String getKeyFormat() {
            return this.keyFormat;
        }

        @Override
        public final Builder keyFormat(String keyFormat) {
            this.keyFormat = keyFormat;
            return this;
        }

        public final void setKeyFormat(String keyFormat) {
            this.keyFormat = keyFormat;
        }

        public final String getKeyFormatVersions() {
            return this.keyFormatVersions;
        }

        @Override
        public final Builder keyFormatVersions(String keyFormatVersions) {
            this.keyFormatVersions = keyFormatVersions;
            return this;
        }

        public final void setKeyFormatVersions(String keyFormatVersions) {
            this.keyFormatVersions = keyFormatVersions;
        }

        public final String getStaticKeyValue() {
            return this.staticKeyValue;
        }

        @Override
        public final Builder staticKeyValue(String staticKeyValue) {
            this.staticKeyValue = staticKeyValue;
            return this;
        }

        public final void setStaticKeyValue(String staticKeyValue) {
            this.staticKeyValue = staticKeyValue;
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public StaticKeyProvider build() {
            return new StaticKeyProvider(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StaticKeyProvider> {
        public Builder keyFormat(String var1);

        public Builder keyFormatVersions(String var1);

        public Builder staticKeyValue(String var1);

        public Builder url(String var1);
    }
}

