/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.CaptionDestinationSettings;
import software.amazon.awssdk.services.mediaconvert.model.LanguageCode;
import software.amazon.awssdk.services.mediaconvert.transform.CaptionDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CaptionDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, CaptionDescription> {
    private final String captionSelectorName;
    private final CaptionDestinationSettings destinationSettings;
    private final String languageCode;
    private final String languageDescription;

    private CaptionDescription(BuilderImpl builder) {
        this.captionSelectorName = builder.captionSelectorName;
        this.destinationSettings = builder.destinationSettings;
        this.languageCode = builder.languageCode;
        this.languageDescription = builder.languageDescription;
    }

    public String captionSelectorName() {
        return this.captionSelectorName;
    }

    public CaptionDestinationSettings destinationSettings() {
        return this.destinationSettings;
    }

    public LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public String languageCodeString() {
        return this.languageCode;
    }

    public String languageDescription() {
        return this.languageDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.captionSelectorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageDescription());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaptionDescription)) {
            return false;
        }
        CaptionDescription other = (CaptionDescription)obj;
        return Objects.equals(this.captionSelectorName(), other.captionSelectorName()) && Objects.equals(this.destinationSettings(), other.destinationSettings()) && Objects.equals(this.languageCodeString(), other.languageCodeString()) && Objects.equals(this.languageDescription(), other.languageDescription());
    }

    public String toString() {
        return ToString.builder((String)"CaptionDescription").add("CaptionSelectorName", (Object)this.captionSelectorName()).add("DestinationSettings", (Object)this.destinationSettings()).add("LanguageCode", (Object)this.languageCodeString()).add("LanguageDescription", (Object)this.languageDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CaptionSelectorName": {
                return Optional.of(clazz.cast(this.captionSelectorName()));
            }
            case "DestinationSettings": {
                return Optional.of(clazz.cast(this.destinationSettings()));
            }
            case "LanguageCode": {
                return Optional.of(clazz.cast(this.languageCodeString()));
            }
            case "LanguageDescription": {
                return Optional.of(clazz.cast(this.languageDescription()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CaptionDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String captionSelectorName;
        private CaptionDestinationSettings destinationSettings;
        private String languageCode;
        private String languageDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(CaptionDescription model) {
            this.captionSelectorName(model.captionSelectorName);
            this.destinationSettings(model.destinationSettings);
            this.languageCode(model.languageCode);
            this.languageDescription(model.languageDescription);
        }

        public final String getCaptionSelectorName() {
            return this.captionSelectorName;
        }

        @Override
        public final Builder captionSelectorName(String captionSelectorName) {
            this.captionSelectorName = captionSelectorName;
            return this;
        }

        public final void setCaptionSelectorName(String captionSelectorName) {
            this.captionSelectorName = captionSelectorName;
        }

        public final CaptionDestinationSettings.Builder getDestinationSettings() {
            return this.destinationSettings != null ? this.destinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder destinationSettings(CaptionDestinationSettings destinationSettings) {
            this.destinationSettings = destinationSettings;
            return this;
        }

        public final void setDestinationSettings(CaptionDestinationSettings.BuilderImpl destinationSettings) {
            this.destinationSettings = destinationSettings != null ? destinationSettings.build() : null;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final String getLanguageDescription() {
            return this.languageDescription;
        }

        @Override
        public final Builder languageDescription(String languageDescription) {
            this.languageDescription = languageDescription;
            return this;
        }

        public final void setLanguageDescription(String languageDescription) {
            this.languageDescription = languageDescription;
        }

        public CaptionDescription build() {
            return new CaptionDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CaptionDescription> {
        public Builder captionSelectorName(String var1);

        public Builder destinationSettings(CaptionDestinationSettings var1);

        default public Builder destinationSettings(Consumer<CaptionDestinationSettings.Builder> destinationSettings) {
            return this.destinationSettings((CaptionDestinationSettings)((CaptionDestinationSettings.Builder)CaptionDestinationSettings.builder().apply(destinationSettings)).build());
        }

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder languageDescription(String var1);
    }
}

