/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.QueueStatus;
import software.amazon.awssdk.services.mediaconvert.model.Type;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Queue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Queue> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Queue.getter(Queue::arn)).setter(Queue.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Queue.getter(Queue::createdAt)).setter(Queue.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Queue.getter(Queue::description)).setter(Queue.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Queue.getter(Queue::lastUpdated)).setter(Queue.setter(Builder::lastUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdated").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Queue.getter(Queue::name)).setter(Queue.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Integer> PROGRESSING_JOBS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Queue.getter(Queue::progressingJobsCount)).setter(Queue.setter(Builder::progressingJobsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progressingJobsCount").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Queue.getter(Queue::statusAsString)).setter(Queue.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Integer> SUBMITTED_JOBS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Queue.getter(Queue::submittedJobsCount)).setter(Queue.setter(Builder::submittedJobsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("submittedJobsCount").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Queue.getter(Queue::typeAsString)).setter(Queue.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, LAST_UPDATED_FIELD, NAME_FIELD, PROGRESSING_JOBS_COUNT_FIELD, STATUS_FIELD, SUBMITTED_JOBS_COUNT_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Instant createdAt;
    private final String description;
    private final Instant lastUpdated;
    private final String name;
    private final Integer progressingJobsCount;
    private final String status;
    private final Integer submittedJobsCount;
    private final String type;

    private Queue(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.lastUpdated = builder.lastUpdated;
        this.name = builder.name;
        this.progressingJobsCount = builder.progressingJobsCount;
        this.status = builder.status;
        this.submittedJobsCount = builder.submittedJobsCount;
        this.type = builder.type;
    }

    public String arn() {
        return this.arn;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public String description() {
        return this.description;
    }

    public Instant lastUpdated() {
        return this.lastUpdated;
    }

    public String name() {
        return this.name;
    }

    public Integer progressingJobsCount() {
        return this.progressingJobsCount;
    }

    public QueueStatus status() {
        return QueueStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Integer submittedJobsCount() {
        return this.submittedJobsCount;
    }

    public Type type() {
        return Type.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressingJobsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.submittedJobsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Queue)) {
            return false;
        }
        Queue other = (Queue)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.lastUpdated(), other.lastUpdated()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.progressingJobsCount(), other.progressingJobsCount()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.submittedJobsCount(), other.submittedJobsCount()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public String toString() {
        return ToString.builder((String)"Queue").add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("Description", (Object)this.description()).add("LastUpdated", (Object)this.lastUpdated()).add("Name", (Object)this.name()).add("ProgressingJobsCount", (Object)this.progressingJobsCount()).add("Status", (Object)this.statusAsString()).add("SubmittedJobsCount", (Object)this.submittedJobsCount()).add("Type", (Object)this.typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "LastUpdated": {
                return Optional.ofNullable(clazz.cast(this.lastUpdated()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ProgressingJobsCount": {
                return Optional.ofNullable(clazz.cast(this.progressingJobsCount()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "SubmittedJobsCount": {
                return Optional.ofNullable(clazz.cast(this.submittedJobsCount()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Queue, T> g) {
        return obj -> g.apply((Queue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Instant createdAt;
        private String description;
        private Instant lastUpdated;
        private String name;
        private Integer progressingJobsCount;
        private String status;
        private Integer submittedJobsCount;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Queue model) {
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.lastUpdated(model.lastUpdated);
            this.name(model.name);
            this.progressingJobsCount(model.progressingJobsCount);
            this.status(model.status);
            this.submittedJobsCount(model.submittedJobsCount);
            this.type(model.type);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getLastUpdated() {
            return this.lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getProgressingJobsCount() {
            return this.progressingJobsCount;
        }

        @Override
        public final Builder progressingJobsCount(Integer progressingJobsCount) {
            this.progressingJobsCount = progressingJobsCount;
            return this;
        }

        public final void setProgressingJobsCount(Integer progressingJobsCount) {
            this.progressingJobsCount = progressingJobsCount;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QueueStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Integer getSubmittedJobsCount() {
            return this.submittedJobsCount;
        }

        @Override
        public final Builder submittedJobsCount(Integer submittedJobsCount) {
            this.submittedJobsCount = submittedJobsCount;
            return this;
        }

        public final void setSubmittedJobsCount(Integer submittedJobsCount) {
            this.submittedJobsCount = submittedJobsCount;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public Queue build() {
            return new Queue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Queue> {
        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder description(String var1);

        public Builder lastUpdated(Instant var1);

        public Builder name(String var1);

        public Builder progressingJobsCount(Integer var1);

        public Builder status(String var1);

        public Builder status(QueueStatus var1);

        public Builder submittedJobsCount(Integer var1);

        public Builder type(String var1);

        public Builder type(Type var1);
    }
}

