/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mediaconvert.model.SpekeKeyProvider;

public class SpekeKeyProviderUnmarshaller
implements Unmarshaller<SpekeKeyProvider, JsonUnmarshallerContext> {
    private static final SpekeKeyProviderUnmarshaller INSTANCE = new SpekeKeyProviderUnmarshaller();

    public SpekeKeyProvider unmarshall(JsonUnmarshallerContext context) throws Exception {
        SpekeKeyProvider.Builder spekeKeyProviderBuilder = SpekeKeyProvider.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("resourceId", targetDepth)) {
                    context.nextToken();
                    spekeKeyProviderBuilder.resourceId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("systemIds", targetDepth)) {
                    context.nextToken();
                    spekeKeyProviderBuilder.systemIds(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("url", targetDepth)) {
                    context.nextToken();
                    spekeKeyProviderBuilder.url((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (SpekeKeyProvider)spekeKeyProviderBuilder.build();
    }

    public static SpekeKeyProviderUnmarshaller getInstance() {
        return INSTANCE;
    }
}

