/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.SpekeKeyProvider;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SpekeKeyProviderMarshaller {
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceId").isBinary(false).build();
    private static final MarshallingInfo<List> SYSTEMIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("systemIds").isBinary(false).build();
    private static final MarshallingInfo<String> URL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("url").isBinary(false).build();
    private static final SpekeKeyProviderMarshaller INSTANCE = new SpekeKeyProviderMarshaller();

    private SpekeKeyProviderMarshaller() {
    }

    public static SpekeKeyProviderMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SpekeKeyProvider spekeKeyProvider, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)spekeKeyProvider, (String)"spekeKeyProvider");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)spekeKeyProvider.resourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall(spekeKeyProvider.systemIds(), SYSTEMIDS_BINDING);
            protocolMarshaller.marshall((Object)spekeKeyProvider.url(), URL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

