/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.M2tsSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class M2tsSettingsMarshaller {
    private static final MarshallingInfo<String> AUDIOBUFFERMODEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioBufferModel").isBinary(false).build();
    private static final MarshallingInfo<Integer> AUDIOFRAMESPERPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioFramesPerPes").isBinary(false).build();
    private static final MarshallingInfo<List> AUDIOPIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioPids").isBinary(false).build();
    private static final MarshallingInfo<Integer> BITRATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bitrate").isBinary(false).build();
    private static final MarshallingInfo<String> BUFFERMODEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bufferModel").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DVBNITSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dvbNitSettings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DVBSDTSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dvbSdtSettings").isBinary(false).build();
    private static final MarshallingInfo<List> DVBSUBPIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dvbSubPids").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DVBTDTSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dvbTdtSettings").isBinary(false).build();
    private static final MarshallingInfo<Integer> DVBTELETEXTPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dvbTeletextPid").isBinary(false).build();
    private static final MarshallingInfo<String> EBPAUDIOINTERVAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ebpAudioInterval").isBinary(false).build();
    private static final MarshallingInfo<String> EBPPLACEMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ebpPlacement").isBinary(false).build();
    private static final MarshallingInfo<String> ESRATEINPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("esRateInPes").isBinary(false).build();
    private static final MarshallingInfo<Double> FRAGMENTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fragmentTime").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXPCRINTERVAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxPcrInterval").isBinary(false).build();
    private static final MarshallingInfo<Integer> MINEBPINTERVAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minEbpInterval").isBinary(false).build();
    private static final MarshallingInfo<Double> NULLPACKETBITRATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nullPacketBitrate").isBinary(false).build();
    private static final MarshallingInfo<Integer> PATINTERVAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("patInterval").isBinary(false).build();
    private static final MarshallingInfo<String> PCRCONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pcrControl").isBinary(false).build();
    private static final MarshallingInfo<Integer> PCRPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pcrPid").isBinary(false).build();
    private static final MarshallingInfo<Integer> PMTINTERVAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pmtInterval").isBinary(false).build();
    private static final MarshallingInfo<Integer> PMTPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pmtPid").isBinary(false).build();
    private static final MarshallingInfo<Integer> PRIVATEMETADATAPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("privateMetadataPid").isBinary(false).build();
    private static final MarshallingInfo<Integer> PROGRAMNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("programNumber").isBinary(false).build();
    private static final MarshallingInfo<String> RATEMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rateMode").isBinary(false).build();
    private static final MarshallingInfo<Integer> SCTE35PID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scte35Pid").isBinary(false).build();
    private static final MarshallingInfo<String> SCTE35SOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scte35Source").isBinary(false).build();
    private static final MarshallingInfo<String> SEGMENTATIONMARKERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("segmentationMarkers").isBinary(false).build();
    private static final MarshallingInfo<String> SEGMENTATIONSTYLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("segmentationStyle").isBinary(false).build();
    private static final MarshallingInfo<Double> SEGMENTATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("segmentationTime").isBinary(false).build();
    private static final MarshallingInfo<Integer> TRANSPORTSTREAMID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("transportStreamId").isBinary(false).build();
    private static final MarshallingInfo<Integer> VIDEOPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("videoPid").isBinary(false).build();
    private static final M2tsSettingsMarshaller INSTANCE = new M2tsSettingsMarshaller();

    private M2tsSettingsMarshaller() {
    }

    public static M2tsSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(M2tsSettings m2tsSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)m2tsSettings, (String)"m2tsSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)m2tsSettings.audioBufferModelAsString(), AUDIOBUFFERMODEL_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.audioFramesPerPes(), AUDIOFRAMESPERPES_BINDING);
            protocolMarshaller.marshall(m2tsSettings.audioPids(), AUDIOPIDS_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.bitrate(), BITRATE_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.bufferModelAsString(), BUFFERMODEL_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.dvbNitSettings(), DVBNITSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.dvbSdtSettings(), DVBSDTSETTINGS_BINDING);
            protocolMarshaller.marshall(m2tsSettings.dvbSubPids(), DVBSUBPIDS_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.dvbTdtSettings(), DVBTDTSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.dvbTeletextPid(), DVBTELETEXTPID_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.ebpAudioIntervalAsString(), EBPAUDIOINTERVAL_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.ebpPlacementAsString(), EBPPLACEMENT_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.esRateInPesAsString(), ESRATEINPES_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.fragmentTime(), FRAGMENTTIME_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.maxPcrInterval(), MAXPCRINTERVAL_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.minEbpInterval(), MINEBPINTERVAL_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.nullPacketBitrate(), NULLPACKETBITRATE_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.patInterval(), PATINTERVAL_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.pcrControlAsString(), PCRCONTROL_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.pcrPid(), PCRPID_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.pmtInterval(), PMTINTERVAL_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.pmtPid(), PMTPID_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.privateMetadataPid(), PRIVATEMETADATAPID_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.programNumber(), PROGRAMNUMBER_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.rateModeAsString(), RATEMODE_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.scte35Pid(), SCTE35PID_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.scte35SourceAsString(), SCTE35SOURCE_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.segmentationMarkersAsString(), SEGMENTATIONMARKERS_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.segmentationStyleAsString(), SEGMENTATIONSTYLE_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.segmentationTime(), SEGMENTATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.transportStreamId(), TRANSPORTSTREAMID_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.videoPid(), VIDEOPID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

