/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.InsertableImage;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InsertableImageMarshaller {
    private static final MarshallingInfo<Integer> DURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("duration").isBinary(false).build();
    private static final MarshallingInfo<Integer> FADEIN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fadeIn").isBinary(false).build();
    private static final MarshallingInfo<Integer> FADEOUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fadeOut").isBinary(false).build();
    private static final MarshallingInfo<Integer> HEIGHT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("height").isBinary(false).build();
    private static final MarshallingInfo<String> IMAGEINSERTERINPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageInserterInput").isBinary(false).build();
    private static final MarshallingInfo<Integer> IMAGEX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageX").isBinary(false).build();
    private static final MarshallingInfo<Integer> IMAGEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageY").isBinary(false).build();
    private static final MarshallingInfo<Integer> LAYER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("layer").isBinary(false).build();
    private static final MarshallingInfo<Integer> OPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("opacity").isBinary(false).build();
    private static final MarshallingInfo<String> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTime").isBinary(false).build();
    private static final MarshallingInfo<Integer> WIDTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("width").isBinary(false).build();
    private static final InsertableImageMarshaller INSTANCE = new InsertableImageMarshaller();

    private InsertableImageMarshaller() {
    }

    public static InsertableImageMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InsertableImage insertableImage, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)insertableImage, (String)"insertableImage");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)insertableImage.duration(), DURATION_BINDING);
            protocolMarshaller.marshall((Object)insertableImage.fadeIn(), FADEIN_BINDING);
            protocolMarshaller.marshall((Object)insertableImage.fadeOut(), FADEOUT_BINDING);
            protocolMarshaller.marshall((Object)insertableImage.height(), HEIGHT_BINDING);
            protocolMarshaller.marshall((Object)insertableImage.imageInserterInput(), IMAGEINSERTERINPUT_BINDING);
            protocolMarshaller.marshall((Object)insertableImage.imageX(), IMAGEX_BINDING);
            protocolMarshaller.marshall((Object)insertableImage.imageY(), IMAGEY_BINDING);
            protocolMarshaller.marshall((Object)insertableImage.layer(), LAYER_BINDING);
            protocolMarshaller.marshall((Object)insertableImage.opacity(), OPACITY_BINDING);
            protocolMarshaller.marshall((Object)insertableImage.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)insertableImage.width(), WIDTH_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

