/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.DashIsoGroupSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DashIsoGroupSettingsMarshaller {
    private static final MarshallingInfo<String> BASEURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("baseUrl").isBinary(false).build();
    private static final MarshallingInfo<String> DESTINATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destination").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ENCRYPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("encryption").isBinary(false).build();
    private static final MarshallingInfo<Integer> FRAGMENTLENGTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fragmentLength").isBinary(false).build();
    private static final MarshallingInfo<String> HBBTVCOMPLIANCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hbbtvCompliance").isBinary(false).build();
    private static final MarshallingInfo<Integer> MINBUFFERTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minBufferTime").isBinary(false).build();
    private static final MarshallingInfo<String> SEGMENTCONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("segmentControl").isBinary(false).build();
    private static final MarshallingInfo<Integer> SEGMENTLENGTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("segmentLength").isBinary(false).build();
    private static final DashIsoGroupSettingsMarshaller INSTANCE = new DashIsoGroupSettingsMarshaller();

    private DashIsoGroupSettingsMarshaller() {
    }

    public static DashIsoGroupSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DashIsoGroupSettings dashIsoGroupSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)dashIsoGroupSettings, (String)"dashIsoGroupSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)dashIsoGroupSettings.baseUrl(), BASEURL_BINDING);
            protocolMarshaller.marshall((Object)dashIsoGroupSettings.destination(), DESTINATION_BINDING);
            protocolMarshaller.marshall((Object)dashIsoGroupSettings.encryption(), ENCRYPTION_BINDING);
            protocolMarshaller.marshall((Object)dashIsoGroupSettings.fragmentLength(), FRAGMENTLENGTH_BINDING);
            protocolMarshaller.marshall((Object)dashIsoGroupSettings.hbbtvComplianceAsString(), HBBTVCOMPLIANCE_BINDING);
            protocolMarshaller.marshall((Object)dashIsoGroupSettings.minBufferTime(), MINBUFFERTIME_BINDING);
            protocolMarshaller.marshall((Object)dashIsoGroupSettings.segmentControlAsString(), SEGMENTCONTROL_BINDING);
            protocolMarshaller.marshall((Object)dashIsoGroupSettings.segmentLength(), SEGMENTLENGTH_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

