/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mediaconvert.model.ColorCorrector;
import software.amazon.awssdk.services.mediaconvert.transform.Hdr10MetadataUnmarshaller;

public class ColorCorrectorUnmarshaller
implements Unmarshaller<ColorCorrector, JsonUnmarshallerContext> {
    private static final ColorCorrectorUnmarshaller INSTANCE = new ColorCorrectorUnmarshaller();

    public ColorCorrector unmarshall(JsonUnmarshallerContext context) throws Exception {
        ColorCorrector.Builder colorCorrectorBuilder = ColorCorrector.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("brightness", targetDepth)) {
                    context.nextToken();
                    colorCorrectorBuilder.brightness((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("colorSpaceConversion", targetDepth)) {
                    context.nextToken();
                    colorCorrectorBuilder.colorSpaceConversion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("contrast", targetDepth)) {
                    context.nextToken();
                    colorCorrectorBuilder.contrast((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("hdr10Metadata", targetDepth)) {
                    context.nextToken();
                    colorCorrectorBuilder.hdr10Metadata(Hdr10MetadataUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("hue", targetDepth)) {
                    context.nextToken();
                    colorCorrectorBuilder.hue((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("saturation", targetDepth)) {
                    context.nextToken();
                    colorCorrectorBuilder.saturation((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ColorCorrector)colorCorrectorBuilder.build();
    }

    public static ColorCorrectorUnmarshaller getInstance() {
        return INSTANCE;
    }
}

