/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mediaconvert.model.AudioSelector;
import software.amazon.awssdk.services.mediaconvert.transform.RemixSettingsUnmarshaller;

public class AudioSelectorUnmarshaller
implements Unmarshaller<AudioSelector, JsonUnmarshallerContext> {
    private static final AudioSelectorUnmarshaller INSTANCE = new AudioSelectorUnmarshaller();

    public AudioSelector unmarshall(JsonUnmarshallerContext context) throws Exception {
        AudioSelector.Builder audioSelectorBuilder = AudioSelector.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("defaultSelection", targetDepth)) {
                    context.nextToken();
                    audioSelectorBuilder.defaultSelection((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("externalAudioFileInput", targetDepth)) {
                    context.nextToken();
                    audioSelectorBuilder.externalAudioFileInput((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("languageCode", targetDepth)) {
                    context.nextToken();
                    audioSelectorBuilder.languageCode((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("offset", targetDepth)) {
                    context.nextToken();
                    audioSelectorBuilder.offset((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("pids", targetDepth)) {
                    context.nextToken();
                    audioSelectorBuilder.pids(new ListUnmarshaller(context.getUnmarshaller(Integer.class)).unmarshall(context));
                }
                if (context.testExpression("programSelection", targetDepth)) {
                    context.nextToken();
                    audioSelectorBuilder.programSelection((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("remixSettings", targetDepth)) {
                    context.nextToken();
                    audioSelectorBuilder.remixSettings(RemixSettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("selectorType", targetDepth)) {
                    context.nextToken();
                    audioSelectorBuilder.selectorType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("tracks", targetDepth)) {
                    context.nextToken();
                    audioSelectorBuilder.tracks(new ListUnmarshaller(context.getUnmarshaller(Integer.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (AudioSelector)audioSelectorBuilder.build();
    }

    public static AudioSelectorUnmarshaller getInstance() {
        return INSTANCE;
    }
}

