/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.mediaconvert.model.MediaConvertRequest;
import software.amazon.awssdk.services.mediaconvert.model.QueueStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateQueueRequest
extends MediaConvertRequest
implements ToCopyableBuilder<Builder, UpdateQueueRequest> {
    private final String description;
    private final String name;
    private final String status;

    private UpdateQueueRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.name = builder.name;
        this.status = builder.status;
    }

    public String description() {
        return this.description;
    }

    public String name() {
        return this.name;
    }

    public QueueStatus status() {
        return QueueStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateQueueRequest)) {
            return false;
        }
        UpdateQueueRequest other = (UpdateQueueRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"UpdateQueueRequest").add("Description", (Object)this.description()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MediaConvertRequest.BuilderImpl
    implements Builder {
        private String description;
        private String name;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateQueueRequest model) {
            super(model);
            this.description(model.description);
            this.name(model.name);
            this.status(model.status);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QueueStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateQueueRequest build() {
            return new UpdateQueueRequest(this);
        }
    }

    public static interface Builder
    extends MediaConvertRequest.Builder,
    CopyableBuilder<Builder, UpdateQueueRequest> {
        public Builder description(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(QueueStatus var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

