/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.TimecodeSource;
import software.amazon.awssdk.services.mediaconvert.transform.TimecodeConfigMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TimecodeConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, TimecodeConfig> {
    private final String anchor;
    private final String source;
    private final String start;
    private final String timestampOffset;

    private TimecodeConfig(BuilderImpl builder) {
        this.anchor = builder.anchor;
        this.source = builder.source;
        this.start = builder.start;
        this.timestampOffset = builder.timestampOffset;
    }

    public String anchor() {
        return this.anchor;
    }

    public TimecodeSource source() {
        return TimecodeSource.fromValue(this.source);
    }

    public String sourceAsString() {
        return this.source;
    }

    public String start() {
        return this.start;
    }

    public String timestampOffset() {
        return this.timestampOffset;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.anchor());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.start());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestampOffset());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimecodeConfig)) {
            return false;
        }
        TimecodeConfig other = (TimecodeConfig)obj;
        return Objects.equals(this.anchor(), other.anchor()) && Objects.equals(this.sourceAsString(), other.sourceAsString()) && Objects.equals(this.start(), other.start()) && Objects.equals(this.timestampOffset(), other.timestampOffset());
    }

    public String toString() {
        return ToString.builder((String)"TimecodeConfig").add("Anchor", (Object)this.anchor()).add("Source", (Object)this.sourceAsString()).add("Start", (Object)this.start()).add("TimestampOffset", (Object)this.timestampOffset()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Anchor": {
                return Optional.of(clazz.cast(this.anchor()));
            }
            case "Source": {
                return Optional.of(clazz.cast(this.sourceAsString()));
            }
            case "Start": {
                return Optional.of(clazz.cast(this.start()));
            }
            case "TimestampOffset": {
                return Optional.of(clazz.cast(this.timestampOffset()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TimecodeConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String anchor;
        private String source;
        private String start;
        private String timestampOffset;

        private BuilderImpl() {
        }

        private BuilderImpl(TimecodeConfig model) {
            this.anchor(model.anchor);
            this.source(model.source);
            this.start(model.start);
            this.timestampOffset(model.timestampOffset);
        }

        public final String getAnchor() {
            return this.anchor;
        }

        @Override
        public final Builder anchor(String anchor) {
            this.anchor = anchor;
            return this;
        }

        public final void setAnchor(String anchor) {
            this.anchor = anchor;
        }

        public final String getSource() {
            return this.source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(TimecodeSource source) {
            this.source(source.toString());
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final String getStart() {
            return this.start;
        }

        @Override
        public final Builder start(String start) {
            this.start = start;
            return this;
        }

        public final void setStart(String start) {
            this.start = start;
        }

        public final String getTimestampOffset() {
            return this.timestampOffset;
        }

        @Override
        public final Builder timestampOffset(String timestampOffset) {
            this.timestampOffset = timestampOffset;
            return this;
        }

        public final void setTimestampOffset(String timestampOffset) {
            this.timestampOffset = timestampOffset;
        }

        public TimecodeConfig build() {
            return new TimecodeConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TimecodeConfig> {
        public Builder anchor(String var1);

        public Builder source(String var1);

        public Builder source(TimecodeSource var1);

        public Builder start(String var1);

        public Builder timestampOffset(String var1);
    }
}

