/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.QueueStatus;
import software.amazon.awssdk.services.mediaconvert.model.Type;
import software.amazon.awssdk.services.mediaconvert.transform.QueueMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Queue
implements StructuredPojo,
ToCopyableBuilder<Builder, Queue> {
    private final String arn;
    private final Instant createdAt;
    private final String description;
    private final Instant lastUpdated;
    private final String name;
    private final String status;
    private final String type;

    private Queue(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.lastUpdated = builder.lastUpdated;
        this.name = builder.name;
        this.status = builder.status;
        this.type = builder.type;
    }

    public String arn() {
        return this.arn;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public String description() {
        return this.description;
    }

    public Instant lastUpdated() {
        return this.lastUpdated;
    }

    public String name() {
        return this.name;
    }

    public QueueStatus status() {
        return QueueStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Type type() {
        return Type.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Queue)) {
            return false;
        }
        Queue other = (Queue)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.lastUpdated(), other.lastUpdated()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public String toString() {
        return ToString.builder((String)"Queue").add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("Description", (Object)this.description()).add("LastUpdated", (Object)this.lastUpdated()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("Type", (Object)this.typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "CreatedAt": {
                return Optional.of(clazz.cast(this.createdAt()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "LastUpdated": {
                return Optional.of(clazz.cast(this.lastUpdated()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusAsString()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        QueueMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Instant createdAt;
        private String description;
        private Instant lastUpdated;
        private String name;
        private String status;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Queue model) {
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.lastUpdated(model.lastUpdated);
            this.name(model.name);
            this.status(model.status);
            this.type(model.type);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getLastUpdated() {
            return this.lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QueueStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public Queue build() {
            return new Queue(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Queue> {
        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder description(String var1);

        public Builder lastUpdated(Instant var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(QueueStatus var1);

        public Builder type(String var1);

        public Builder type(Type var1);
    }
}

