/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.AudioDescription;
import software.amazon.awssdk.services.mediaconvert.model.CaptionDescriptionPreset;
import software.amazon.awssdk.services.mediaconvert.model.ContainerSettings;
import software.amazon.awssdk.services.mediaconvert.model.ListOfAudioDescriptionCopier;
import software.amazon.awssdk.services.mediaconvert.model.ListOfCaptionDescriptionPresetCopier;
import software.amazon.awssdk.services.mediaconvert.model.VideoDescription;
import software.amazon.awssdk.services.mediaconvert.transform.PresetSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PresetSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, PresetSettings> {
    private final List<AudioDescription> audioDescriptions;
    private final List<CaptionDescriptionPreset> captionDescriptions;
    private final ContainerSettings containerSettings;
    private final VideoDescription videoDescription;

    private PresetSettings(BuilderImpl builder) {
        this.audioDescriptions = builder.audioDescriptions;
        this.captionDescriptions = builder.captionDescriptions;
        this.containerSettings = builder.containerSettings;
        this.videoDescription = builder.videoDescription;
    }

    public List<AudioDescription> audioDescriptions() {
        return this.audioDescriptions;
    }

    public List<CaptionDescriptionPreset> captionDescriptions() {
        return this.captionDescriptions;
    }

    public ContainerSettings containerSettings() {
        return this.containerSettings;
    }

    public VideoDescription videoDescription() {
        return this.videoDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioDescriptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.captionDescriptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoDescription());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PresetSettings)) {
            return false;
        }
        PresetSettings other = (PresetSettings)obj;
        return Objects.equals(this.audioDescriptions(), other.audioDescriptions()) && Objects.equals(this.captionDescriptions(), other.captionDescriptions()) && Objects.equals(this.containerSettings(), other.containerSettings()) && Objects.equals(this.videoDescription(), other.videoDescription());
    }

    public String toString() {
        return ToString.builder((String)"PresetSettings").add("AudioDescriptions", this.audioDescriptions()).add("CaptionDescriptions", this.captionDescriptions()).add("ContainerSettings", (Object)this.containerSettings()).add("VideoDescription", (Object)this.videoDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioDescriptions": {
                return Optional.of(clazz.cast(this.audioDescriptions()));
            }
            case "CaptionDescriptions": {
                return Optional.of(clazz.cast(this.captionDescriptions()));
            }
            case "ContainerSettings": {
                return Optional.of(clazz.cast(this.containerSettings()));
            }
            case "VideoDescription": {
                return Optional.of(clazz.cast(this.videoDescription()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PresetSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AudioDescription> audioDescriptions;
        private List<CaptionDescriptionPreset> captionDescriptions;
        private ContainerSettings containerSettings;
        private VideoDescription videoDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(PresetSettings model) {
            this.audioDescriptions(model.audioDescriptions);
            this.captionDescriptions(model.captionDescriptions);
            this.containerSettings(model.containerSettings);
            this.videoDescription(model.videoDescription);
        }

        public final Collection<AudioDescription.Builder> getAudioDescriptions() {
            return this.audioDescriptions != null ? (Collection)this.audioDescriptions.stream().map(AudioDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder audioDescriptions(Collection<AudioDescription> audioDescriptions) {
            this.audioDescriptions = ListOfAudioDescriptionCopier.copy(audioDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioDescriptions(AudioDescription ... audioDescriptions) {
            this.audioDescriptions(Arrays.asList(audioDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioDescriptions(Consumer<AudioDescription.Builder> ... audioDescriptions) {
            this.audioDescriptions(Stream.of(audioDescriptions).map(c -> (AudioDescription)((AudioDescription.Builder)AudioDescription.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAudioDescriptions(Collection<AudioDescription.BuilderImpl> audioDescriptions) {
            this.audioDescriptions = ListOfAudioDescriptionCopier.copyFromBuilder(audioDescriptions);
        }

        public final Collection<CaptionDescriptionPreset.Builder> getCaptionDescriptions() {
            return this.captionDescriptions != null ? (Collection)this.captionDescriptions.stream().map(CaptionDescriptionPreset::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder captionDescriptions(Collection<CaptionDescriptionPreset> captionDescriptions) {
            this.captionDescriptions = ListOfCaptionDescriptionPresetCopier.copy(captionDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionDescriptions(CaptionDescriptionPreset ... captionDescriptions) {
            this.captionDescriptions(Arrays.asList(captionDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionDescriptions(Consumer<CaptionDescriptionPreset.Builder> ... captionDescriptions) {
            this.captionDescriptions(Stream.of(captionDescriptions).map(c -> (CaptionDescriptionPreset)((CaptionDescriptionPreset.Builder)CaptionDescriptionPreset.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCaptionDescriptions(Collection<CaptionDescriptionPreset.BuilderImpl> captionDescriptions) {
            this.captionDescriptions = ListOfCaptionDescriptionPresetCopier.copyFromBuilder(captionDescriptions);
        }

        public final ContainerSettings.Builder getContainerSettings() {
            return this.containerSettings != null ? this.containerSettings.toBuilder() : null;
        }

        @Override
        public final Builder containerSettings(ContainerSettings containerSettings) {
            this.containerSettings = containerSettings;
            return this;
        }

        public final void setContainerSettings(ContainerSettings.BuilderImpl containerSettings) {
            this.containerSettings = containerSettings != null ? containerSettings.build() : null;
        }

        public final VideoDescription.Builder getVideoDescription() {
            return this.videoDescription != null ? this.videoDescription.toBuilder() : null;
        }

        @Override
        public final Builder videoDescription(VideoDescription videoDescription) {
            this.videoDescription = videoDescription;
            return this;
        }

        public final void setVideoDescription(VideoDescription.BuilderImpl videoDescription) {
            this.videoDescription = videoDescription != null ? videoDescription.build() : null;
        }

        public PresetSettings build() {
            return new PresetSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PresetSettings> {
        public Builder audioDescriptions(Collection<AudioDescription> var1);

        public Builder audioDescriptions(AudioDescription ... var1);

        public Builder audioDescriptions(Consumer<AudioDescription.Builder> ... var1);

        public Builder captionDescriptions(Collection<CaptionDescriptionPreset> var1);

        public Builder captionDescriptions(CaptionDescriptionPreset ... var1);

        public Builder captionDescriptions(Consumer<CaptionDescriptionPreset.Builder> ... var1);

        public Builder containerSettings(ContainerSettings var1);

        default public Builder containerSettings(Consumer<ContainerSettings.Builder> containerSettings) {
            return this.containerSettings((ContainerSettings)((ContainerSettings.Builder)ContainerSettings.builder().apply(containerSettings)).build());
        }

        public Builder videoDescription(VideoDescription var1);

        default public Builder videoDescription(Consumer<VideoDescription.Builder> videoDescription) {
            return this.videoDescription((VideoDescription)((VideoDescription.Builder)VideoDescription.builder().apply(videoDescription)).build());
        }
    }
}

