/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.DashIsoGroupSettings;
import software.amazon.awssdk.services.mediaconvert.model.FileGroupSettings;
import software.amazon.awssdk.services.mediaconvert.model.HlsGroupSettings;
import software.amazon.awssdk.services.mediaconvert.model.MsSmoothGroupSettings;
import software.amazon.awssdk.services.mediaconvert.model.OutputGroupType;
import software.amazon.awssdk.services.mediaconvert.transform.OutputGroupSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class OutputGroupSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, OutputGroupSettings> {
    private final DashIsoGroupSettings dashIsoGroupSettings;
    private final FileGroupSettings fileGroupSettings;
    private final HlsGroupSettings hlsGroupSettings;
    private final MsSmoothGroupSettings msSmoothGroupSettings;
    private final String type;

    private OutputGroupSettings(BuilderImpl builder) {
        this.dashIsoGroupSettings = builder.dashIsoGroupSettings;
        this.fileGroupSettings = builder.fileGroupSettings;
        this.hlsGroupSettings = builder.hlsGroupSettings;
        this.msSmoothGroupSettings = builder.msSmoothGroupSettings;
        this.type = builder.type;
    }

    public DashIsoGroupSettings dashIsoGroupSettings() {
        return this.dashIsoGroupSettings;
    }

    public FileGroupSettings fileGroupSettings() {
        return this.fileGroupSettings;
    }

    public HlsGroupSettings hlsGroupSettings() {
        return this.hlsGroupSettings;
    }

    public MsSmoothGroupSettings msSmoothGroupSettings() {
        return this.msSmoothGroupSettings;
    }

    public OutputGroupType type() {
        return OutputGroupType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dashIsoGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.msSmoothGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputGroupSettings)) {
            return false;
        }
        OutputGroupSettings other = (OutputGroupSettings)obj;
        return Objects.equals(this.dashIsoGroupSettings(), other.dashIsoGroupSettings()) && Objects.equals(this.fileGroupSettings(), other.fileGroupSettings()) && Objects.equals(this.hlsGroupSettings(), other.hlsGroupSettings()) && Objects.equals(this.msSmoothGroupSettings(), other.msSmoothGroupSettings()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public String toString() {
        return ToString.builder((String)"OutputGroupSettings").add("DashIsoGroupSettings", (Object)this.dashIsoGroupSettings()).add("FileGroupSettings", (Object)this.fileGroupSettings()).add("HlsGroupSettings", (Object)this.hlsGroupSettings()).add("MsSmoothGroupSettings", (Object)this.msSmoothGroupSettings()).add("Type", (Object)this.typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DashIsoGroupSettings": {
                return Optional.of(clazz.cast(this.dashIsoGroupSettings()));
            }
            case "FileGroupSettings": {
                return Optional.of(clazz.cast(this.fileGroupSettings()));
            }
            case "HlsGroupSettings": {
                return Optional.of(clazz.cast(this.hlsGroupSettings()));
            }
            case "MsSmoothGroupSettings": {
                return Optional.of(clazz.cast(this.msSmoothGroupSettings()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OutputGroupSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private DashIsoGroupSettings dashIsoGroupSettings;
        private FileGroupSettings fileGroupSettings;
        private HlsGroupSettings hlsGroupSettings;
        private MsSmoothGroupSettings msSmoothGroupSettings;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputGroupSettings model) {
            this.dashIsoGroupSettings(model.dashIsoGroupSettings);
            this.fileGroupSettings(model.fileGroupSettings);
            this.hlsGroupSettings(model.hlsGroupSettings);
            this.msSmoothGroupSettings(model.msSmoothGroupSettings);
            this.type(model.type);
        }

        public final DashIsoGroupSettings.Builder getDashIsoGroupSettings() {
            return this.dashIsoGroupSettings != null ? this.dashIsoGroupSettings.toBuilder() : null;
        }

        @Override
        public final Builder dashIsoGroupSettings(DashIsoGroupSettings dashIsoGroupSettings) {
            this.dashIsoGroupSettings = dashIsoGroupSettings;
            return this;
        }

        public final void setDashIsoGroupSettings(DashIsoGroupSettings.BuilderImpl dashIsoGroupSettings) {
            this.dashIsoGroupSettings = dashIsoGroupSettings != null ? dashIsoGroupSettings.build() : null;
        }

        public final FileGroupSettings.Builder getFileGroupSettings() {
            return this.fileGroupSettings != null ? this.fileGroupSettings.toBuilder() : null;
        }

        @Override
        public final Builder fileGroupSettings(FileGroupSettings fileGroupSettings) {
            this.fileGroupSettings = fileGroupSettings;
            return this;
        }

        public final void setFileGroupSettings(FileGroupSettings.BuilderImpl fileGroupSettings) {
            this.fileGroupSettings = fileGroupSettings != null ? fileGroupSettings.build() : null;
        }

        public final HlsGroupSettings.Builder getHlsGroupSettings() {
            return this.hlsGroupSettings != null ? this.hlsGroupSettings.toBuilder() : null;
        }

        @Override
        public final Builder hlsGroupSettings(HlsGroupSettings hlsGroupSettings) {
            this.hlsGroupSettings = hlsGroupSettings;
            return this;
        }

        public final void setHlsGroupSettings(HlsGroupSettings.BuilderImpl hlsGroupSettings) {
            this.hlsGroupSettings = hlsGroupSettings != null ? hlsGroupSettings.build() : null;
        }

        public final MsSmoothGroupSettings.Builder getMsSmoothGroupSettings() {
            return this.msSmoothGroupSettings != null ? this.msSmoothGroupSettings.toBuilder() : null;
        }

        @Override
        public final Builder msSmoothGroupSettings(MsSmoothGroupSettings msSmoothGroupSettings) {
            this.msSmoothGroupSettings = msSmoothGroupSettings;
            return this;
        }

        public final void setMsSmoothGroupSettings(MsSmoothGroupSettings.BuilderImpl msSmoothGroupSettings) {
            this.msSmoothGroupSettings = msSmoothGroupSettings != null ? msSmoothGroupSettings.build() : null;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(OutputGroupType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public OutputGroupSettings build() {
            return new OutputGroupSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OutputGroupSettings> {
        public Builder dashIsoGroupSettings(DashIsoGroupSettings var1);

        default public Builder dashIsoGroupSettings(Consumer<DashIsoGroupSettings.Builder> dashIsoGroupSettings) {
            return this.dashIsoGroupSettings((DashIsoGroupSettings)((DashIsoGroupSettings.Builder)DashIsoGroupSettings.builder().apply(dashIsoGroupSettings)).build());
        }

        public Builder fileGroupSettings(FileGroupSettings var1);

        default public Builder fileGroupSettings(Consumer<FileGroupSettings.Builder> fileGroupSettings) {
            return this.fileGroupSettings((FileGroupSettings)((FileGroupSettings.Builder)FileGroupSettings.builder().apply(fileGroupSettings)).build());
        }

        public Builder hlsGroupSettings(HlsGroupSettings var1);

        default public Builder hlsGroupSettings(Consumer<HlsGroupSettings.Builder> hlsGroupSettings) {
            return this.hlsGroupSettings((HlsGroupSettings)((HlsGroupSettings.Builder)HlsGroupSettings.builder().apply(hlsGroupSettings)).build());
        }

        public Builder msSmoothGroupSettings(MsSmoothGroupSettings var1);

        default public Builder msSmoothGroupSettings(Consumer<MsSmoothGroupSettings.Builder> msSmoothGroupSettings) {
            return this.msSmoothGroupSettings((MsSmoothGroupSettings)((MsSmoothGroupSettings.Builder)MsSmoothGroupSettings.builder().apply(msSmoothGroupSettings)).build());
        }

        public Builder type(String var1);

        public Builder type(OutputGroupType var1);
    }
}

