/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.AvailBlanking;
import software.amazon.awssdk.services.mediaconvert.model.Input;
import software.amazon.awssdk.services.mediaconvert.model.ListOfInputCopier;
import software.amazon.awssdk.services.mediaconvert.model.ListOfOutputGroupCopier;
import software.amazon.awssdk.services.mediaconvert.model.NielsenConfiguration;
import software.amazon.awssdk.services.mediaconvert.model.OutputGroup;
import software.amazon.awssdk.services.mediaconvert.model.TimecodeConfig;
import software.amazon.awssdk.services.mediaconvert.model.TimedMetadataInsertion;
import software.amazon.awssdk.services.mediaconvert.transform.JobSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class JobSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, JobSettings> {
    private final Integer adAvailOffset;
    private final AvailBlanking availBlanking;
    private final List<Input> inputs;
    private final NielsenConfiguration nielsenConfiguration;
    private final List<OutputGroup> outputGroups;
    private final TimecodeConfig timecodeConfig;
    private final TimedMetadataInsertion timedMetadataInsertion;

    private JobSettings(BuilderImpl builder) {
        this.adAvailOffset = builder.adAvailOffset;
        this.availBlanking = builder.availBlanking;
        this.inputs = builder.inputs;
        this.nielsenConfiguration = builder.nielsenConfiguration;
        this.outputGroups = builder.outputGroups;
        this.timecodeConfig = builder.timecodeConfig;
        this.timedMetadataInsertion = builder.timedMetadataInsertion;
    }

    public Integer adAvailOffset() {
        return this.adAvailOffset;
    }

    public AvailBlanking availBlanking() {
        return this.availBlanking;
    }

    public List<Input> inputs() {
        return this.inputs;
    }

    public NielsenConfiguration nielsenConfiguration() {
        return this.nielsenConfiguration;
    }

    public List<OutputGroup> outputGroups() {
        return this.outputGroups;
    }

    public TimecodeConfig timecodeConfig() {
        return this.timecodeConfig;
    }

    public TimedMetadataInsertion timedMetadataInsertion() {
        return this.timedMetadataInsertion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adAvailOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.availBlanking());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputs());
        hashCode = 31 * hashCode + Objects.hashCode(this.nielsenConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.timecodeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.timedMetadataInsertion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobSettings)) {
            return false;
        }
        JobSettings other = (JobSettings)obj;
        return Objects.equals(this.adAvailOffset(), other.adAvailOffset()) && Objects.equals(this.availBlanking(), other.availBlanking()) && Objects.equals(this.inputs(), other.inputs()) && Objects.equals(this.nielsenConfiguration(), other.nielsenConfiguration()) && Objects.equals(this.outputGroups(), other.outputGroups()) && Objects.equals(this.timecodeConfig(), other.timecodeConfig()) && Objects.equals(this.timedMetadataInsertion(), other.timedMetadataInsertion());
    }

    public String toString() {
        return ToString.builder((String)"JobSettings").add("AdAvailOffset", (Object)this.adAvailOffset()).add("AvailBlanking", (Object)this.availBlanking()).add("Inputs", this.inputs()).add("NielsenConfiguration", (Object)this.nielsenConfiguration()).add("OutputGroups", this.outputGroups()).add("TimecodeConfig", (Object)this.timecodeConfig()).add("TimedMetadataInsertion", (Object)this.timedMetadataInsertion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdAvailOffset": {
                return Optional.of(clazz.cast(this.adAvailOffset()));
            }
            case "AvailBlanking": {
                return Optional.of(clazz.cast(this.availBlanking()));
            }
            case "Inputs": {
                return Optional.of(clazz.cast(this.inputs()));
            }
            case "NielsenConfiguration": {
                return Optional.of(clazz.cast(this.nielsenConfiguration()));
            }
            case "OutputGroups": {
                return Optional.of(clazz.cast(this.outputGroups()));
            }
            case "TimecodeConfig": {
                return Optional.of(clazz.cast(this.timecodeConfig()));
            }
            case "TimedMetadataInsertion": {
                return Optional.of(clazz.cast(this.timedMetadataInsertion()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer adAvailOffset;
        private AvailBlanking availBlanking;
        private List<Input> inputs;
        private NielsenConfiguration nielsenConfiguration;
        private List<OutputGroup> outputGroups;
        private TimecodeConfig timecodeConfig;
        private TimedMetadataInsertion timedMetadataInsertion;

        private BuilderImpl() {
        }

        private BuilderImpl(JobSettings model) {
            this.adAvailOffset(model.adAvailOffset);
            this.availBlanking(model.availBlanking);
            this.inputs(model.inputs);
            this.nielsenConfiguration(model.nielsenConfiguration);
            this.outputGroups(model.outputGroups);
            this.timecodeConfig(model.timecodeConfig);
            this.timedMetadataInsertion(model.timedMetadataInsertion);
        }

        public final Integer getAdAvailOffset() {
            return this.adAvailOffset;
        }

        @Override
        public final Builder adAvailOffset(Integer adAvailOffset) {
            this.adAvailOffset = adAvailOffset;
            return this;
        }

        public final void setAdAvailOffset(Integer adAvailOffset) {
            this.adAvailOffset = adAvailOffset;
        }

        public final AvailBlanking.Builder getAvailBlanking() {
            return this.availBlanking != null ? this.availBlanking.toBuilder() : null;
        }

        @Override
        public final Builder availBlanking(AvailBlanking availBlanking) {
            this.availBlanking = availBlanking;
            return this;
        }

        public final void setAvailBlanking(AvailBlanking.BuilderImpl availBlanking) {
            this.availBlanking = availBlanking != null ? availBlanking.build() : null;
        }

        public final Collection<Input.Builder> getInputs() {
            return this.inputs != null ? (Collection)this.inputs.stream().map(Input::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputs(Collection<Input> inputs) {
            this.inputs = ListOfInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Input ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Consumer<Input.Builder> ... inputs) {
            this.inputs(Stream.of(inputs).map(c -> (Input)((Input.Builder)Input.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInputs(Collection<Input.BuilderImpl> inputs) {
            this.inputs = ListOfInputCopier.copyFromBuilder(inputs);
        }

        public final NielsenConfiguration.Builder getNielsenConfiguration() {
            return this.nielsenConfiguration != null ? this.nielsenConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder nielsenConfiguration(NielsenConfiguration nielsenConfiguration) {
            this.nielsenConfiguration = nielsenConfiguration;
            return this;
        }

        public final void setNielsenConfiguration(NielsenConfiguration.BuilderImpl nielsenConfiguration) {
            this.nielsenConfiguration = nielsenConfiguration != null ? nielsenConfiguration.build() : null;
        }

        public final Collection<OutputGroup.Builder> getOutputGroups() {
            return this.outputGroups != null ? (Collection)this.outputGroups.stream().map(OutputGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outputGroups(Collection<OutputGroup> outputGroups) {
            this.outputGroups = ListOfOutputGroupCopier.copy(outputGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputGroups(OutputGroup ... outputGroups) {
            this.outputGroups(Arrays.asList(outputGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputGroups(Consumer<OutputGroup.Builder> ... outputGroups) {
            this.outputGroups(Stream.of(outputGroups).map(c -> (OutputGroup)((OutputGroup.Builder)OutputGroup.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOutputGroups(Collection<OutputGroup.BuilderImpl> outputGroups) {
            this.outputGroups = ListOfOutputGroupCopier.copyFromBuilder(outputGroups);
        }

        public final TimecodeConfig.Builder getTimecodeConfig() {
            return this.timecodeConfig != null ? this.timecodeConfig.toBuilder() : null;
        }

        @Override
        public final Builder timecodeConfig(TimecodeConfig timecodeConfig) {
            this.timecodeConfig = timecodeConfig;
            return this;
        }

        public final void setTimecodeConfig(TimecodeConfig.BuilderImpl timecodeConfig) {
            this.timecodeConfig = timecodeConfig != null ? timecodeConfig.build() : null;
        }

        public final TimedMetadataInsertion.Builder getTimedMetadataInsertion() {
            return this.timedMetadataInsertion != null ? this.timedMetadataInsertion.toBuilder() : null;
        }

        @Override
        public final Builder timedMetadataInsertion(TimedMetadataInsertion timedMetadataInsertion) {
            this.timedMetadataInsertion = timedMetadataInsertion;
            return this;
        }

        public final void setTimedMetadataInsertion(TimedMetadataInsertion.BuilderImpl timedMetadataInsertion) {
            this.timedMetadataInsertion = timedMetadataInsertion != null ? timedMetadataInsertion.build() : null;
        }

        public JobSettings build() {
            return new JobSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, JobSettings> {
        public Builder adAvailOffset(Integer var1);

        public Builder availBlanking(AvailBlanking var1);

        default public Builder availBlanking(Consumer<AvailBlanking.Builder> availBlanking) {
            return this.availBlanking((AvailBlanking)((AvailBlanking.Builder)AvailBlanking.builder().apply(availBlanking)).build());
        }

        public Builder inputs(Collection<Input> var1);

        public Builder inputs(Input ... var1);

        public Builder inputs(Consumer<Input.Builder> ... var1);

        public Builder nielsenConfiguration(NielsenConfiguration var1);

        default public Builder nielsenConfiguration(Consumer<NielsenConfiguration.Builder> nielsenConfiguration) {
            return this.nielsenConfiguration((NielsenConfiguration)((NielsenConfiguration.Builder)NielsenConfiguration.builder().apply(nielsenConfiguration)).build());
        }

        public Builder outputGroups(Collection<OutputGroup> var1);

        public Builder outputGroups(OutputGroup ... var1);

        public Builder outputGroups(Consumer<OutputGroup.Builder> ... var1);

        public Builder timecodeConfig(TimecodeConfig var1);

        default public Builder timecodeConfig(Consumer<TimecodeConfig.Builder> timecodeConfig) {
            return this.timecodeConfig((TimecodeConfig)((TimecodeConfig.Builder)TimecodeConfig.builder().apply(timecodeConfig)).build());
        }

        public Builder timedMetadataInsertion(TimedMetadataInsertion var1);

        default public Builder timedMetadataInsertion(Consumer<TimedMetadataInsertion.Builder> timedMetadataInsertion) {
            return this.timedMetadataInsertion((TimedMetadataInsertion)((TimedMetadataInsertion.Builder)TimedMetadataInsertion.builder().apply(timedMetadataInsertion)).build());
        }
    }
}

