/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.AudioSelector;
import software.amazon.awssdk.services.mediaconvert.model.AudioSelectorGroup;
import software.amazon.awssdk.services.mediaconvert.model.CaptionSelector;
import software.amazon.awssdk.services.mediaconvert.model.InputClipping;
import software.amazon.awssdk.services.mediaconvert.model.InputDeblockFilter;
import software.amazon.awssdk.services.mediaconvert.model.InputDenoiseFilter;
import software.amazon.awssdk.services.mediaconvert.model.InputFilterEnable;
import software.amazon.awssdk.services.mediaconvert.model.InputPsiControl;
import software.amazon.awssdk.services.mediaconvert.model.InputTimecodeSource;
import software.amazon.awssdk.services.mediaconvert.model.ListOfInputClippingCopier;
import software.amazon.awssdk.services.mediaconvert.model.MapOfAudioSelectorCopier;
import software.amazon.awssdk.services.mediaconvert.model.MapOfAudioSelectorGroupCopier;
import software.amazon.awssdk.services.mediaconvert.model.MapOfCaptionSelectorCopier;
import software.amazon.awssdk.services.mediaconvert.model.VideoSelector;
import software.amazon.awssdk.services.mediaconvert.transform.InputTemplateMarshaller;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InputTemplate
implements StructuredPojo,
ToCopyableBuilder<Builder, InputTemplate> {
    private final Map<String, AudioSelectorGroup> audioSelectorGroups;
    private final Map<String, AudioSelector> audioSelectors;
    private final Map<String, CaptionSelector> captionSelectors;
    private final String deblockFilter;
    private final String denoiseFilter;
    private final String filterEnable;
    private final Integer filterStrength;
    private final List<InputClipping> inputClippings;
    private final Integer programNumber;
    private final String psiControl;
    private final String timecodeSource;
    private final VideoSelector videoSelector;

    private InputTemplate(BuilderImpl builder) {
        this.audioSelectorGroups = builder.audioSelectorGroups;
        this.audioSelectors = builder.audioSelectors;
        this.captionSelectors = builder.captionSelectors;
        this.deblockFilter = builder.deblockFilter;
        this.denoiseFilter = builder.denoiseFilter;
        this.filterEnable = builder.filterEnable;
        this.filterStrength = builder.filterStrength;
        this.inputClippings = builder.inputClippings;
        this.programNumber = builder.programNumber;
        this.psiControl = builder.psiControl;
        this.timecodeSource = builder.timecodeSource;
        this.videoSelector = builder.videoSelector;
    }

    public Map<String, AudioSelectorGroup> audioSelectorGroups() {
        return this.audioSelectorGroups;
    }

    public Map<String, AudioSelector> audioSelectors() {
        return this.audioSelectors;
    }

    public Map<String, CaptionSelector> captionSelectors() {
        return this.captionSelectors;
    }

    public InputDeblockFilter deblockFilter() {
        return InputDeblockFilter.fromValue(this.deblockFilter);
    }

    public String deblockFilterAsString() {
        return this.deblockFilter;
    }

    public InputDenoiseFilter denoiseFilter() {
        return InputDenoiseFilter.fromValue(this.denoiseFilter);
    }

    public String denoiseFilterAsString() {
        return this.denoiseFilter;
    }

    public InputFilterEnable filterEnable() {
        return InputFilterEnable.fromValue(this.filterEnable);
    }

    public String filterEnableAsString() {
        return this.filterEnable;
    }

    public Integer filterStrength() {
        return this.filterStrength;
    }

    public List<InputClipping> inputClippings() {
        return this.inputClippings;
    }

    public Integer programNumber() {
        return this.programNumber;
    }

    public InputPsiControl psiControl() {
        return InputPsiControl.fromValue(this.psiControl);
    }

    public String psiControlAsString() {
        return this.psiControl;
    }

    public InputTimecodeSource timecodeSource() {
        return InputTimecodeSource.fromValue(this.timecodeSource);
    }

    public String timecodeSourceAsString() {
        return this.timecodeSource;
    }

    public VideoSelector videoSelector() {
        return this.videoSelector;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioSelectorGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioSelectors());
        hashCode = 31 * hashCode + Objects.hashCode(this.captionSelectors());
        hashCode = 31 * hashCode + Objects.hashCode(this.deblockFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.denoiseFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterEnableAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterStrength());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputClippings());
        hashCode = 31 * hashCode + Objects.hashCode(this.programNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.psiControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timecodeSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoSelector());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputTemplate)) {
            return false;
        }
        InputTemplate other = (InputTemplate)obj;
        return Objects.equals(this.audioSelectorGroups(), other.audioSelectorGroups()) && Objects.equals(this.audioSelectors(), other.audioSelectors()) && Objects.equals(this.captionSelectors(), other.captionSelectors()) && Objects.equals(this.deblockFilterAsString(), other.deblockFilterAsString()) && Objects.equals(this.denoiseFilterAsString(), other.denoiseFilterAsString()) && Objects.equals(this.filterEnableAsString(), other.filterEnableAsString()) && Objects.equals(this.filterStrength(), other.filterStrength()) && Objects.equals(this.inputClippings(), other.inputClippings()) && Objects.equals(this.programNumber(), other.programNumber()) && Objects.equals(this.psiControlAsString(), other.psiControlAsString()) && Objects.equals(this.timecodeSourceAsString(), other.timecodeSourceAsString()) && Objects.equals(this.videoSelector(), other.videoSelector());
    }

    public String toString() {
        return ToString.builder((String)"InputTemplate").add("AudioSelectorGroups", this.audioSelectorGroups()).add("AudioSelectors", this.audioSelectors()).add("CaptionSelectors", this.captionSelectors()).add("DeblockFilter", (Object)this.deblockFilterAsString()).add("DenoiseFilter", (Object)this.denoiseFilterAsString()).add("FilterEnable", (Object)this.filterEnableAsString()).add("FilterStrength", (Object)this.filterStrength()).add("InputClippings", this.inputClippings()).add("ProgramNumber", (Object)this.programNumber()).add("PsiControl", (Object)this.psiControlAsString()).add("TimecodeSource", (Object)this.timecodeSourceAsString()).add("VideoSelector", (Object)this.videoSelector()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioSelectorGroups": {
                return Optional.of(clazz.cast(this.audioSelectorGroups()));
            }
            case "AudioSelectors": {
                return Optional.of(clazz.cast(this.audioSelectors()));
            }
            case "CaptionSelectors": {
                return Optional.of(clazz.cast(this.captionSelectors()));
            }
            case "DeblockFilter": {
                return Optional.of(clazz.cast(this.deblockFilterAsString()));
            }
            case "DenoiseFilter": {
                return Optional.of(clazz.cast(this.denoiseFilterAsString()));
            }
            case "FilterEnable": {
                return Optional.of(clazz.cast(this.filterEnableAsString()));
            }
            case "FilterStrength": {
                return Optional.of(clazz.cast(this.filterStrength()));
            }
            case "InputClippings": {
                return Optional.of(clazz.cast(this.inputClippings()));
            }
            case "ProgramNumber": {
                return Optional.of(clazz.cast(this.programNumber()));
            }
            case "PsiControl": {
                return Optional.of(clazz.cast(this.psiControlAsString()));
            }
            case "TimecodeSource": {
                return Optional.of(clazz.cast(this.timecodeSourceAsString()));
            }
            case "VideoSelector": {
                return Optional.of(clazz.cast(this.videoSelector()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputTemplateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, AudioSelectorGroup> audioSelectorGroups;
        private Map<String, AudioSelector> audioSelectors;
        private Map<String, CaptionSelector> captionSelectors;
        private String deblockFilter;
        private String denoiseFilter;
        private String filterEnable;
        private Integer filterStrength;
        private List<InputClipping> inputClippings;
        private Integer programNumber;
        private String psiControl;
        private String timecodeSource;
        private VideoSelector videoSelector;

        private BuilderImpl() {
        }

        private BuilderImpl(InputTemplate model) {
            this.audioSelectorGroups(model.audioSelectorGroups);
            this.audioSelectors(model.audioSelectors);
            this.captionSelectors(model.captionSelectors);
            this.deblockFilter(model.deblockFilter);
            this.denoiseFilter(model.denoiseFilter);
            this.filterEnable(model.filterEnable);
            this.filterStrength(model.filterStrength);
            this.inputClippings(model.inputClippings);
            this.programNumber(model.programNumber);
            this.psiControl(model.psiControl);
            this.timecodeSource(model.timecodeSource);
            this.videoSelector(model.videoSelector);
        }

        public final Map<String, AudioSelectorGroup.Builder> getAudioSelectorGroups() {
            return this.audioSelectorGroups != null ? CollectionUtils.mapValues(this.audioSelectorGroups, AudioSelectorGroup::toBuilder) : null;
        }

        @Override
        public final Builder audioSelectorGroups(Map<String, AudioSelectorGroup> audioSelectorGroups) {
            this.audioSelectorGroups = MapOfAudioSelectorGroupCopier.copy(audioSelectorGroups);
            return this;
        }

        public final void setAudioSelectorGroups(Map<String, AudioSelectorGroup.BuilderImpl> audioSelectorGroups) {
            this.audioSelectorGroups = MapOfAudioSelectorGroupCopier.copyFromBuilder(audioSelectorGroups);
        }

        public final Map<String, AudioSelector.Builder> getAudioSelectors() {
            return this.audioSelectors != null ? CollectionUtils.mapValues(this.audioSelectors, AudioSelector::toBuilder) : null;
        }

        @Override
        public final Builder audioSelectors(Map<String, AudioSelector> audioSelectors) {
            this.audioSelectors = MapOfAudioSelectorCopier.copy(audioSelectors);
            return this;
        }

        public final void setAudioSelectors(Map<String, AudioSelector.BuilderImpl> audioSelectors) {
            this.audioSelectors = MapOfAudioSelectorCopier.copyFromBuilder(audioSelectors);
        }

        public final Map<String, CaptionSelector.Builder> getCaptionSelectors() {
            return this.captionSelectors != null ? CollectionUtils.mapValues(this.captionSelectors, CaptionSelector::toBuilder) : null;
        }

        @Override
        public final Builder captionSelectors(Map<String, CaptionSelector> captionSelectors) {
            this.captionSelectors = MapOfCaptionSelectorCopier.copy(captionSelectors);
            return this;
        }

        public final void setCaptionSelectors(Map<String, CaptionSelector.BuilderImpl> captionSelectors) {
            this.captionSelectors = MapOfCaptionSelectorCopier.copyFromBuilder(captionSelectors);
        }

        public final String getDeblockFilter() {
            return this.deblockFilter;
        }

        @Override
        public final Builder deblockFilter(String deblockFilter) {
            this.deblockFilter = deblockFilter;
            return this;
        }

        @Override
        public final Builder deblockFilter(InputDeblockFilter deblockFilter) {
            this.deblockFilter(deblockFilter.toString());
            return this;
        }

        public final void setDeblockFilter(String deblockFilter) {
            this.deblockFilter = deblockFilter;
        }

        public final String getDenoiseFilter() {
            return this.denoiseFilter;
        }

        @Override
        public final Builder denoiseFilter(String denoiseFilter) {
            this.denoiseFilter = denoiseFilter;
            return this;
        }

        @Override
        public final Builder denoiseFilter(InputDenoiseFilter denoiseFilter) {
            this.denoiseFilter(denoiseFilter.toString());
            return this;
        }

        public final void setDenoiseFilter(String denoiseFilter) {
            this.denoiseFilter = denoiseFilter;
        }

        public final String getFilterEnable() {
            return this.filterEnable;
        }

        @Override
        public final Builder filterEnable(String filterEnable) {
            this.filterEnable = filterEnable;
            return this;
        }

        @Override
        public final Builder filterEnable(InputFilterEnable filterEnable) {
            this.filterEnable(filterEnable.toString());
            return this;
        }

        public final void setFilterEnable(String filterEnable) {
            this.filterEnable = filterEnable;
        }

        public final Integer getFilterStrength() {
            return this.filterStrength;
        }

        @Override
        public final Builder filterStrength(Integer filterStrength) {
            this.filterStrength = filterStrength;
            return this;
        }

        public final void setFilterStrength(Integer filterStrength) {
            this.filterStrength = filterStrength;
        }

        public final Collection<InputClipping.Builder> getInputClippings() {
            return this.inputClippings != null ? (Collection)this.inputClippings.stream().map(InputClipping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputClippings(Collection<InputClipping> inputClippings) {
            this.inputClippings = ListOfInputClippingCopier.copy(inputClippings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputClippings(InputClipping ... inputClippings) {
            this.inputClippings(Arrays.asList(inputClippings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputClippings(Consumer<InputClipping.Builder> ... inputClippings) {
            this.inputClippings(Stream.of(inputClippings).map(c -> (InputClipping)((InputClipping.Builder)InputClipping.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInputClippings(Collection<InputClipping.BuilderImpl> inputClippings) {
            this.inputClippings = ListOfInputClippingCopier.copyFromBuilder(inputClippings);
        }

        public final Integer getProgramNumber() {
            return this.programNumber;
        }

        @Override
        public final Builder programNumber(Integer programNumber) {
            this.programNumber = programNumber;
            return this;
        }

        public final void setProgramNumber(Integer programNumber) {
            this.programNumber = programNumber;
        }

        public final String getPsiControl() {
            return this.psiControl;
        }

        @Override
        public final Builder psiControl(String psiControl) {
            this.psiControl = psiControl;
            return this;
        }

        @Override
        public final Builder psiControl(InputPsiControl psiControl) {
            this.psiControl(psiControl.toString());
            return this;
        }

        public final void setPsiControl(String psiControl) {
            this.psiControl = psiControl;
        }

        public final String getTimecodeSource() {
            return this.timecodeSource;
        }

        @Override
        public final Builder timecodeSource(String timecodeSource) {
            this.timecodeSource = timecodeSource;
            return this;
        }

        @Override
        public final Builder timecodeSource(InputTimecodeSource timecodeSource) {
            this.timecodeSource(timecodeSource.toString());
            return this;
        }

        public final void setTimecodeSource(String timecodeSource) {
            this.timecodeSource = timecodeSource;
        }

        public final VideoSelector.Builder getVideoSelector() {
            return this.videoSelector != null ? this.videoSelector.toBuilder() : null;
        }

        @Override
        public final Builder videoSelector(VideoSelector videoSelector) {
            this.videoSelector = videoSelector;
            return this;
        }

        public final void setVideoSelector(VideoSelector.BuilderImpl videoSelector) {
            this.videoSelector = videoSelector != null ? videoSelector.build() : null;
        }

        public InputTemplate build() {
            return new InputTemplate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InputTemplate> {
        public Builder audioSelectorGroups(Map<String, AudioSelectorGroup> var1);

        public Builder audioSelectors(Map<String, AudioSelector> var1);

        public Builder captionSelectors(Map<String, CaptionSelector> var1);

        public Builder deblockFilter(String var1);

        public Builder deblockFilter(InputDeblockFilter var1);

        public Builder denoiseFilter(String var1);

        public Builder denoiseFilter(InputDenoiseFilter var1);

        public Builder filterEnable(String var1);

        public Builder filterEnable(InputFilterEnable var1);

        public Builder filterStrength(Integer var1);

        public Builder inputClippings(Collection<InputClipping> var1);

        public Builder inputClippings(InputClipping ... var1);

        public Builder inputClippings(Consumer<InputClipping.Builder> ... var1);

        public Builder programNumber(Integer var1);

        public Builder psiControl(String var1);

        public Builder psiControl(InputPsiControl var1);

        public Builder timecodeSource(String var1);

        public Builder timecodeSource(InputTimecodeSource var1);

        public Builder videoSelector(VideoSelector var1);

        default public Builder videoSelector(Consumer<VideoSelector.Builder> videoSelector) {
            return this.videoSelector((VideoSelector)((VideoSelector.Builder)VideoSelector.builder().apply(videoSelector)).build());
        }
    }
}

