/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.AacSettings;
import software.amazon.awssdk.services.mediaconvert.model.Ac3Settings;
import software.amazon.awssdk.services.mediaconvert.model.AiffSettings;
import software.amazon.awssdk.services.mediaconvert.model.AudioCodec;
import software.amazon.awssdk.services.mediaconvert.model.Eac3Settings;
import software.amazon.awssdk.services.mediaconvert.model.Mp2Settings;
import software.amazon.awssdk.services.mediaconvert.model.WavSettings;
import software.amazon.awssdk.services.mediaconvert.transform.AudioCodecSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AudioCodecSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, AudioCodecSettings> {
    private final AacSettings aacSettings;
    private final Ac3Settings ac3Settings;
    private final AiffSettings aiffSettings;
    private final String codec;
    private final Eac3Settings eac3Settings;
    private final Mp2Settings mp2Settings;
    private final WavSettings wavSettings;

    private AudioCodecSettings(BuilderImpl builder) {
        this.aacSettings = builder.aacSettings;
        this.ac3Settings = builder.ac3Settings;
        this.aiffSettings = builder.aiffSettings;
        this.codec = builder.codec;
        this.eac3Settings = builder.eac3Settings;
        this.mp2Settings = builder.mp2Settings;
        this.wavSettings = builder.wavSettings;
    }

    public AacSettings aacSettings() {
        return this.aacSettings;
    }

    public Ac3Settings ac3Settings() {
        return this.ac3Settings;
    }

    public AiffSettings aiffSettings() {
        return this.aiffSettings;
    }

    public AudioCodec codec() {
        return AudioCodec.fromValue(this.codec);
    }

    public String codecAsString() {
        return this.codec;
    }

    public Eac3Settings eac3Settings() {
        return this.eac3Settings;
    }

    public Mp2Settings mp2Settings() {
        return this.mp2Settings;
    }

    public WavSettings wavSettings() {
        return this.wavSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.aacSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.ac3Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.aiffSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eac3Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.mp2Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.wavSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioCodecSettings)) {
            return false;
        }
        AudioCodecSettings other = (AudioCodecSettings)obj;
        return Objects.equals(this.aacSettings(), other.aacSettings()) && Objects.equals(this.ac3Settings(), other.ac3Settings()) && Objects.equals(this.aiffSettings(), other.aiffSettings()) && Objects.equals(this.codecAsString(), other.codecAsString()) && Objects.equals(this.eac3Settings(), other.eac3Settings()) && Objects.equals(this.mp2Settings(), other.mp2Settings()) && Objects.equals(this.wavSettings(), other.wavSettings());
    }

    public String toString() {
        return ToString.builder((String)"AudioCodecSettings").add("AacSettings", (Object)this.aacSettings()).add("Ac3Settings", (Object)this.ac3Settings()).add("AiffSettings", (Object)this.aiffSettings()).add("Codec", (Object)this.codecAsString()).add("Eac3Settings", (Object)this.eac3Settings()).add("Mp2Settings", (Object)this.mp2Settings()).add("WavSettings", (Object)this.wavSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AacSettings": {
                return Optional.of(clazz.cast(this.aacSettings()));
            }
            case "Ac3Settings": {
                return Optional.of(clazz.cast(this.ac3Settings()));
            }
            case "AiffSettings": {
                return Optional.of(clazz.cast(this.aiffSettings()));
            }
            case "Codec": {
                return Optional.of(clazz.cast(this.codecAsString()));
            }
            case "Eac3Settings": {
                return Optional.of(clazz.cast(this.eac3Settings()));
            }
            case "Mp2Settings": {
                return Optional.of(clazz.cast(this.mp2Settings()));
            }
            case "WavSettings": {
                return Optional.of(clazz.cast(this.wavSettings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AudioCodecSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private AacSettings aacSettings;
        private Ac3Settings ac3Settings;
        private AiffSettings aiffSettings;
        private String codec;
        private Eac3Settings eac3Settings;
        private Mp2Settings mp2Settings;
        private WavSettings wavSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioCodecSettings model) {
            this.aacSettings(model.aacSettings);
            this.ac3Settings(model.ac3Settings);
            this.aiffSettings(model.aiffSettings);
            this.codec(model.codec);
            this.eac3Settings(model.eac3Settings);
            this.mp2Settings(model.mp2Settings);
            this.wavSettings(model.wavSettings);
        }

        public final AacSettings.Builder getAacSettings() {
            return this.aacSettings != null ? this.aacSettings.toBuilder() : null;
        }

        @Override
        public final Builder aacSettings(AacSettings aacSettings) {
            this.aacSettings = aacSettings;
            return this;
        }

        public final void setAacSettings(AacSettings.BuilderImpl aacSettings) {
            this.aacSettings = aacSettings != null ? aacSettings.build() : null;
        }

        public final Ac3Settings.Builder getAc3Settings() {
            return this.ac3Settings != null ? this.ac3Settings.toBuilder() : null;
        }

        @Override
        public final Builder ac3Settings(Ac3Settings ac3Settings) {
            this.ac3Settings = ac3Settings;
            return this;
        }

        public final void setAc3Settings(Ac3Settings.BuilderImpl ac3Settings) {
            this.ac3Settings = ac3Settings != null ? ac3Settings.build() : null;
        }

        public final AiffSettings.Builder getAiffSettings() {
            return this.aiffSettings != null ? this.aiffSettings.toBuilder() : null;
        }

        @Override
        public final Builder aiffSettings(AiffSettings aiffSettings) {
            this.aiffSettings = aiffSettings;
            return this;
        }

        public final void setAiffSettings(AiffSettings.BuilderImpl aiffSettings) {
            this.aiffSettings = aiffSettings != null ? aiffSettings.build() : null;
        }

        public final String getCodec() {
            return this.codec;
        }

        @Override
        public final Builder codec(String codec) {
            this.codec = codec;
            return this;
        }

        @Override
        public final Builder codec(AudioCodec codec) {
            this.codec(codec.toString());
            return this;
        }

        public final void setCodec(String codec) {
            this.codec = codec;
        }

        public final Eac3Settings.Builder getEac3Settings() {
            return this.eac3Settings != null ? this.eac3Settings.toBuilder() : null;
        }

        @Override
        public final Builder eac3Settings(Eac3Settings eac3Settings) {
            this.eac3Settings = eac3Settings;
            return this;
        }

        public final void setEac3Settings(Eac3Settings.BuilderImpl eac3Settings) {
            this.eac3Settings = eac3Settings != null ? eac3Settings.build() : null;
        }

        public final Mp2Settings.Builder getMp2Settings() {
            return this.mp2Settings != null ? this.mp2Settings.toBuilder() : null;
        }

        @Override
        public final Builder mp2Settings(Mp2Settings mp2Settings) {
            this.mp2Settings = mp2Settings;
            return this;
        }

        public final void setMp2Settings(Mp2Settings.BuilderImpl mp2Settings) {
            this.mp2Settings = mp2Settings != null ? mp2Settings.build() : null;
        }

        public final WavSettings.Builder getWavSettings() {
            return this.wavSettings != null ? this.wavSettings.toBuilder() : null;
        }

        @Override
        public final Builder wavSettings(WavSettings wavSettings) {
            this.wavSettings = wavSettings;
            return this;
        }

        public final void setWavSettings(WavSettings.BuilderImpl wavSettings) {
            this.wavSettings = wavSettings != null ? wavSettings.build() : null;
        }

        public AudioCodecSettings build() {
            return new AudioCodecSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AudioCodecSettings> {
        public Builder aacSettings(AacSettings var1);

        default public Builder aacSettings(Consumer<AacSettings.Builder> aacSettings) {
            return this.aacSettings((AacSettings)((AacSettings.Builder)AacSettings.builder().apply(aacSettings)).build());
        }

        public Builder ac3Settings(Ac3Settings var1);

        default public Builder ac3Settings(Consumer<Ac3Settings.Builder> ac3Settings) {
            return this.ac3Settings((Ac3Settings)((Ac3Settings.Builder)Ac3Settings.builder().apply(ac3Settings)).build());
        }

        public Builder aiffSettings(AiffSettings var1);

        default public Builder aiffSettings(Consumer<AiffSettings.Builder> aiffSettings) {
            return this.aiffSettings((AiffSettings)((AiffSettings.Builder)AiffSettings.builder().apply(aiffSettings)).build());
        }

        public Builder codec(String var1);

        public Builder codec(AudioCodec var1);

        public Builder eac3Settings(Eac3Settings var1);

        default public Builder eac3Settings(Consumer<Eac3Settings.Builder> eac3Settings) {
            return this.eac3Settings((Eac3Settings)((Eac3Settings.Builder)Eac3Settings.builder().apply(eac3Settings)).build());
        }

        public Builder mp2Settings(Mp2Settings var1);

        default public Builder mp2Settings(Consumer<Mp2Settings.Builder> mp2Settings) {
            return this.mp2Settings((Mp2Settings)((Mp2Settings.Builder)Mp2Settings.builder().apply(mp2Settings)).build());
        }

        public Builder wavSettings(WavSettings var1);

        default public Builder wavSettings(Consumer<WavSettings.Builder> wavSettings) {
            return this.wavSettings((WavSettings)((WavSettings.Builder)WavSettings.builder().apply(wavSettings)).build());
        }
    }
}

