/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediaconnect.MediaConnectClient;
import software.amazon.awssdk.services.mediaconnect.model.ListFlowsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListFlowsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListedFlow;

public class ListFlowsIterable
implements SdkIterable<ListFlowsResponse> {
    private final MediaConnectClient client;
    private final ListFlowsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFlowsIterable(MediaConnectClient client, ListFlowsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListFlowsResponseFetcher();
    }

    public Iterator<ListFlowsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListedFlow> flows() {
        Function<ListFlowsResponse, Iterator> getIterator = response -> {
            if (response != null && response.flows() != null) {
                return response.flows().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFlowsResponseFetcher
    implements SyncPageFetcher<ListFlowsResponse> {
        private ListFlowsResponseFetcher() {
        }

        public boolean hasNextPage(ListFlowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFlowsResponse nextPage(ListFlowsResponse previousPage) {
            if (previousPage == null) {
                return ListFlowsIterable.this.client.listFlows(ListFlowsIterable.this.firstRequest);
            }
            return ListFlowsIterable.this.client.listFlows((ListFlowsRequest)((Object)ListFlowsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

