/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.Encryption;
import software.amazon.awssdk.services.mediaconnect.model.Protocol;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddOutputRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AddOutputRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AddOutputRequest.getter(AddOutputRequest::description)).setter(AddOutputRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AddOutputRequest.getter(AddOutputRequest::destination)).setter(AddOutputRequest.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<Encryption> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AddOutputRequest.getter(AddOutputRequest::encryption)).setter(AddOutputRequest.setter(Builder::encryption)).constructor(Encryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()}).build();
    private static final SdkField<Integer> MAX_LATENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(AddOutputRequest.getter(AddOutputRequest::maxLatency)).setter(AddOutputRequest.setter(Builder::maxLatency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxLatency").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AddOutputRequest.getter(AddOutputRequest::name)).setter(AddOutputRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(AddOutputRequest.getter(AddOutputRequest::port)).setter(AddOutputRequest.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AddOutputRequest.getter(AddOutputRequest::protocolAsString)).setter(AddOutputRequest.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final SdkField<Integer> SMOOTHING_LATENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(AddOutputRequest.getter(AddOutputRequest::smoothingLatency)).setter(AddOutputRequest.setter(Builder::smoothingLatency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smoothingLatency").build()}).build();
    private static final SdkField<String> STREAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AddOutputRequest.getter(AddOutputRequest::streamId)).setter(AddOutputRequest.setter(Builder::streamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, DESTINATION_FIELD, ENCRYPTION_FIELD, MAX_LATENCY_FIELD, NAME_FIELD, PORT_FIELD, PROTOCOL_FIELD, SMOOTHING_LATENCY_FIELD, STREAM_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String description;
    private final String destination;
    private final Encryption encryption;
    private final Integer maxLatency;
    private final String name;
    private final Integer port;
    private final String protocol;
    private final Integer smoothingLatency;
    private final String streamId;

    private AddOutputRequest(BuilderImpl builder) {
        this.description = builder.description;
        this.destination = builder.destination;
        this.encryption = builder.encryption;
        this.maxLatency = builder.maxLatency;
        this.name = builder.name;
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.smoothingLatency = builder.smoothingLatency;
        this.streamId = builder.streamId;
    }

    public String description() {
        return this.description;
    }

    public String destination() {
        return this.destination;
    }

    public Encryption encryption() {
        return this.encryption;
    }

    public Integer maxLatency() {
        return this.maxLatency;
    }

    public String name() {
        return this.name;
    }

    public Integer port() {
        return this.port;
    }

    public Protocol protocol() {
        return Protocol.fromValue(this.protocol);
    }

    public String protocolAsString() {
        return this.protocol;
    }

    public Integer smoothingLatency() {
        return this.smoothingLatency;
    }

    public String streamId() {
        return this.streamId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxLatency());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.smoothingLatency());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddOutputRequest)) {
            return false;
        }
        AddOutputRequest other = (AddOutputRequest)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.encryption(), other.encryption()) && Objects.equals(this.maxLatency(), other.maxLatency()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.smoothingLatency(), other.smoothingLatency()) && Objects.equals(this.streamId(), other.streamId());
    }

    public String toString() {
        return ToString.builder((String)"AddOutputRequest").add("Description", (Object)this.description()).add("Destination", (Object)this.destination()).add("Encryption", (Object)this.encryption()).add("MaxLatency", (Object)this.maxLatency()).add("Name", (Object)this.name()).add("Port", (Object)this.port()).add("Protocol", (Object)this.protocolAsString()).add("SmoothingLatency", (Object)this.smoothingLatency()).add("StreamId", (Object)this.streamId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
            case "MaxLatency": {
                return Optional.ofNullable(clazz.cast(this.maxLatency()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "SmoothingLatency": {
                return Optional.ofNullable(clazz.cast(this.smoothingLatency()));
            }
            case "StreamId": {
                return Optional.ofNullable(clazz.cast(this.streamId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddOutputRequest, T> g) {
        return obj -> g.apply((AddOutputRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String destination;
        private Encryption encryption;
        private Integer maxLatency;
        private String name;
        private Integer port;
        private String protocol;
        private Integer smoothingLatency;
        private String streamId;

        private BuilderImpl() {
        }

        private BuilderImpl(AddOutputRequest model) {
            this.description(model.description);
            this.destination(model.destination);
            this.encryption(model.encryption);
            this.maxLatency(model.maxLatency);
            this.name(model.name);
            this.port(model.port);
            this.protocol(model.protocol);
            this.smoothingLatency(model.smoothingLatency);
            this.streamId(model.streamId);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDestination() {
            return this.destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        public final Encryption.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(Encryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(Encryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final Integer getMaxLatency() {
            return this.maxLatency;
        }

        @Override
        public final Builder maxLatency(Integer maxLatency) {
            this.maxLatency = maxLatency;
            return this;
        }

        public final void setMaxLatency(Integer maxLatency) {
            this.maxLatency = maxLatency;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getProtocolAsString() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final Integer getSmoothingLatency() {
            return this.smoothingLatency;
        }

        @Override
        public final Builder smoothingLatency(Integer smoothingLatency) {
            this.smoothingLatency = smoothingLatency;
            return this;
        }

        public final void setSmoothingLatency(Integer smoothingLatency) {
            this.smoothingLatency = smoothingLatency;
        }

        public final String getStreamId() {
            return this.streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        public AddOutputRequest build() {
            return new AddOutputRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AddOutputRequest> {
        public Builder description(String var1);

        public Builder destination(String var1);

        public Builder encryption(Encryption var1);

        default public Builder encryption(Consumer<Encryption.Builder> encryption) {
            return this.encryption((Encryption)((Encryption.Builder)Encryption.builder().applyMutation(encryption)).build());
        }

        public Builder maxLatency(Integer var1);

        public Builder name(String var1);

        public Builder port(Integer var1);

        public Builder protocol(String var1);

        public Builder protocol(Protocol var1);

        public Builder smoothingLatency(Integer var1);

        public Builder streamId(String var1);
    }
}

