/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WindowMaintenanceSchedule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WindowMaintenanceSchedule> {
    private static final SdkField<Instant> START_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Start").getter(WindowMaintenanceSchedule.getter(WindowMaintenanceSchedule::start)).setter(WindowMaintenanceSchedule.setter(Builder::start)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("start").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> END_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("End").getter(WindowMaintenanceSchedule.getter(WindowMaintenanceSchedule::end)).setter(WindowMaintenanceSchedule.setter(Builder::end)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("end").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> SCHEDULED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ScheduledTime").getter(WindowMaintenanceSchedule.getter(WindowMaintenanceSchedule::scheduledTime)).setter(WindowMaintenanceSchedule.setter(Builder::scheduledTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_FIELD, END_FIELD, SCHEDULED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WindowMaintenanceSchedule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant start;
    private final Instant end;
    private final Instant scheduledTime;

    private WindowMaintenanceSchedule(BuilderImpl builder) {
        this.start = builder.start;
        this.end = builder.end;
        this.scheduledTime = builder.scheduledTime;
    }

    public final Instant start() {
        return this.start;
    }

    public final Instant end() {
        return this.end;
    }

    public final Instant scheduledTime() {
        return this.scheduledTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.start());
        hashCode = 31 * hashCode + Objects.hashCode(this.end());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WindowMaintenanceSchedule)) {
            return false;
        }
        WindowMaintenanceSchedule other = (WindowMaintenanceSchedule)obj;
        return Objects.equals(this.start(), other.start()) && Objects.equals(this.end(), other.end()) && Objects.equals(this.scheduledTime(), other.scheduledTime());
    }

    public final String toString() {
        return ToString.builder((String)"WindowMaintenanceSchedule").add("Start", (Object)this.start()).add("End", (Object)this.end()).add("ScheduledTime", (Object)this.scheduledTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Start": {
                return Optional.ofNullable(clazz.cast(this.start()));
            }
            case "End": {
                return Optional.ofNullable(clazz.cast(this.end()));
            }
            case "ScheduledTime": {
                return Optional.ofNullable(clazz.cast(this.scheduledTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Instant>> map = new HashMap<String, SdkField<Instant>>();
        map.put("start", START_FIELD);
        map.put("end", END_FIELD);
        map.put("scheduledTime", SCHEDULED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WindowMaintenanceSchedule, T> g) {
        return obj -> g.apply((WindowMaintenanceSchedule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant start;
        private Instant end;
        private Instant scheduledTime;

        private BuilderImpl() {
        }

        private BuilderImpl(WindowMaintenanceSchedule model) {
            this.start(model.start);
            this.end(model.end);
            this.scheduledTime(model.scheduledTime);
        }

        public final Instant getStart() {
            return this.start;
        }

        public final void setStart(Instant start) {
            this.start = start;
        }

        @Override
        public final Builder start(Instant start) {
            this.start = start;
            return this;
        }

        public final Instant getEnd() {
            return this.end;
        }

        public final void setEnd(Instant end) {
            this.end = end;
        }

        @Override
        public final Builder end(Instant end) {
            this.end = end;
            return this;
        }

        public final Instant getScheduledTime() {
            return this.scheduledTime;
        }

        public final void setScheduledTime(Instant scheduledTime) {
            this.scheduledTime = scheduledTime;
        }

        @Override
        public final Builder scheduledTime(Instant scheduledTime) {
            this.scheduledTime = scheduledTime;
            return this;
        }

        public WindowMaintenanceSchedule build() {
            return new WindowMaintenanceSchedule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WindowMaintenanceSchedule> {
        public Builder start(Instant var1);

        public Builder end(Instant var1);

        public Builder scheduledTime(Instant var1);
    }
}

